/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfException;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Messages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.m2m.internal.qvt.oml.emf.util.modelparam.ModelparamFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.modelparam.ResourceEObject;
import org.eclipse.osgi.util.NLS;

public class EmfUtil {
    public static final Map DEFAULT_SAVE_OPTIONS = new HashMap();

    static {
        DEFAULT_SAVE_OPTIONS.put("ENCODING", "UTF-8");
    }

    private EmfUtil() {
    }

    public static EObject loadModel(URI uri) {
        return EmfUtil.loadModel(uri, EmfUtil.getDefaultLoadOptions());
    }

    public static EObject loadModel(URI uri, ResourceSet rs) {
        return EmfUtil.loadModel(uri, EmfUtil.getDefaultLoadOptions(), rs);
    }

    public static EObject loadModel(URI uri, Map options) {
        return EmfUtil.loadModel(uri, options, null);
    }

    public static EObject loadModel(URI uri, Map options, ResourceSet rs) {
        if (uri == null) {
            return null;
        }
        ResourceSet resourceSet = rs != null ? rs : EmfUtil.createResourceSet(options);
        String fragment = uri.fragment();
        if (fragment != null && fragment.length() > 0) {
            return resourceSet.getEObject(uri, true);
        }
        Resource resource = resourceSet.getResource(uri.trimFragment(), true);
        if (resource == null || resource.getContents().isEmpty()) {
            return null;
        }
        if (resource.getContents().size() == 1) {
            return (EObject)resource.getContents().get(0);
        }
        ResourceEObject resourceEObj = ModelparamFactory.eINSTANCE.createResourceEObject();
        resourceEObj.getChildren().addAll((Collection)resource.getContents());
        return resourceEObj;
    }

    public static EObject safeLoadModel(URI uri) {
        return EmfUtil.safeLoadModel(uri, EmfUtil.getDefaultLoadOptions());
    }

    public static EObject safeLoadModel(URI uri, Map options) {
        try {
            return EmfUtil.loadModel(uri, options);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Resource loadResource(URI uri) {
        return EmfUtil.loadResource(uri, EmfUtil.getDefaultLoadOptions());
    }

    public static Resource loadResource(URI uri, Map options) {
        return EmfUtil.createResourceSet(options).getResource(uri, true);
    }

    private static ResourceSet createResourceSet(Map options) {
        ResourceSetImpl resourceSet = new ResourceSetImpl(){

            protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
                Resource resource = super.delegatedGetResource(uri, loadOnDemand);
                if (resource == null) {
                    URI trimmedURI = uri.trimFragment();
                    try {
                        IMetamodelDesc descriptor = MetamodelRegistry.getInstance().getMetamodelDesc(trimmedURI.toString());
                        EPackage ePackage = descriptor.getModel();
                        resource = ePackage.eResource();
                        if (resource == null) {
                            resource = new ResourceImpl(trimmedURI);
                            resource.getContents().add((Object)ePackage);
                        }
                    }
                    catch (EmfException emfException) {}
                }
                return resource;
            }
        };
        resourceSet.getLoadOptions().putAll(options);
        return resourceSet;
    }

    public static EObject resolveSource(ResourceEObject in, EObject inputType) {
        ArrayList<EObject> resolved = new ArrayList<EObject>(in.getChildren().size());
        for (EObject eObj : in.getChildren()) {
            resolved.add(EmfUtil.resolveSource(eObj, inputType));
        }
        in.getChildren().clear();
        in.getChildren().addAll(resolved);
        return in;
    }

    public static EObject resolveSource(EObject in, EObject inputType) {
        if (in instanceof ResourceEObject) {
            return EmfUtil.resolveSource((ResourceEObject)in, inputType);
        }
        if (inputType == null) {
            return in;
        }
        if (EmfUtil.isDynamic(in) && inputType.eResource().getResourceSet() != in.eResource().getResourceSet() && inputType.eResource().getResourceSet() != null) {
            return inputType.eResource().getResourceSet().getEObject(EcoreUtil.getURI((EObject)in), true);
        }
        return in;
    }

    public static boolean isUriExisted(String textUri) {
        URI destUri = EmfUtil.makeUri(textUri);
        if (destUri != null) {
            EObject loadModel = null;
            try {
                loadModel = EmfUtil.loadModel(destUri);
            }
            catch (Exception exception) {}
            if (loadModel != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isDynamic(EObject eObject) {
        return eObject instanceof EStructuralFeature.Internal.DynamicValueHolder;
    }

    public static void saveModel(EObject eObject, URI uri, Map opts) throws EmfException {
        ResourceSet resourceSet = EmfUtil.getOutputResourceSet();
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)eObject);
        HashMap<String, Object> options = new HashMap<String, Object>(opts);
        options.put("ENCODING", "UTF-8");
        if (EmfUtil.isDynamic(eObject)) {
            options.put("SCHEMA_LOCATION", Boolean.TRUE);
        }
        try {
            resource.save(options);
        }
        catch (Exception e) {
            throw new EmfException(NLS.bind((String)Messages.EmfUtil_1, (Object)uri), e);
        }
    }

    public static void saveModel(Resource modelExtent, URI uri, Map opts) throws EmfException {
        modelExtent.setURI(uri);
        HashMap<String, Object> options = new HashMap<String, Object>(opts);
        options.put("ENCODING", "UTF-8");
        options.put("PROCESS_DANGLING_HREF", "DISCARD");
        for (EObject eObject : modelExtent.getContents()) {
            if (!EmfUtil.isDynamic(eObject)) continue;
            options.put("SCHEMA_LOCATION", Boolean.TRUE);
            break;
        }
        try {
            modelExtent.save(options);
        }
        catch (Exception e) {
            throw new EmfException(NLS.bind((String)Messages.EmfUtil_1, (Object)uri), e);
        }
    }

    public static ResourceSet getOutputResourceSet() {
        return new ResourceSetImpl();
    }

    public static EPackage getRootPackage(EPackage pack) {
        EPackage parent = pack.getESuperPackage();
        if (parent == null) {
            return pack;
        }
        return EmfUtil.getRootPackage(parent);
    }

    public static String getFullName(EClassifier cls) {
        return EmfUtil.getFullName(cls, "::");
    }

    public static String getFullName(EClassifier cls, String delim) {
        if (cls.getEPackage() == null) {
            return cls.getName();
        }
        return String.valueOf(EmfUtil.getFullName(cls.getEPackage(), delim)) + delim + cls.getName();
    }

    public static String getFullName(EPackage pack) {
        return EmfUtil.getFullName(pack, "::");
    }

    public static String getFullName(EPackage pack, String delim) {
        if (pack.getESuperPackage() != null) {
            return String.valueOf(EmfUtil.getFullName(pack.getESuperPackage(), delim)) + delim + pack.getName();
        }
        return pack.getName();
    }

    public static String getFullNameRelativeToPackage(EPackage ePackage, EPackage baseQwningPackage) {
        String delim = "::";
        if (ePackage.getESuperPackage() != null && ePackage.getESuperPackage() != baseQwningPackage) {
            StringBuilder buf = new StringBuilder();
            EPackage nextPackage = ePackage;
            int i = 0;
            while (nextPackage != null && nextPackage != baseQwningPackage) {
                if (i > 0) {
                    buf.insert(0, delim);
                }
                buf.insert(0, nextPackage.getName());
                nextPackage = nextPackage.getESuperPackage();
                ++i;
            }
            return String.valueOf(EmfUtil.getFullNameRelativeToPackage(ePackage.getESuperPackage(), baseQwningPackage)) + delim + ePackage.getName();
        }
        return ePackage.getName();
    }

    public static String getFullNameRelativeToPackage(EClassifier eClassifier, EPackage baseOwningPackage) {
        EPackage immediateOwner = eClassifier.getEPackage();
        if (baseOwningPackage != null && immediateOwner != null && baseOwningPackage != immediateOwner) {
            String parentName = EmfUtil.getFullNameRelativeToPackage(immediateOwner, baseOwningPackage);
            return String.valueOf(parentName) + "::" + eClassifier.getName();
        }
        return eClassifier.getName();
    }

    public static String getMetamodelName(EPackage pack) {
        String name = pack.getName();
        String nsURI = pack.getNsURI();
        if (nsURI != null && nsURI.length() > 0) {
            name = String.valueOf(name) + " (" + nsURI + ")";
        }
        return name;
    }

    public static EClass getEClass(EPackage root, String[] fullName) throws EmfException {
        EClassifier classifier = EmfUtil.getEClassifier(root, fullName);
        if (!(classifier instanceof EClass)) {
            throw new EmfException(NLS.bind((String)Messages.EmfUtil_6, (Object)fullName[fullName.length - 1]));
        }
        return (EClass)classifier;
    }

    public static EClassifier getEClassifier(EPackage root, String[] fullName) throws EmfException {
        if (fullName.length < 2) {
            throw new EmfException(NLS.bind((String)Messages.EmfUtil_2, Arrays.asList(fullName)));
        }
        String rootPackName = fullName[0];
        if (!rootPackName.equals(root.getName())) {
            throw new EmfException(NLS.bind((String)Messages.EmfUtil_3, (Object)rootPackName, (Object)root.getName()));
        }
        int i = 1;
        while (i < fullName.length - 1) {
            EPackage pack2;
            block4: {
                EList subPackages = root.getESubpackages();
                for (EPackage pack2 : subPackages) {
                    if (!fullName[i].equals(pack2.getName())) continue;
                    break block4;
                }
                throw new EmfException(NLS.bind((String)Messages.EmfUtil_5, (Object)fullName[i]));
            }
            root = pack2;
            ++i;
        }
        EClassifier classifier = root.getEClassifier(fullName[fullName.length - 1]);
        return classifier;
    }

    public static URI makeUri(String uriString) {
        if (uriString == null || uriString.length() == 0) {
            return null;
        }
        URI uri = null;
        try {
            uri = URI.createURI((String)uriString);
        }
        catch (Exception exception) {
            return null;
        }
        return uri;
    }

    public static String getRootPackageUri(EClassifier cls) {
        String uri = cls == null ? null : EmfUtil.getRootPackage(cls.getEPackage()).getNsURI();
        return uri;
    }

    public static boolean isAssignableFrom(EClassifier type, EClassifier from) {
        if (type == from) {
            return true;
        }
        if (!(from instanceof EClass)) {
            return false;
        }
        return ((EClass)from).getEAllSuperTypes().contains((Object)type);
    }

    public static Map getDefaultLoadOptions() {
        HashMap options = new HashMap();
        return options;
    }

    public static String getFileNameForResult(String moduleName, EClass cls) {
        return String.valueOf(moduleName) + "." + EmfUtil.getExtensionForResult((EClassifier)cls);
    }

    public static String getExtensionForResult(EClassifier cls) {
        if (cls == null) {
            return "xmi";
        }
        EPackage root = EmfUtil.getRootPackage(cls.getEPackage());
        return root.getName();
    }

    public static Resource createResource(URI uri, ResourceSet outResourceSet) {
        Resource resource = outResourceSet.createResource(uri);
        if (resource != null) {
            return resource;
        }
        Object possibleFactory = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(uri.fileExtension());
        Resource.Factory factory = null;
        if (possibleFactory instanceof Resource.Factory) {
            factory = (Resource.Factory)possibleFactory;
        }
        if (possibleFactory instanceof Resource.Factory.Descriptor) {
            factory = ((Resource.Factory.Descriptor)possibleFactory).createFactory();
        }
        if (factory == null) {
            factory = new XMIResourceFactoryImpl();
        }
        return factory.createResource(uri);
    }

    public static boolean isContainmentReference(EStructuralFeature feature) {
        if (feature.eClass() == EcorePackage.eINSTANCE.getEReference()) {
            EReference ref = (EReference)feature;
            return ref.isContainment();
        }
        return false;
    }
}

