/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.ui.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.controls.IPathUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.controls.Messages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.provider.EmfModelContentProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.provider.EmfModelLabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectUriControl
extends Composite {
    private final TreeViewer myViewer;
    private final Text myUriText;
    private URI myUri;
    private Object myResource;
    private final String myDefaultFileName;
    private final boolean myIsConsiderAdaptes;
    private final List<ISelectionListener> mySelectionListeners;
    private static final int DEFAUL_AUTO_EXPAND_LEVEL = 0;
    private static final String NAME_COLUMN = "name";
    private ITreeContentProvider CONTENT_PROVIDER = new ITreeContentProvider(){
        private final ITreeContentProvider myWorkbenchProvider = new WorkbenchContentProvider();

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IFile) {
                IFile file = (IFile)parentElement;
                ArrayList<EmfModelContentProvider.EObjectNode> children = new ArrayList<EmfModelContentProvider.EObjectNode>();
                try {
                    Resource res = EmfUtil.loadResource((URI)URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false));
                    for (EObject obj : res.getContents()) {
                        children.add(new EmfModelContentProvider.EObjectNode(obj, file));
                    }
                }
                catch (RuntimeException runtimeException) {}
                return children.toArray();
            }
            if (parentElement instanceof EmfModelContentProvider.Node) {
                return ((EmfModelContentProvider.Node)parentElement).getChildren();
            }
            return this.myWorkbenchProvider.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            if (element instanceof EmfModelContentProvider.Node) {
                return ((EmfModelContentProvider.Node)element).getParent();
            }
            return this.myWorkbenchProvider.getParent(element);
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IFile) {
                return true;
            }
            if (element instanceof EmfModelContentProvider.Node) {
                return ((EmfModelContentProvider.Node)element).hasChildren();
            }
            return this.myWorkbenchProvider.hasChildren(element);
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = this.myWorkbenchProvider.getElements(inputElement);
            Object[] clonedElems = new Object[elements.length];
            int i = 0;
            while (i < elements.length) {
                EObject eObject = (EObject)SelectUriControl.this.getAdapterSafe(elements[i], EObject.class);
                clonedElems[i] = eObject != null ? new EmfModelContentProvider.EObjectNode(eObject, null) : elements[i];
                ++i;
            }
            return clonedElems;
        }

        public void dispose() {
            this.myWorkbenchProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.myWorkbenchProvider.inputChanged(viewer, oldInput, newInput);
        }
    };
    private ILabelProvider LABEL_PROVIDER = new LabelProvider(){
        private final ILabelProvider myWorkbenchLabelProvider = new WorkbenchLabelProvider();
        private final ILabelProvider myEmfModelLabelProvider = new EmfModelLabelProvider();
        private final ILabelProvider myEObjectLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));

        public String getText(Object element) {
            if (element instanceof EmfModelContentProvider.Node) {
                return this.myEmfModelLabelProvider.getText(element);
            }
            EObject eObject = (EObject)SelectUriControl.this.getAdapterSafe(element, EObject.class);
            if (eObject != null) {
                return this.myEObjectLabelProvider.getText((Object)eObject);
            }
            return this.myWorkbenchLabelProvider.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof EmfModelContentProvider.Node) {
                return this.myEmfModelLabelProvider.getImage(element);
            }
            EObject eObject = (EObject)SelectUriControl.this.getAdapterSafe(element, EObject.class);
            if (eObject != null) {
                return this.myEObjectLabelProvider.getImage((Object)eObject);
            }
            return this.myWorkbenchLabelProvider.getImage(element);
        }
    };
    private static final ViewerSorter VIEWER_SORTER = new ViewerSorter(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            boolean folderLeft = e1 instanceof IContainer;
            boolean folderRight = e2 instanceof IContainer;
            if (folderLeft == folderRight) {
                return super.compare(viewer, e1, e2);
            }
            return folderLeft ? -1 : 1;
        }
    };
    private final ISelectionChangedListener VIEWER_LISTENER = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object uri;
            ISelection selection = event.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                uri = null;
            } else {
                Object selected = ((IStructuredSelection)selection).getFirstElement();
                if (selected instanceof IFile) {
                    IFile file = (IFile)selected;
                    uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
                } else if (selected instanceof EmfModelContentProvider.EObjectNode) {
                    EObject obj = ((EmfModelContentProvider.EObjectNode)selected).getObject();
                    uri = EcoreUtil.getURI((EObject)obj);
                } else {
                    EObject eObject = (EObject)SelectUriControl.this.getAdapterSafe(selected, EObject.class);
                    uri = eObject != null ? EcoreUtil.getURI((EObject)eObject) : null;
                }
            }
            SelectUriControl.this.myUriText.setEnabled(false);
            SelectUriControl.this.myResource = null;
            SelectUriControl.this.myUriText.setText(uri == null ? "" : uri.toString());
            if (uri == null && selection instanceof IStructuredSelection && SelectUriControl.this.myDefaultFileName != null) {
                SelectUriControl.this.myResource = ((IStructuredSelection)selection).getFirstElement();
                if (SelectUriControl.this.myResource instanceof IContainer) {
                    SelectUriControl.this.myUriText.setEnabled(true);
                    SelectUriControl.this.myUriText.setText(SelectUriControl.this.myDefaultFileName);
                    return;
                }
            }
            URI uRI = uri;
            SelectUriControl.this.myUri = uRI;
            SelectUriControl.this.fireSelectionChanged(uRI);
        }
    };
    private final ModifyListener FNAME_LISTENER = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (SelectUriControl.this.myResource instanceof IContainer) {
                URI uri;
                URI uRI = uri = IPathUtils.getUri(IPathUtils.computePath((IResource)SelectUriControl.this.myResource, SelectUriControl.this.myUriText.getText()));
                SelectUriControl.this.myUri = uRI;
                SelectUriControl.this.fireSelectionChanged(uRI);
            }
        }
    };

    public SelectUriControl(Composite parentComposite, String defaultFileName, boolean isConsiderAdaptes) {
        super(parentComposite, 0);
        this.mySelectionListeners = new ArrayList<ISelectionListener>();
        this.myDefaultFileName = defaultFileName;
        this.myIsConsiderAdaptes = isConsiderAdaptes;
        this.setLayout((Layout)new GridLayout());
        this.myViewer = new TreeViewer((Composite)this, 2820);
        Label secondLabel = new Label((Composite)this, 16384);
        secondLabel.setText(Messages.SelectFileControl_SelectedFile);
        this.myUriText = new Text((Composite)this, 2048);
        this.myUriText.setLayoutData((Object)new GridData(768));
        this.myUriText.setEnabled(false);
        this.myUriText.addModifyListener(this.FNAME_LISTENER);
        this.myViewer.setContentProvider((IContentProvider)this.CONTENT_PROVIDER);
        this.myViewer.setLabelProvider((IBaseLabelProvider)this.LABEL_PROVIDER);
        this.myViewer.setAutoExpandLevel(0);
        this.myViewer.setSorter(VIEWER_SORTER);
        this.myViewer.addSelectionChangedListener(this.VIEWER_LISTENER);
        this.myViewer.setColumnProperties(new String[]{NAME_COLUMN});
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 250;
        data.widthHint = 350;
        this.myViewer.getControl().setLayoutData((Object)data);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.myViewer.setInput((Object)root);
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.mySelectionListeners.add(listener);
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.mySelectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.myViewer.setSelection(selection);
    }

    private void fireSelectionChanged(URI uri) {
        for (ISelectionListener listener : new ArrayList<ISelectionListener>(this.mySelectionListeners)) {
            try {
                listener.selectionChanged(uri);
            }
            catch (Exception exception) {}
        }
    }

    public URI getSelectedUri() {
        return this.myUri;
    }

    public TreeViewer getViewer() {
        return this.myViewer;
    }

    private Object getAdapterSafe(Object adaptable, Class<?> adapterType) {
        if (adaptable == null || !this.myIsConsiderAdaptes) {
            return null;
        }
        return Platform.getAdapterManager().getAdapter(adaptable, adapterType);
    }

    public static interface ISelectionListener {
        public void selectionChanged(URI var1);
    }
}

