/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractCompilationUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.StandaloneModuleHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneBlackboxProvider
extends JavaBlackboxProvider {
    private final Map<String, AbstractCompilationUnitDescriptor> fDescriptorMap = new LinkedHashMap<String, AbstractCompilationUnitDescriptor>();

    @Override
    public AbstractCompilationUnitDescriptor getModuleDescriptor(String qualifiedName, ResolutionContext resolutionContext) {
        try {
            AbstractCompilationUnitDescriptor d = this.fDescriptorMap.get(qualifiedName);
            if (d == null) {
                d = new StandaloneDescriptor(qualifiedName);
                this.fDescriptorMap.put(qualifiedName, d);
            }
            return d;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public Collection<AbstractCompilationUnitDescriptor> getModuleDescriptors(ResolutionContext resolutionContext) {
        return Collections.emptyList();
    }

    private class StandaloneDescriptor
    extends JavaBlackboxProvider.JavaUnitDescriptor {
        StandaloneDescriptor(String unitQualifiedName) throws ClassNotFoundException {
            super(unitQualifiedName);
            this.addModuleHandle(new StandaloneModuleHandle(unitQualifiedName, StandaloneBlackboxProvider.getSimpleNameFromJavaClass(unitQualifiedName)));
        }
    }
}

