/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.ui.provider;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.ExtendedEMFUtil;
import org.eclipse.swt.graphics.Image;

public class EMFLabelProvider
implements ILabelProvider {
    private final Map<Object, ILabelProvider> myLabelProvidersMap = new HashMap<Object, ILabelProvider>();
    private static final Class<?>[] REQUIRED_CLASSES = new Class[]{IItemLabelProvider.class};

    public Image getImage(Object element) {
        return this.getLabelProvider(element).getImage(element);
    }

    public String getText(Object element) {
        return this.getLabelProvider(element).getText(element);
    }

    private ILabelProvider getLabelProvider(Object element) {
        if (element == null) {
            return NullLabelProvider.INSTANCE;
        }
        ILabelProvider labelProvider = null;
        if (element instanceof EObject) {
            EPackage ePackage = ((EObject)element).eClass().getEPackage();
            labelProvider = this.myLabelProvidersMap.get(ePackage);
            if (labelProvider == null) {
                labelProvider = new AdapterFactoryLabelProvider(EMFLabelProvider.getAdapterFactory(ePackage));
                this.myLabelProvidersMap.put(ePackage, labelProvider);
            }
        } else {
            labelProvider = this.myLabelProvidersMap.get(element.getClass());
            if (labelProvider == null) {
                labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
                this.myLabelProvidersMap.put(element.getClass(), labelProvider);
            }
        }
        return labelProvider;
    }

    private static AdapterFactory getAdapterFactory(EPackage ePackage) {
        return ExtendedEMFUtil.createComposedAdapterFactory(ExtendedEMFUtil.getAdapterFactories(ePackage, REQUIRED_CLASSES));
    }

    public void dispose() {
        HashSet<ILabelProvider> providers = new HashSet<ILabelProvider>(this.myLabelProvidersMap.values());
        for (ILabelProvider labelProvider : providers) {
            labelProvider.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private static class NullLabelProvider
    implements ILabelProvider {
        public static final NullLabelProvider INSTANCE = new NullLabelProvider();

        private NullLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

