/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.launch;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtValidator {
    private QvtValidator() {
    }

    public static IStatus validateTransformation(QvtTransformation transformation, List<TargetUriData> targetUris, String traceFilePath, boolean useTrace, boolean isIncrementalUpdate, ValidationType validationType) throws MdaException {
        IStatus traceStatus;
        IStatus result = StatusUtil.makeOkStatus();
        if (!TransformationUtil.isRunnable(transformation)) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_TransformationMissedEntryOp, (Object)transformation.getModuleName()));
        }
        ResourceSet validationRS = CompilerUtils.cloneResourceSet((URI)transformation.getURI(), (ResourceSet)transformation.getResourceSet());
        Iterator<TargetUriData> itrTargetData = targetUris.iterator();
        for (QvtTransformation.TransformationParameter transfParam : transformation.getParameters()) {
            if (!itrTargetData.hasNext()) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_EmptyInputTransfParam, (Object)transfParam.getName()));
            }
            IStatus nextStatus = QvtValidator.validateTransformationParameter(transfParam, itrTargetData.next(), validationRS, validationType, isIncrementalUpdate);
            if (nextStatus.getSeverity() <= result.getSeverity()) continue;
            result = nextStatus;
        }
        if (isIncrementalUpdate) {
            traceStatus = validationType == ValidationType.LIGHTWEIGHT_VALIDATION ? QvtValidator.validateTraceObjectLightweight(traceFilePath, validationRS) : QvtValidator.validateTraceObject(traceFilePath, validationRS);
            if (StatusUtil.isError((IStatus)traceStatus)) {
                return traceStatus;
            }
            if (traceStatus.getSeverity() > result.getSeverity()) {
                result = traceStatus;
            }
        }
        if (useTrace) {
            traceStatus = QvtValidator.validateTrace(traceFilePath, validationRS);
            if (StatusUtil.isError((IStatus)traceStatus)) {
                return traceStatus;
            }
            if (traceStatus.getSeverity() > result.getSeverity()) {
                result = traceStatus;
            }
        }
        return result;
    }

    public static IStatus validateTransformation(QvtTransformation transformation, List<ModelContent> inModels, String traceFileName) throws MdaException {
        IStatus result = StatusUtil.makeOkStatus();
        if (!TransformationUtil.isRunnable(transformation)) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_TransformationMissedEntryOp, (Object)transformation.getModuleName()));
        }
        Iterator<ModelContent> itrInObjs = inModels.iterator();
        for (QvtTransformation.TransformationParameter transfParam : transformation.getParameters()) {
            if (transfParam.getDirectionKind() != QvtTransformation.TransformationParameter.DirectionKind.IN && transfParam.getDirectionKind() != QvtTransformation.TransformationParameter.DirectionKind.INOUT) continue;
            if (!itrInObjs.hasNext()) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_MissedInputTransfParam, (Object)transfParam.getName()));
            }
            IStatus nextStatus = QvtValidator.validateTransformationParameterIn(transfParam, itrInObjs.next());
            if (nextStatus.getSeverity() <= result.getSeverity()) continue;
            result = nextStatus;
        }
        StringBuffer superfluousParams = new StringBuffer();
        while (itrInObjs.hasNext()) {
            ModelContent obj;
            if (superfluousParams.length() > 0) {
                superfluousParams.append(", ");
            }
            if ((obj = itrInObjs.next()) == null || obj.getContent().isEmpty()) continue;
            superfluousParams.append(EmfUtil.getFullName((EClassifier)((EObject)obj.getContent().get(0)).eClass()));
        }
        if (superfluousParams.length() > 0) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_SuperfluousInputTransfParam, (Object)superfluousParams.toString()));
        }
        if (traceFileName != null) {
            IStatus traceStatus = QvtValidator.validateTrace(traceFileName, transformation.getResourceSet());
            if (StatusUtil.isError((IStatus)traceStatus)) {
                return traceStatus;
            }
            if (traceStatus.getSeverity() > result.getSeverity()) {
                result = traceStatus;
            }
        }
        return result;
    }

    private static IStatus validateTransformationParameter(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS, ValidationType validationType, boolean isIncrementalUpdate) {
        if (transfParam.getMetamodels().isEmpty()) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_EmptyInputTransfParam, (Object)transfParam.getName()));
        }
        if (targetData.getContentProvider() != null) {
            return StatusUtil.makeOkStatus();
        }
        if (transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.IN) {
            if (validationType == ValidationType.LIGHTWEIGHT_VALIDATION) {
                return QvtValidator.validateTransformationParameterInLightweight(transfParam, targetData, validationRS);
            }
            return QvtValidator.validateTransformationParameterIn(transfParam, targetData, validationRS);
        }
        if (transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.INOUT) {
            if (validationType == ValidationType.LIGHTWEIGHT_VALIDATION) {
                return QvtValidator.validateTransformationParameterInOutLightweight(transfParam, targetData, validationRS);
            }
            return QvtValidator.validateTransformationParameterInOut(transfParam, targetData, validationRS);
        }
        if (validationType == ValidationType.LIGHTWEIGHT_VALIDATION) {
            return QvtValidator.validateTransformationParameterOutLightweight(transfParam, targetData, validationRS, isIncrementalUpdate);
        }
        return QvtValidator.validateTransformationParameterOut(transfParam, targetData, validationRS, isIncrementalUpdate);
    }

    private static IStatus validateTrace(String traceFilePath, ResourceSet validationRS) {
        try {
            if (traceFilePath == null || traceFilePath.length() == 0) {
                return StatusUtil.makeErrorStatus((String)Messages.QvtValidator_NoTraceFile);
            }
            URI traceUri = URI.createURI((String)traceFilePath);
            IStatus result = QvtValidator.canSaveEx(null, StatusUtil.makeOkStatus(), traceUri, validationRS);
            if (StatusUtil.isError((IStatus)result)) {
                return result;
            }
            if (!traceFilePath.endsWith(".qvtotrace") && result.getSeverity() < 2) {
                result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_NoTraceFileExtension, (Object)".qvtotrace"));
            }
            return result;
        }
        catch (Exception e) {
            return StatusUtil.makeErrorStatus((String)e.getMessage(), (Exception)e);
        }
    }

    private static IStatus validateTraceObjectLightweight(String traceFilePath, ResourceSet validationRS) {
        URI sourceUri = EmfUtil.makeUri((String)traceFilePath);
        if (sourceUri == null) {
            return StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidTraceObjectUri, (Object)traceFilePath));
        }
        if (!EmfUtil.isUriExists((URI)sourceUri, (ResourceSet)validationRS, (boolean)false)) {
            return StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidTraceObjectUri, (Object)traceFilePath));
        }
        return StatusUtil.makeOkStatus();
    }

    private static IStatus validateTraceObject(String traceFilePath, ResourceSet validationRS) {
        URI sourceUri = EmfUtil.makeUri((String)traceFilePath);
        ModelContent in = null;
        try {
            in = EmfUtil.loadModel((URI)sourceUri, (ResourceSet)validationRS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (in == null) {
            return StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidTraceObjectUri, (Object)traceFilePath));
        }
        if (validationRS == null) {
            EmfUtil.cleanupResourceSet((ResourceSet)in.getResourceSet());
        }
        return StatusUtil.makeOkStatus();
    }

    private static IStatus validateTransformationParameterIn(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS) {
        block23: {
            if (transfParam.getEntryType() != null) {
                EClassifier classifier = transfParam.getEntryType();
                URI sourceUri = EmfUtil.makeUri((String)targetData.getUriString());
                EObject in = null;
                try {
                    ModelContent loadModel = EmfUtil.loadModel((URI)sourceUri, (ResourceSet)validationRS);
                    in = loadModel != null && !loadModel.getContent().isEmpty() ? (EObject)loadModel.getContent().get(0) : null;
                }
                catch (Exception loadModel) {
                    // empty catch block
                }
                if (in == null) {
                    return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
                }
                ResourceSet inputRs = validationRS == null ? in.eResource().getResourceSet() : null;
                try {
                    try {
                        in = EmfUtil.resolveSource(in, (EObject)classifier);
                    }
                    catch (WrappedException e) {
                        IStatus iStatus = StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
                        if (inputRs != null) {
                            EmfUtil.cleanupResourceSet((ResourceSet)inputRs);
                        }
                        return iStatus;
                    }
                    if (!EmfUtil.isAssignableFrom((EClassifier)classifier, (EClassifier)in.eClass()) || !classifier.isInstance((Object)in)) {
                        IStatus iStatus = StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_IncompatibleInputTypes, (Object[])new Object[]{EmfUtil.getFullName((EClassifier)in.eClass()), EmfUtil.getFullName((EClassifier)classifier), transfParam.getName()}));
                        return iStatus;
                    }
                    break block23;
                }
                finally {
                    if (inputRs != null) {
                        EmfUtil.cleanupResourceSet((ResourceSet)inputRs);
                    }
                }
            }
            EPackage metamodel = transfParam.getMetamodels().get(0);
            URI sourceUri = EmfUtil.makeUri((String)targetData.getUriString());
            ModelContent in = null;
            try {
                in = EmfUtil.loadModel((URI)sourceUri, (ResourceSet)validationRS);
            }
            catch (Exception inputRs) {
                // empty catch block
            }
            if (in == null) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
            }
            ResourceSet inputRs = validationRS == null ? in.getResourceSet() : null;
            try {
                try {
                    in = in.getResolvedContent((EObject)metamodel);
                }
                catch (WrappedException e) {
                    IStatus iStatus = StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
                    if (inputRs != null) {
                        EmfUtil.cleanupResourceSet((ResourceSet)inputRs);
                    }
                    return iStatus;
                }
            }
            finally {
                if (inputRs != null) {
                    EmfUtil.cleanupResourceSet((ResourceSet)inputRs);
                }
            }
        }
        return StatusUtil.makeOkStatus();
    }

    private static IStatus validateTransformationParameterInLightweight(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS) {
        URI sourceUri = EmfUtil.makeUri((String)targetData.getUriString());
        if (sourceUri == null) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
        }
        if (!EmfUtil.isUriExists((URI)sourceUri, (ResourceSet)validationRS, (boolean)false)) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
        }
        return StatusUtil.makeOkStatus();
    }

    private static IStatus validateTransformationParameterIn(QvtTransformation.TransformationParameter transfParam, ModelContent in) {
        if (transfParam.getMetamodels().isEmpty()) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_EmptyInputTransfParam, (Object)transfParam.getName()));
        }
        if (transfParam.getEntryType() != null) {
            EObject inObj;
            EClassifier classifier = transfParam.getEntryType();
            EObject eObject = inObj = in != null && !in.getContent().isEmpty() ? (EObject)in.getContent().get(0) : null;
            if (inObj == null) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_IncompatibleInputTypes, (Object[])new Object[]{"<null>", EmfUtil.getFullName((EClassifier)classifier), transfParam.getName()}));
            }
            if (!EmfUtil.isAssignableFrom((EClassifier)classifier, (EClassifier)inObj.eClass()) || !classifier.isInstance((Object)inObj)) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_IncompatibleInputTypes, (Object[])new Object[]{EmfUtil.getFullName((EClassifier)inObj.eClass()), EmfUtil.getFullName((EClassifier)classifier), transfParam.getName()}));
            }
        }
        return StatusUtil.makeOkStatus();
    }

    private static IStatus validateTransformationParameterInOut(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS) {
        IStatus result = QvtValidator.validateTransformationParameterIn(transfParam, targetData, validationRS);
        if (result.getSeverity() >= 2) {
            return result;
        }
        URI sourceUri = URI.createURI((String)targetData.getUriString());
        result = QvtValidator.canSaveEx(transfParam, result, sourceUri, validationRS);
        return result;
    }

    private static IStatus validateTransformationParameterInOutLightweight(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS) {
        IStatus result = QvtValidator.validateTransformationParameterInLightweight(transfParam, targetData, validationRS);
        if (result.getSeverity() >= 2) {
            return result;
        }
        URI sourceUri = URI.createURI((String)targetData.getUriString());
        result = QvtValidator.canSaveEx(transfParam, result, sourceUri, validationRS);
        return result;
    }

    private static IStatus validateTransformationParameterOut(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS, boolean isIncrementalUpdate) {
        URI destUri = EmfUtil.makeUri((String)targetData.getUriString());
        if (destUri == null) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidTargetUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
        }
        IStatus result = StatusUtil.makeOkStatus();
        switch (targetData.getTargetType()) {
            case NEW_MODEL: {
                IStatus canSave;
                if (EmfUtil.isUriExists((URI)destUri, (ResourceSet)validationRS, (boolean)true) && result.getSeverity() < 2) {
                    if (EmfUtil.isUriExistsAsEObject((URI)destUri, (ResourceSet)validationRS, (boolean)true)) {
                        if (!isIncrementalUpdate) {
                            result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationExists, (Object)destUri, (Object)transfParam.getName()));
                        }
                    } else {
                        result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationExistsNonEObject, (Object)destUri, (Object)transfParam.getName()));
                    }
                }
                if (StatusUtil.isError((IStatus)(canSave = QvtValidator.canSave(transfParam, destUri, validationRS)))) {
                    return canSave;
                }
                if (canSave.getSeverity() > result.getSeverity()) {
                    result = canSave;
                }
                if (!destUri.hasFragment() || result.getSeverity() >= 2) break;
                result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_NewDestinationHasFragment, (Object)destUri.fragment(), (Object)transfParam.getName()));
                break;
            }
            case EXISTING_CONTAINER: {
                EObject eContainer;
                ModelContent loadModel = EmfUtil.loadModel((URI)destUri, (ResourceSet)validationRS);
                EObject eObject = eContainer = loadModel != null && !loadModel.getContent().isEmpty() ? (EObject)loadModel.getContent().get(0) : null;
                if (eContainer == null) {
                    return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidTargetUri, (Object)destUri, (Object)transfParam.getName()));
                }
                if (StatusUtil.isError((IStatus)(result = QvtValidator.canSaveEx(transfParam, result, destUri, validationRS)))) {
                    return result;
                }
                String feature = targetData.getFeature();
                if (feature == null || feature.trim().length() == 0) {
                    if (isIncrementalUpdate || result.getSeverity() >= 2) break;
                    result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationExists, (Object)destUri, (Object)transfParam.getName()));
                    break;
                }
                EStructuralFeature eFeature = eContainer.eClass().getEStructuralFeature(feature);
                if (!(eFeature instanceof EReference)) {
                    return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidFeature, (Object)feature, (Object)transfParam.getName()));
                }
                EReference ref = (EReference)eFeature;
                if (ref.isChangeable()) break;
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidFeature, (Object)ref.getName(), (Object)transfParam.getName()));
            }
            case INPLACE: {
                return StatusUtil.makeErrorStatus((String)Messages.QvtValidator_InplaceConfigNotSupported);
            }
        }
        return result;
    }

    private static IStatus validateTransformationParameterOutLightweight(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS, boolean isIncrementalUpdate) {
        URI destUri = EmfUtil.makeUri((String)targetData.getUriString());
        if (destUri == null) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidTargetUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
        }
        IStatus result = StatusUtil.makeOkStatus();
        switch (targetData.getTargetType()) {
            case NEW_MODEL: {
                IStatus canSave;
                if (!isIncrementalUpdate && EmfUtil.isUriExists((URI)destUri, (ResourceSet)validationRS, (boolean)true) && result.getSeverity() < 2) {
                    result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationExists, (Object)destUri, (Object)transfParam.getName()));
                }
                if (StatusUtil.isError((IStatus)(canSave = QvtValidator.canSave(transfParam, destUri, validationRS)))) {
                    return canSave;
                }
                if (canSave.getSeverity() > result.getSeverity()) {
                    result = canSave;
                }
                if (!destUri.hasFragment() || result.getSeverity() >= 2) break;
                result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_NewDestinationHasFragment, (Object)destUri.fragment(), (Object)transfParam.getName()));
                break;
            }
            case EXISTING_CONTAINER: {
                result = QvtValidator.canSaveEx(transfParam, result, destUri, validationRS);
                if (StatusUtil.isError((IStatus)result)) {
                    return result;
                }
                String feature = targetData.getFeature();
                if (feature != null && feature.trim().length() != 0 || isIncrementalUpdate || result.getSeverity() >= 2) break;
                result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationExists, (Object)destUri, (Object)transfParam.getName()));
                break;
            }
            case INPLACE: {
                return StatusUtil.makeErrorStatus((String)Messages.QvtValidator_InplaceConfigNotSupported);
            }
        }
        return result;
    }

    private static IStatus canSave(QvtTransformation.TransformationParameter transfParam, URI destUri, ResourceSet validationRS) {
        URIConverter uriConverter = validationRS != null ? validationRS.getURIConverter() : URIConverter.INSTANCE;
        URI converted = uriConverter.normalize(destUri);
        IStatus okStatus = StatusUtil.makeOkStatus();
        String scheme = converted.scheme();
        if (converted.isFile() && !"file".equals(scheme) && !"platform".equals(scheme)) {
            if (transfParam == null) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_UriNotFile, (Object[])new Object[]{destUri, scheme}));
            }
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_UriNotFileParam, (Object[])new Object[]{destUri, scheme, transfParam.getName()}));
        }
        return okStatus;
    }

    private static IStatus canSaveEx(QvtTransformation.TransformationParameter transfParam, IStatus result, URI destUri, ResourceSet validationRS) {
        IStatus canSave;
        IFile file = WorkspaceUtils.getWorkspaceFile((URI)destUri);
        if (file != null && file.exists() && file.isReadOnly() && result.getSeverity() < 2) {
            result = transfParam == null ? StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationReadonly, (Object)destUri)) : StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationReadonlyParam, (Object)destUri, (Object)transfParam.getName()));
        }
        if (StatusUtil.isError((IStatus)(canSave = QvtValidator.canSave(transfParam, destUri, validationRS)))) {
            return canSave;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationType {
        FULL_VALIDATION,
        LIGHTWEIGHT_VALIDATION;

    }
}

