/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.clustering;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.builderState.IResourceDescriptionsUpdater;
import org.eclipse.xtext.builder.clustering.CopiedResourceDescription;
import org.eclipse.xtext.builder.clustering.CurrentDescriptions;
import org.eclipse.xtext.builder.clustering.IUniqueURIQueue;
import org.eclipse.xtext.builder.clustering.Messages;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteringUpdater
implements IResourceDescriptionsUpdater {
    private static final Logger log = Logger.getLogger(ClusteringUpdater.class);
    @Inject
    private IResourceServiceProvider.Registry managerRegistry;
    @Inject
    private IUniqueURIQueue.Factory queueFactory;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.builder.clustering.ClusteringUpdater.clusterSize")
    private int clusterSize = 20;

    public void setResourceServiceRegistry(IResourceServiceProvider.Registry managerRegistry) {
        this.managerRegistry = managerRegistry;
    }

    @Override
    public Collection<IResourceDescription.Delta> transitiveUpdate(IResourceDescriptions oldState, ResourceSet rs, Set<URI> toBeUpdated, Set<URI> toBeDeleted, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ClusteringUpdater_0, (int)100);
        subMonitor.subTask(Messages.ClusteringUpdater_0);
        HashSet toBeDeletedAsSet = Sets.newHashSet(toBeDeleted);
        if (!toBeDeletedAsSet.isEmpty()) {
            for (URI updatedURI : toBeUpdated) {
                toBeDeletedAsSet.remove(updatedURI);
                if (toBeDeletedAsSet.isEmpty()) break;
            }
        }
        HashMap result = Maps.newHashMap();
        for (URI toDelete : toBeDeletedAsSet) {
            IResourceDescription resourceDescription = oldState.getResourceDescription(toDelete);
            if (resourceDescription == null) continue;
            result.put(toDelete, new DefaultResourceDescriptionDelta(resourceDescription, null));
        }
        int startWith = result.size();
        CurrentDescriptions newState = new CurrentDescriptions(rs, oldState, toBeDeletedAsSet);
        IUniqueURIQueue queue = this.queueFactory.create(toBeUpdated);
        this.queueAffectedResourceDescriptions(oldState, newState, result.values(), queue);
        while (!queue.isEmpty()) {
            subMonitor.setWorkRemaining(100);
            Map<URI, IResourceDescription.Delta> clusterDeltas = this.loadResourceCluster(oldState, rs, queue, toBeDeletedAsSet, (IProgressMonitor)subMonitor.newChild(30), result.size() - startWith + 1);
            result.putAll(clusterDeltas);
            for (IResourceDescription.Delta delta : clusterDeltas.values()) {
                newState.register(delta);
            }
            this.queueAffectedResourceDescriptions(oldState, newState, clusterDeltas.values(), queue);
            rs.getResources().clear();
        }
        return result.values();
    }

    @Override
    public Collection<IResourceDescription.Delta> clean(IResourceDescriptions oldState, Set<URI> toBeDeleted, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ClusteringUpdater_2, (int)toBeDeleted.size());
        subMonitor.subTask(Messages.ClusteringUpdater_2);
        HashSet toBeDeletedAsSet = Sets.newHashSet(toBeDeleted);
        HashMap result = Maps.newHashMap();
        for (URI toDelete : toBeDeletedAsSet) {
            IResourceDescription resourceDescription = oldState.getResourceDescription(toDelete);
            if (resourceDescription != null) {
                result.put(toDelete, new DefaultResourceDescriptionDelta(resourceDescription, null));
            }
            subMonitor.worked(1);
        }
        return result.values();
    }

    protected Map<URI, IResourceDescription.Delta> loadResourceCluster(IResourceDescriptions oldState, ResourceSet resourceSet, IUniqueURIQueue queue, Collection<URI> ignoredURIs, IProgressMonitor monitor, int baseIndex) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.clusterSize);
        HashMap result = Maps.newHashMap();
        int i = 0;
        while (i < this.clusterSize && !queue.isEmpty()) {
            block8: {
                if (subMonitor.isCanceled()) {
                    return Collections.emptyMap();
                }
                subMonitor.subTask(String.valueOf(Messages.ClusteringUpdater_4) + baseIndex + Messages.ClusteringUpdater_5 + queue.totalSize());
                URI nextURI = queue.remove();
                Resource resource = null;
                try {
                    if (!ignoredURIs.contains(nextURI)) {
                        resource = resourceSet.getResource(nextURI, true);
                        IResourceDescription.Manager manager = this.getResourceDescriptionManager(nextURI);
                        if (manager != null) {
                            IResourceDescription description = manager.getResourceDescription(resource);
                            CopiedResourceDescription copiedDescription = new CopiedResourceDescription(description);
                            result.put(nextURI, new DefaultResourceDescriptionDelta(oldState.getResourceDescription(nextURI), (IResourceDescription)copiedDescription));
                        }
                    }
                }
                catch (WrappedException ex) {
                    IResourceDescription oldDescription;
                    if (resourceSet.getURIConverter().exists(nextURI, Collections.emptyMap())) {
                        log.error((Object)("Error loading resource from: " + nextURI.toString()), (Throwable)ex);
                    }
                    if (resource != null) {
                        resourceSet.getResources().remove((Object)resource);
                    }
                    if ((oldDescription = oldState.getResourceDescription(nextURI)) == null) break block8;
                    result.put(nextURI, new DefaultResourceDescriptionDelta(oldDescription, null));
                }
            }
            ++baseIndex;
            subMonitor.worked(1);
            ++i;
        }
        return result;
    }

    protected IResourceDescription.Manager getResourceDescriptionManager(URI uri) {
        IResourceServiceProvider resourceServiceProvider = this.managerRegistry.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            return null;
        }
        return resourceServiceProvider.getResourceDescriptionManager();
    }

    protected void queueAffectedResourceDescriptions(IResourceDescriptions oldState, CurrentDescriptions newState, Collection<IResourceDescription.Delta> deltas, IUniqueURIQueue queue) throws IllegalArgumentException {
        Iterable descriptions = oldState.getAllResourceDescriptions();
        for (IResourceDescription desc : descriptions) {
            IResourceDescription.Manager manager = this.getResourceDescriptionManager(desc.getURI());
            if (manager == null || !manager.isAffected(deltas, desc, (IResourceDescriptions)newState)) continue;
            queue.add(desc.getURI());
        }
    }
}

