/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.query;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.label.GlobalDescriptionLabelProvider;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.shared.Access;
import org.eclipse.xtext.util.TextLocation;

public class QueryParticipant
implements IQueryParticipant {
    private final IResourceDescriptions resourceDescriptions = (IResourceDescriptions)Access.getIResourceDescriptions().get();
    private final TypeURIHelper typeURIHelper = new TypeURIHelper();
    private final UIParticipant uiParticipant = new UIParticipant(this.resourceDescriptions);

    public void search(ISearchRequestor requestor, QuerySpecification query, IProgressMonitor monitor) throws CoreException {
        if (!this.isHandled(query)) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            ElementQuerySpecification elementQuery;
            IJavaElement element;
            URI uri;
            if (query instanceof ElementQuerySpecification && (uri = this.typeURIHelper.getFullURI(element = (elementQuery = (ElementQuerySpecification)query).getElement())) != null) {
                this.createSearchHelper(requestor).search(uri, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected JavaSearchHelper createSearchHelper(ISearchRequestor requestor) {
        return new JavaSearchHelper(requestor, this.resourceDescriptions);
    }

    public int estimateTicks(QuerySpecification query) {
        if (this.isHandled(query)) {
            return 250;
        }
        return 0;
    }

    public IMatchPresentation getUIParticipant() {
        return this.uiParticipant;
    }

    private boolean isHandled(QuerySpecification query) {
        switch (query.getLimitTo()) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                return false;
            }
        }
        if (query instanceof ElementQuerySpecification) {
            IJavaElement element = ((ElementQuerySpecification)query).getElement();
            return element.getElementType() == 7 || element.getElementType() == 8 || element.getElementType() == 9;
        }
        return false;
    }

    public static class JavaSearchHelper {
        private final ISearchRequestor requestor;
        private final Map<IProject, ResourceSet> projectToResourceSet;
        private final IStorage2UriMapper storage2UriMapper;
        private final IResourceSetProvider resourceSetProvider;
        private final IExternalContentSupport externalContentSupport;
        private final IDirtyStateManager dirtyStateManager;
        private final IResourceDescriptions resourceDescriptions;

        public JavaSearchHelper(ISearchRequestor requestor, IResourceDescriptions resourceDescriptions) {
            this.requestor = requestor;
            this.resourceDescriptions = resourceDescriptions;
            this.projectToResourceSet = Maps.newHashMap();
            this.storage2UriMapper = (IStorage2UriMapper)Access.getIStorage2UriMapper().get();
            this.resourceSetProvider = (IResourceSetProvider)Access.provider(IResourceSetProvider.class).get();
            this.externalContentSupport = (IExternalContentSupport)Access.provider(IExternalContentSupport.class).get();
            this.dirtyStateManager = (IDirtyStateManager)Access.getIDirtyStateManager().get();
        }

        public void search(URI uri, IProgressMonitor monitor) {
            int numResources = Iterables.size((Iterable)this.resourceDescriptions.getAllResourceDescriptions());
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)numResources);
            subMonitor.subTask("Find references in EMF resources");
            try {
                for (IResourceDescription resourceDescription : this.resourceDescriptions.getAllResourceDescriptions()) {
                    this.searchIn(uri, resourceDescription);
                    if (subMonitor.isCanceled()) {
                        return;
                    }
                    subMonitor.worked(1);
                }
                for (ResourceSet resourceSet : this.projectToResourceSet.values()) {
                    resourceSet.getResources().clear();
                    resourceSet.eAdapters().clear();
                }
            }
            finally {
                subMonitor.done();
            }
        }

        protected void searchIn(final URI uri, IResourceDescription resourceDescription) {
            Iterable matchingReferenceDescriptors = Iterables.filter((Iterable)resourceDescription.getReferenceDescriptions(), (Predicate)new Predicate<IReferenceDescription>(){

                public boolean apply(IReferenceDescription input) {
                    return uri.equals((Object)input.getTargetEObjectUri());
                }
            });
            for (IReferenceDescription matchingReferenceDescription : matchingReferenceDescriptors) {
                this.accept(matchingReferenceDescription);
            }
        }

        protected void accept(IReferenceDescription referenceDescription) {
            URI sourceResourceURI = referenceDescription.getSourceEObjectUri().trimFragment();
            Iterable storages = this.storage2UriMapper.getStorages(sourceResourceURI);
            for (IStorage storage : storages) {
                IProject project = this.getProject(storage);
                if (project == null) continue;
                ResourceSet resourceSet = this.getResourceSet(project);
                EObject sourceEObject = resourceSet.getEObject(referenceDescription.getSourceEObjectUri(), true);
                if (sourceEObject != null) {
                    TextLocation location = EObjectAtOffsetHelper.getLocation((EObject)sourceEObject, (EReference)referenceDescription.getEReference(), (int)referenceDescription.getIndexInList());
                    this.acceptMatch(storage, location);
                    continue;
                }
                this.acceptMatch(referenceDescription, null);
            }
        }

        protected ResourceSet getResourceSet(IProject project) {
            ResourceSet resourceSet = this.projectToResourceSet.get(project);
            if (resourceSet == null) {
                resourceSet = this.createResourceSet(project);
                this.projectToResourceSet.put(project, resourceSet);
            }
            return resourceSet;
        }

        protected IProject getProject(IStorage storage) {
            if (storage instanceof IResource) {
                return ((IResource)storage).getProject();
            }
            if (storage instanceof IJarEntryResource) {
                IPackageFragmentRoot packageFragmentRoot = ((IJarEntryResource)storage).getPackageFragmentRoot();
                IJavaProject javaProject = packageFragmentRoot.getJavaProject();
                return javaProject.getProject();
            }
            return null;
        }

        protected void acceptMatch(Object element, TextLocation location) {
            if (location != null) {
                this.requestor.reportMatch(new Match(element, location.getOffset(), location.getLength()));
            } else {
                this.requestor.reportMatch(new Match(element, 0, 0));
            }
        }

        protected ResourceSet createResourceSet(IProject project) {
            ResourceSet result = this.resourceSetProvider.get(project);
            this.externalContentSupport.configureResourceSet(result, (IExternalContentSupport.IExternalContentProvider)this.dirtyStateManager);
            return result;
        }
    }

    protected static class UIParticipant
    implements IMatchPresentation {
        private final GlobalDescriptionLabelProvider globalDescriptionsLabelProvider;
        private final IURIEditorOpener uriEditorOpener;
        private final IResourceDescriptions resourceDescriptions;

        public UIParticipant(IResourceDescriptions resourceDescriptions) {
            this.resourceDescriptions = resourceDescriptions;
            this.uriEditorOpener = (IURIEditorOpener)Access.getIURIEditorOpener().get();
            this.globalDescriptionsLabelProvider = (GlobalDescriptionLabelProvider)Access.provider(GlobalDescriptionLabelProvider.class).get();
        }

        public ILabelProvider createLabelProvider() {
            return new ILabelProvider(){

                public void removeListener(ILabelProviderListener listener) {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void dispose() {
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public String getText(Object element) {
                    IReferenceDescription referenceDescription = (IReferenceDescription)element;
                    URI containerEObjectURI = referenceDescription.getContainerEObjectURI();
                    URI eObjectURI = containerEObjectURI == null ? referenceDescription.getSourceEObjectUri() : containerEObjectURI;
                    IResourceDescription resourceDescription = UIParticipant.this.resourceDescriptions.getResourceDescription(eObjectURI.trimFragment());
                    if (resourceDescription != null) {
                        for (IEObjectDescription eObjectDescription : resourceDescription.getExportedObjects()) {
                            if (!eObjectDescription.getEObjectURI().equals((Object)eObjectURI)) continue;
                            return UIParticipant.this.globalDescriptionsLabelProvider.getText((Object)eObjectDescription);
                        }
                    }
                    return "unknown";
                }

                public Image getImage(Object element) {
                    IReferenceDescription referenceDescription = (IReferenceDescription)element;
                    URI containerEObjectURI = referenceDescription.getContainerEObjectURI();
                    URI eObjectURI = containerEObjectURI == null ? referenceDescription.getSourceEObjectUri() : containerEObjectURI;
                    IResourceDescription resourceDescription = UIParticipant.this.resourceDescriptions.getResourceDescription(eObjectURI.trimFragment());
                    if (resourceDescription != null) {
                        for (IEObjectDescription eObjectDescription : resourceDescription.getExportedObjects()) {
                            if (!eObjectDescription.getEObjectURI().equals((Object)eObjectURI)) continue;
                            return UIParticipant.this.globalDescriptionsLabelProvider.getImage((Object)eObjectDescription);
                        }
                    }
                    return null;
                }
            };
        }

        public void showMatch(Match match, int currentOffset, int currentLength, boolean activate) {
            Object o = match.getElement();
            if (o instanceof IReferenceDescription) {
                IReferenceDescription descr = (IReferenceDescription)o;
                if (activate) {
                    this.uriEditorOpener.open(descr.getSourceEObjectUri(), descr.getEReference(), descr.getIndexInList(), true);
                }
            }
        }
    }
}

