/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.ecore;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.core.WorkflowInterruptedException;
import org.eclipse.emf.mwe.utils.Mapping;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.generator.AbstractGeneratorFragment;
import org.eclipse.xtext.generator.ecore.CvsIdFilteringGeneratorAdapterFactoryDescriptor;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreGeneratorFragment
extends AbstractGeneratorFragment {
    private static final Logger log = Logger.getLogger(EcoreGeneratorFragment.class);
    private static final String MODEL_PLUGIN_ID = "modelPluginID";
    private String basePackage = null;
    private String editDirectory = null;
    private String editorDirectory = null;
    private String editorPluginID = null;
    private String editPluginID = null;
    private boolean generateEdit = false;
    private boolean generateEditor = false;
    private String genModel = null;
    private String javaModelDirectory = null;
    private String modelPluginID = null;
    private String referencedGenModels;
    private boolean skipGenerate = false;
    private String xmiModelDirectory = null;
    private String fileExtensions = null;
    private BiMap<URI, URI> saveMappings = Maps.newHashBiMap();

    public EcoreGeneratorFragment() {
        if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("genmodel")) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("genmodel", new EcoreResourceFactoryImpl());
        }
        GenModelPackage.eINSTANCE.getGenAnnotation();
    }

    protected Resource createResourceForEPackages(Grammar grammar, XpandExecutionContext ctx, List<EPackage> packs, ResourceSet rs) {
        URI ecoreFileUri = this.getEcoreFileUri(grammar, ctx);
        Resource ecoreFile = rs.createResource(ecoreFileUri, "");
        ecoreFile.getContents().addAll(packs);
        return ecoreFile;
    }

    protected void doGenerate(GenModel genModel) {
        Diagnostic editorDiag;
        Diagnostic editDiag;
        Generator generator = new Generator();
        generator.getAdapterFactoryDescriptorRegistry().addDescriptor("http://www.eclipse.org/emf/2002/GenModel", (GeneratorAdapterFactory.Descriptor)new CvsIdFilteringGeneratorAdapterFactoryDescriptor());
        generator.setInput((Object)genModel);
        Diagnostic diagnostic = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)new BasicMonitor());
        if (diagnostic.getSeverity() != 0) {
            log.info((Object)diagnostic);
        }
        if (this.isGenerateEdit() && (editDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", (Monitor)new BasicMonitor())).getSeverity() != 0) {
            log.info((Object)editDiag);
        }
        if (this.isGenerateEditor() && (editorDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", (Monitor)new BasicMonitor())).getSeverity() != 0) {
            log.info((Object)editorDiag);
        }
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        try {
            ResourceSet copiedResourceSet = EcoreUtil2.clone((ResourceSet)new XtextResourceSet(), (ResourceSet)grammar.eResource().getResourceSet());
            Grammar copiedGrammar = (Grammar)copiedResourceSet.getResource(grammar.eResource().getURI(), true).getContents().get(0);
            List<EPackage> packs = this.getGeneratedEPackages(copiedGrammar);
            if (!packs.isEmpty()) {
                this.removeFromResource(packs);
                this.proxifyExternalReferences(packs);
                XtextResourceSet resourceSet = this.getNsUriMappingResourceSet();
                Resource ePackages = this.createResourceForEPackages(copiedGrammar, ctx, packs, (ResourceSet)resourceSet);
                List<GenPackage> genPackages = this.loadReferencedGenModels((ResourceSet)resourceSet);
                if (!this.skipGenerate) {
                    GenModel genModel = this.getSaveAndReconcileGenModel((ResourceSet)resourceSet, copiedGrammar, ctx, packs, genPackages);
                    genModel.reconcile();
                    this.doGenerate(genModel);
                    if (this.basePackage == null) {
                        this.basePackage = ((GenPackage)genModel.getGenPackages().get(0)).getBasePackage();
                    }
                    super.generate(copiedGrammar, ctx);
                }
                this.resolveAll((ResourceSet)resourceSet);
                ePackages.save(null);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected List<GenPackage> loadReferencedGenModels(ResourceSet rs) {
        ArrayList result = Lists.newArrayList();
        if (this.getReferencedGenModels() != null) {
            String[] stringArray = this.getReferencedGenModels().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String uri = stringArray[n2];
                try {
                    Resource resource = rs.getResource(URI.createURI((String)uri.trim()), true);
                    GenModel genmodel = (GenModel)resource.getContents().get(0);
                    EList genPackages = genmodel.getGenPackages();
                    for (GenPackage genPackage : genPackages) {
                        genPackage.getEcorePackage().getEClassifiers();
                        result.add(genPackage);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Couldn't find genmodel for uri '" + uri + "'"));
                    throw new RuntimeException(e);
                }
                ++n2;
            }
        }
        return result;
    }

    protected void proxifyExternalReferences(List<EPackage> packs) {
        EObject key;
        HashMap object2Uri = Maps.newHashMap();
        Map map = EcoreUtil.CrossReferencer.find(packs);
        for (Map.Entry entry : map.entrySet()) {
            key = (EObject)entry.getKey();
            if (key.eResource() == null) continue;
            object2Uri.put(key, EcoreUtil.getURI((EObject)key));
        }
        for (Map.Entry entry : object2Uri.entrySet()) {
            key = (InternalEObject)entry.getKey();
            if (!this.shouldBeProxified((InternalEObject)key, packs)) continue;
            this.checkGenModelExists((InternalEObject)key);
            key.eSetProxyURI((URI)entry.getValue());
        }
    }

    protected void checkGenModelExists(InternalEObject key) {
        if (this.getReferencedGenModels() == null && this.genModel == null) {
            throw new WorkflowInterruptedException("The generated EPackage references an external EPackage, but 'referencedGenModels' hasn't been registered.");
        }
    }

    private boolean shouldBeProxified(InternalEObject key, List<EPackage> packs) {
        if (EcorePackage.eINSTANCE.eResource() == key.eResource()) {
            return false;
        }
        TreeIterator iterator = EcoreUtil.getAllContents(packs);
        while (iterator.hasNext()) {
            if (key != iterator.next()) continue;
            return false;
        }
        return true;
    }

    protected void removeFromResource(List<EPackage> packs) {
        for (EPackage ePackage : packs) {
            ePackage.eResource().getContents().remove((Object)ePackage);
        }
    }

    protected void resolveAll(ResourceSet resourceSet) {
        URI uri;
        HashMap resourceToURI = Maps.newHashMap();
        for (Resource res : resourceSet.getResources()) {
            uri = res.getURI();
            URI mappedFrom = (URI)this.saveMappings.inverse().get((Object)uri);
            if (mappedFrom != null) {
                res.setURI(mappedFrom);
            }
            if (!uri.isPlatformResource()) continue;
            resourceToURI.put(res, uri);
            URI path = EcorePlugin.resolvePlatformResourcePath((String)uri.toPlatformString(true));
            res.setURI(path);
        }
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        for (Resource res : resourceSet.getResources()) {
            URI mappedTo;
            uri = (URI)resourceToURI.get(res);
            if (uri == null) {
                uri = res.getURI();
            }
            if ((mappedTo = (URI)this.saveMappings.get((Object)uri)) == null) continue;
            res.setURI(mappedTo);
        }
    }

    public String getBasePackage(Grammar g) {
        if (this.basePackage == null) {
            return GrammarUtil.getNamespace((Grammar)g);
        }
        return this.basePackage;
    }

    protected URI getEcoreFileUri(Grammar grammar, XpandExecutionContext ctx) {
        String javaPath = this.getJavaModelDirectory(ctx);
        String xmiPath = this.getXmiModelDirectory(grammar, javaPath);
        try {
            String prefix = String.valueOf(new File(xmiPath).getCanonicalPath()) + "/" + this.getModelName(grammar);
            URI ecoreFileUri = URI.createFileURI((String)(String.valueOf(prefix) + ".ecore"));
            return ecoreFileUri;
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't compute canonical path for " + new File(xmiPath).getAbsolutePath());
        }
    }

    public String getEditDirectory(XpandExecutionContext ctx) {
        if (this.editDirectory == null || "".equals(this.editDirectory)) {
            this.editDirectory = String.valueOf(ctx.getOutput().getOutlet("PLUGIN").getPath()) + ".edit/src";
        }
        return this.editDirectory;
    }

    public String getEditorDirectory(XpandExecutionContext ctx) {
        if (this.editorDirectory == null || "".equals(this.editorDirectory)) {
            this.editorDirectory = String.valueOf(ctx.getOutput().getOutlet("PLUGIN").getPath()) + ".editor/src";
        }
        return this.editorDirectory;
    }

    protected String getEditorPluginID(XpandExecutionContext ctx) {
        if ((this.editorPluginID == null || "".equals(this.editorPluginID)) && this.getModelPluginID(ctx) != null) {
            this.editorPluginID = String.valueOf(this.getModelPluginID(ctx)) + ".editor";
        }
        return this.editorPluginID;
    }

    public String getEditPluginID(XpandExecutionContext ctx) {
        if ((this.editPluginID == null || "".equals(this.editPluginID)) && this.getModelPluginID(ctx) != null) {
            this.editPluginID = String.valueOf(this.getModelPluginID(ctx)) + ".edit";
        }
        return this.editPluginID;
    }

    @Override
    public String[] getExportedPackagesRt(Grammar grammar) {
        List typeSelect = EcoreUtil2.typeSelect((List)grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
        LinkedHashSet<String> exportedPackages = new LinkedHashSet<String>();
        for (GeneratedMetamodel generatedMetamodel : typeSelect) {
            String modelPackage = Strings.skipLastToken((String)this.getGeneratedEPackageName(grammar, generatedMetamodel.getEPackage()), (String)".");
            exportedPackages.add(modelPackage);
            exportedPackages.add(String.valueOf(modelPackage) + ".impl");
            exportedPackages.add(String.valueOf(modelPackage) + ".util");
        }
        return exportedPackages.toArray(new String[exportedPackages.size()]);
    }

    public String getGeneratedEPackageName(Grammar g, EPackage pack) {
        return String.valueOf(this.getBasePackage(g)) + "." + pack.getName() + "." + Strings.toFirstUpper((String)pack.getName()) + "Package";
    }

    protected List<EPackage> getGeneratedEPackages(Grammar grammar) {
        List list = EcoreUtil2.typeSelect((List)grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
        List packs = EcoreUtil2.collect((Collection)list, (int)0, EPackage.class);
        return packs;
    }

    protected GenModel getGenModel(ResourceSet rs, Grammar grammar, XpandExecutionContext ctx, List<EPackage> packs) {
        GenModel genModel;
        URI genModelUri = this.getGenModelUri(grammar, ctx);
        Resource genModelFile = rs.createResource(genModelUri, "");
        if (rs.getURIConverter().exists(genModelUri, null)) {
            try {
                genModelFile.load(null);
            }
            catch (IOException e) {
                throw new WrappedException((Exception)e);
            }
            genModel = genModelUri.hasFragment() ? (GenModel)genModelFile.getEObject(genModelUri.fragment()) : (GenModel)genModelFile.getContents().get(0);
        } else {
            genModel = GenModelPackage.eINSTANCE.getGenModelFactory().createGenModel();
            genModel.setModelDirectory(this.toGenModelProjectPath(this.getJavaModelDirectory(ctx)));
            genModel.setModelName(this.getModelName(grammar));
            genModel.setModelPluginID(this.getModelPluginID(ctx));
            genModel.setEditDirectory(this.toGenModelProjectPath(this.getEditDirectory(ctx)));
            genModel.setEditorDirectory(this.toGenModelProjectPath(this.getEditorDirectory(ctx)));
            genModel.setEditPluginID(this.getEditPluginID(ctx));
            genModel.setEditorPluginID(this.getEditorPluginID(ctx));
            genModel.setValidateModel(false);
            genModel.setForceOverwrite(true);
            genModel.setCanGenerate(true);
            genModel.setFacadeHelperClass(null);
            genModel.setBundleManifest(true);
            genModel.setUpdateClasspath(false);
            genModel.setComplianceLevel(GenJDKLevel.JDK50_LITERAL);
            genModel.setRootExtendsClass("org.eclipse.emf.ecore.impl.MinimalEObjectImpl$Container");
        }
        genModelFile.getContents().add((Object)genModel);
        return genModel;
    }

    protected URI getGenModelUri(Grammar grammar, XpandExecutionContext ctx) {
        String prefix;
        if (this.genModel != null) {
            return URI.createURI((String)this.genModel);
        }
        try {
            prefix = String.valueOf(new File(this.getXmiModelDirectory(grammar, this.getJavaModelDirectory(ctx))).getCanonicalPath()) + "/" + this.getModelName(grammar);
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
        URI genModelUri = URI.createFileURI((String)(String.valueOf(prefix) + ".genmodel"));
        return genModelUri;
    }

    protected String getJavaModelDirectory(XpandExecutionContext ctx) {
        String javaPath = this.javaModelDirectory == null || "".equals(this.javaModelDirectory) ? ctx.getOutput().getOutlet("SRC_GEN").getPath() : this.javaModelDirectory;
        return javaPath;
    }

    protected String getModelName(Grammar grammar) {
        return grammar.getName().substring(grammar.getName().lastIndexOf(46) + 1);
    }

    public String getModelPluginID(XpandExecutionContext ctx) {
        if ((this.modelPluginID == null || "".equals(this.modelPluginID)) && ctx.getVariable(MODEL_PLUGIN_ID) != null) {
            this.modelPluginID = (String)ctx.getVariable(MODEL_PLUGIN_ID).getValue();
        }
        return this.modelPluginID;
    }

    protected XtextResourceSet getNsUriMappingResourceSet() {
        return new XtextResourceSet(){
            final Map<URI, URI> uriMapping = Maps.newHashMap();

            public EObject getEObject(URI uri, boolean loadOnDemand) {
                EObject eObject = super.getEObject(uri, loadOnDemand);
                if (eObject instanceof EPackage) {
                    EPackage pack = (EPackage)eObject;
                    this.uriMapping.put(URI.createURI((String)pack.getNsURI()), pack.eResource().getURI());
                }
                return eObject;
            }

            public Resource getResource(URI uri, boolean loadOnDemand) {
                if (this.uriMapping.containsKey(uri)) {
                    uri = this.uriMapping.get(uri);
                }
                return super.getResource(uri, loadOnDemand);
            }
        };
    }

    @Override
    protected List<Object> getParameters(Grammar grammar) {
        return Collections.singletonList(this.getBasePackage(grammar));
    }

    public String getReferencedGenModels() {
        return this.referencedGenModels;
    }

    @Override
    public String[] getRequiredBundlesRt(Grammar grammar) {
        return new String[]{"org.eclipse.emf.ecore", "org.eclipse.emf.common"};
    }

    protected GenModel getSaveAndReconcileGenModel(ResourceSet rs, Grammar grammar, XpandExecutionContext ctx, List<EPackage> packs, List<GenPackage> usedGenPackages) throws ConfigurationException {
        GenModel genModel = null;
        genModel = this.getGenModel(rs, grammar, ctx, packs);
        genModel.initialize(packs);
        for (GenPackage genPackage : genModel.getGenPackages()) {
            genPackage.setBasePackage(this.getBasePackage(grammar));
            if (this.getFileExtensions() == null || !packs.contains(genPackage.getEcorePackage())) continue;
            genPackage.setFileExtensions(this.getFileExtensions());
        }
        genModel.getUsedGenPackages().addAll(usedGenPackages);
        this.resolveAll(rs);
        try {
            genModel.eResource().save(null);
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
        return genModel;
    }

    public String getXmiModelDirectory() {
        return this.xmiModelDirectory;
    }

    protected String getXmiModelDirectory(Grammar grammar, String javaPath) {
        String xmiPath = this.getXmiModelDirectory() == null || "".equals(this.getXmiModelDirectory()) ? String.valueOf(javaPath) + "/" + grammar.getName().substring(0, grammar.getName().lastIndexOf(46)).replace('.', '/') : this.getXmiModelDirectory();
        return xmiPath;
    }

    public boolean isGenerateEdit() {
        return this.generateEdit;
    }

    public boolean isGenerateEditor() {
        return this.generateEditor;
    }

    public boolean isSkipGenerate() {
        return this.skipGenerate;
    }

    public void setGenModels(String uris) {
        log.warn((Object)"The property 'genModels' is deprecated. Please use 'referencedGenModels' instead.");
        this.setReferencedGenModels(uris);
    }

    public void setBasePackage(String basePackage) {
        if ("".equals(basePackage.trim())) {
            return;
        }
        this.basePackage = basePackage;
    }

    public void setEditDirectory(String editDirectory) {
        this.editDirectory = editDirectory;
    }

    public void setEditorDirectory(String editorDirectory) {
        this.editorDirectory = editorDirectory;
    }

    public void setEditorPluginID(String editorPluginId) {
        this.editorPluginID = editorPluginId;
    }

    public void setEditPluginID(String editPluginId) {
        this.editPluginID = editPluginId;
    }

    public void setGenerateEdit(boolean gen) {
        this.generateEdit = gen;
    }

    public void setGenerateEditor(boolean gen) {
        this.generateEditor = gen;
    }

    public void setGenModel(String genModel) {
        if ("".equals(genModel)) {
            return;
        }
        this.genModel = genModel;
    }

    public void setJavaModelDirectory(String dir) {
        this.javaModelDirectory = dir;
    }

    public void setModelPluginID(String modelPluginId) {
        this.modelPluginID = modelPluginId;
    }

    public void setReferencedGenModels(String referencedGenModel) {
        if ("".equals(referencedGenModel)) {
            return;
        }
        this.referencedGenModels = referencedGenModel;
    }

    public void setSkipGenerate(boolean skipGenerate) {
        this.skipGenerate = skipGenerate;
    }

    public void setXmiModelDirectory(String dir) {
        this.xmiModelDirectory = dir;
    }

    protected String toGenModelProjectPath(String path) {
        return path == null || "".equals(path) || path.startsWith("/") ? path : path.substring(path.indexOf("/"));
    }

    public void addSaveMapping(Mapping mapping) {
        this.saveMappings.put((Object)URI.createURI((String)mapping.getFrom()), (Object)URI.createURI((String)mapping.getTo()));
    }

    public void setFileExtensions(String fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public String getFileExtensions() {
        return this.fileExtensions;
    }
}

