/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.IDirtyResource;
import org.eclipse.xtext.ui.editor.StatefulResourceDescription;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class DocumentBasedDirtyResource
implements IDirtyResource {
    private IXtextDocument document;
    private IResourceDescription description;
    private String content;

    public void connect(IXtextDocument document) {
        if (document == null) {
            throw new IllegalArgumentException("document may not be null");
        }
        if (this.document == document) {
            return;
        }
        if (this.document != null) {
            throw new IllegalStateException("Dirty resource was already connected to another document");
        }
        this.document = document;
        document.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource resource) {
                if (resource != null) {
                    DocumentBasedDirtyResource.this.initiallyProcessResource(resource);
                }
            }
        });
    }

    protected void initiallyProcessResource(XtextResource resource) {
        IResourceDescription description;
        IResourceDescription.Manager descriptionManager;
        IResourceServiceProvider serviceProvider = resource.getResourceServiceProvider();
        if (serviceProvider != null && (descriptionManager = serviceProvider.getResourceDescriptionManager()) != null && (description = descriptionManager.getResourceDescription((Resource)resource)) != null) {
            this.copyState(description);
        }
    }

    public void disconnect(IXtextDocument document) {
        if (document == null) {
            throw new IllegalArgumentException("document may not be null");
        }
        if (this.document != document) {
            throw new IllegalStateException("Cannot disconnect document that is not connected");
        }
        this.document = null;
        this.description = null;
        this.content = null;
    }

    public synchronized void copyState(IResourceDescription original) {
        this.description = new StatefulResourceDescription(original);
        this.content = this.getUnderlyingDocument().get();
    }

    public IXtextDocument getUnderlyingDocument() {
        return this.document;
    }

    public boolean isInitialized() {
        return this.description != null;
    }

    public URI getURI() {
        if (this.document == null) {
            throw new IllegalStateException("Cannot use getURI if this dirty resource is not connected to a document");
        }
        if (this.description == null) {
            throw new IllegalStateException("Cannot use getURI if this dirty resource is currently not initialized");
        }
        return this.description.getURI();
    }

    public synchronized IResourceDescription getDescription() {
        if (this.document == null) {
            throw new IllegalStateException("Cannot use getDescription if this dirty resource is not connected to a document");
        }
        if (this.description == null) {
            throw new IllegalStateException("Cannot use getDescription if this dirty resource is currently not initialized");
        }
        return this.description;
    }

    public synchronized String getContents() {
        if (this.document == null) {
            throw new IllegalStateException("Cannot use getContents if this dirty resource is not connected to a document");
        }
        if (this.content == null) {
            throw new IllegalStateException("Cannot use getContents if this dirty resource is currently not mementoed");
        }
        return this.content;
    }
}

