/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.compiler;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xtend2.richstring.AbstractRichStringPartAcceptor;
import org.eclipse.xtext.xtend2.richstring.DefaultIndentationHandler;
import org.eclipse.xtext.xtend2.richstring.IRichStringIndentationHandler;
import org.eclipse.xtext.xtend2.richstring.RichStringProcessor;
import org.eclipse.xtext.xtend2.xtend2.RichString;
import org.eclipse.xtext.xtend2.xtend2.RichStringForLoop;
import org.eclipse.xtext.xtend2.xtend2.RichStringIf;
import org.eclipse.xtext.xtend2.xtend2.RichStringLiteral;

public class Xtend2Compiler
extends XbaseCompiler {
    @Inject
    private RichStringProcessor richStringProcessor;
    @Inject
    private Provider<DefaultIndentationHandler> indentationHandler;

    protected String getFavoriteVariableName(EObject ex) {
        if (ex instanceof RichStringForLoop) {
            return "hasAnyElements";
        }
        return super.getFavoriteVariableName(ex);
    }

    public void _toJavaStatement(RichString richString, IAppendable b, boolean isReferenced) {
        JvmTypeReference type = this.getTypeReferences().getTypeForName(StringConcatenation.class, (EObject)richString, new JvmTypeReference[0]);
        String variableName = b.declareSyntheticVariable((Object)Tuples.pair((Object)richString, (Object)"result"), "_builder");
        b.append("\n");
        this.serialize(type, (EObject)richString, b);
        b.append(" ");
        b.append(variableName);
        b.append(" = new ");
        this.serialize(type, (EObject)richString, b);
        b.append("();");
        RichStringPrepareCompiler compiler = new RichStringPrepareCompiler(b, variableName);
        this.richStringProcessor.process(richString, compiler, (IRichStringIndentationHandler)this.indentationHandler.get());
    }

    public void _toJavaExpression(RichString richString, IAppendable b) {
        b.append(this.getVarName(Tuples.pair((Object)richString, (Object)"result"), b));
    }

    public class RichStringPrepareCompiler
    extends AbstractRichStringPartAcceptor.ForLoopOnce {
        private final LinkedList<RichStringIf> ifStack = Lists.newLinkedList();
        private final LinkedList<RichStringForLoop> forStack = Lists.newLinkedList();
        private final IAppendable appendable;
        private final String variableName;

        public RichStringPrepareCompiler(IAppendable appendable, String variableName) {
            this.appendable = appendable;
            this.variableName = variableName;
        }

        public void acceptSemanticLineBreak(int charCount, RichStringLiteral origin, boolean controlStructureSeen) {
            this.appendable.append("\n");
            this.appendable.append(this.variableName);
            if (!controlStructureSeen) {
                this.appendable.append(".newLine();");
            } else {
                this.appendable.append(".newLineIfNotEmpty();");
            }
        }

        public void acceptTemplateLineBreak(int charCount, RichStringLiteral origin) {
        }

        public void acceptSemanticText(CharSequence text, RichStringLiteral origin) {
            if (text.length() == 0) {
                return;
            }
            this.appendable.append("\n");
            this.appendable.append(this.variableName);
            this.appendable.append(".append(\"");
            this.appendable.append(Strings.convertToJavaString((String)text.toString()));
            this.appendable.append("\");");
        }

        public void acceptIfCondition(XExpression condition) {
            this.ifStack.add((RichStringIf)condition.eContainer());
            this.appendable.append("\n");
            this.appendable.append("{").increaseIndentation();
            this.writeIf(condition);
        }

        public void acceptElseIfCondition(XExpression condition) {
            this.writeElse();
            this.writeIf(condition);
        }

        protected void writeIf(XExpression condition) {
            Xtend2Compiler.this.internalToJavaStatement(condition, this.appendable, true);
            this.appendable.append("\n");
            this.appendable.append("if (");
            Xtend2Compiler.this.internalToJavaExpression(condition, this.appendable);
            this.appendable.append(") {").increaseIndentation();
        }

        protected void writeElse() {
            this.appendable.decreaseIndentation();
            this.appendable.append("\n");
            this.appendable.append("} else {");
            this.appendable.increaseIndentation();
        }

        public void acceptElse() {
            this.writeElse();
        }

        public void acceptEndIf() {
            RichStringIf richStringIf = this.ifStack.removeLast();
            int i = 0;
            while (i < richStringIf.getElseIfs().size() + 2) {
                this.appendable.decreaseIndentation();
                this.appendable.append("\n");
                this.appendable.append("}");
                ++i;
            }
        }

        public void acceptForLoop(JvmFormalParameter parameter, XExpression expression) {
            super.acceptForLoop(parameter, expression);
            RichStringForLoop forLoop = (RichStringForLoop)expression.eContainer();
            this.forStack.add(forLoop);
            this.appendable.append("\n").append("{").increaseIndentation();
            Xtend2Compiler.this.internalToJavaStatement(expression, this.appendable, true);
            String variableName = null;
            if (forLoop.getAfter() != null || forLoop.getSeparator() != null || forLoop.getAfter() != null) {
                variableName = this.appendable.declareSyntheticVariable((Object)forLoop, "_hasElements");
                this.appendable.append("\n");
                this.appendable.append("boolean ");
                this.appendable.append(variableName);
                this.appendable.append(" = false;");
            }
            this.appendable.append("\n");
            this.appendable.append("for(final ");
            JvmTypeReference paramType = Xtend2Compiler.this.getTypeProvider().getTypeForIdentifiable((JvmIdentifiableElement)parameter);
            Xtend2Compiler.this.serialize(paramType, (EObject)parameter, this.appendable);
            this.appendable.append(" ");
            String loopParam = this.appendable.declareVariable((Object)parameter, parameter.getName());
            this.appendable.append(loopParam);
            this.appendable.append(" : ");
            Xtend2Compiler.this.internalToJavaExpression(expression, this.appendable);
            this.appendable.append(") {").increaseIndentation();
        }

        public boolean forLoopHasNext(XExpression before, XExpression separator, CharSequence indentation) {
            if (!super.forLoopHasNext(before, separator, indentation)) {
                return false;
            }
            RichStringForLoop forLoop = this.forStack.getLast();
            String varName = Xtend2Compiler.this.getVarName(forLoop, this.appendable);
            if (varName != null) {
                this.appendable.append("\n");
                this.appendable.append("if (!");
                this.appendable.append(varName);
                this.appendable.append(") {");
                this.appendable.increaseIndentation();
                this.appendable.append("\n");
                this.appendable.append(varName);
                this.appendable.append(" = true;");
                if (before != null) {
                    this.writeExpression(before, indentation, false);
                }
                this.appendable.decreaseIndentation();
                this.appendable.append("\n");
                this.appendable.append("}");
                if (forLoop.getSeparator() != null) {
                    this.appendable.append(" else {");
                    this.appendable.increaseIndentation();
                    this.writeExpression(separator, indentation, true);
                    this.appendable.decreaseIndentation();
                    this.appendable.append("\n");
                    this.appendable.append("}");
                }
            }
            return true;
        }

        public void acceptEndFor(XExpression after, CharSequence indentation) {
            super.acceptEndFor(after, indentation);
            this.appendable.decreaseIndentation();
            this.appendable.append("\n");
            this.appendable.append("}");
            RichStringForLoop forLoop = this.forStack.removeLast();
            if (after != null) {
                String varName = Xtend2Compiler.this.getVarName(forLoop, this.appendable);
                this.appendable.append("\n");
                this.appendable.append("if (");
                this.appendable.append(varName);
                this.appendable.append(") {");
                this.appendable.increaseIndentation();
                this.writeExpression(after, indentation, false);
                this.appendable.decreaseIndentation();
                this.appendable.append("\n");
                this.appendable.append("}");
            }
            this.appendable.decreaseIndentation();
            this.appendable.append("\n");
            this.appendable.append("}");
        }

        public void acceptExpression(XExpression expression, CharSequence indentation) {
            this.writeExpression(expression, indentation, false);
        }

        protected void writeExpression(XExpression expression, CharSequence indentation, boolean immediate) {
            Xtend2Compiler.this.internalToJavaStatement(expression, this.appendable, true);
            if (!Xtend2Compiler.this.getTypeReferences().is(Xtend2Compiler.this.getTypeProvider().getType(expression), Void.TYPE)) {
                this.appendable.append("\n");
                this.appendable.append(this.variableName);
                if (immediate) {
                    this.appendable.append(".appendImmediate(");
                } else {
                    this.appendable.append(".append(");
                }
                Xtend2Compiler.this.internalToJavaExpression(expression, this.appendable);
                this.appendable.append(", \"");
                this.appendable.append(indentation.toString());
                this.appendable.append("\");");
            }
        }
    }
}

