/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.containers;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.containers.AbstractStorage2UriMapperClient;
import org.eclipse.xtext.ui.resource.PackageFragmentRootWalker;
import org.eclipse.xtext.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class JavaProjectsStateHelper
extends AbstractStorage2UriMapperClient {
    private static final Logger log = Logger.getLogger(JavaProjectsStateHelper.class);
    @Inject
    private IWorkspace workspace;

    public String initHandle(URI uri) {
        IPackageFragmentRoot root = this.getPackageFragmentRoot(uri);
        if (root != null) {
            return root.getHandleIdentifier();
        }
        return null;
    }

    public List<String> initVisibleHandles(String handle) {
        IJavaElement javaElement = JavaCore.create((String)handle);
        if (javaElement != null) {
            IJavaProject project = javaElement.getJavaProject();
            if (this.isAccessibleXtextProject(project.getProject())) {
                List<String> rootHandles = this.getPackageFragmentRootHandles(project);
                return rootHandles;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public Collection<URI> initContainedURIs(String containerHandle) {
        IJavaElement javaElement = JavaCore.create((String)containerHandle);
        if (javaElement instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement;
            IJavaProject javaProject = root.getJavaProject();
            if (!this.isAccessibleXtextProject(javaProject.getProject())) {
                return Collections.emptyList();
            }
            final ArrayList uris = Lists.newArrayList();
            if (root.isArchive() || root.isExternal()) {
                try {
                    new PackageFragmentRootWalker<Void>(){

                        @Override
                        protected Void handle(IJarEntryResource jarEntry, PackageFragmentRootWalker.TraversalState state) {
                            URI uri = JavaProjectsStateHelper.this.getUri((IStorage)jarEntry);
                            if (uri != null) {
                                uris.add(uri);
                            }
                            return null;
                        }
                    }.traverse(root, false);
                    return uris;
                }
                catch (JavaModelException e) {
                    if (!e.isDoesNotExist()) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    return Collections.emptyList();
                }
            }
            try {
                IProject project;
                IResource resource = root.getResource();
                if (resource != null && this.isAccessibleXtextProject(project = resource.getProject())) {
                    resource.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (resource instanceof IStorage) {
                                URI uri = JavaProjectsStateHelper.this.getUri((IStorage)resource);
                                if (uri != null) {
                                    uris.add(uri);
                                }
                                return false;
                            }
                            return true;
                        }
                    });
                }
                return uris;
            }
            catch (CoreException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    protected List<String> getPackageFragmentRootHandles(IJavaProject project) {
        ArrayList result;
        block4: {
            result = Lists.newArrayList();
            try {
                IPackageFragmentRoot[] roots;
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = project.getAllPackageFragmentRoots();
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (root != null && !JavaRuntime.newDefaultJREContainerPath().isPrefixOf(root.getRawClasspathEntry().getPath())) {
                        result.add(root.getHandleIdentifier());
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                if (e.isDoesNotExist()) break block4;
                log.error((Object)("Cannot find rootHandles in project " + project.getProject().getName()), (Throwable)e);
            }
        }
        return result;
    }

    protected IPackageFragmentRoot getPackageFragmentRoot(URI uri) {
        if (uri.isArchive() || !uri.isPlatform()) {
            return this.getJarWithEntry(uri);
        }
        IFile file = this.getWorkspaceRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        if (file == null) {
            return this.getJarWithEntry(uri);
        }
        IPackageFragmentRoot root = this.getJavaElement(file);
        if (root == null) {
            return this.getJarWithEntry(uri);
        }
        return root;
    }

    protected IPackageFragmentRoot getJavaElement(IFile file) {
        block5: {
            IJavaProject jp = JavaCore.create((IProject)file.getProject());
            if (!jp.exists()) {
                return null;
            }
            try {
                IPackageFragmentRoot[] roots;
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = jp.getPackageFragmentRoots();
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource2;
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (root.getKind() == 1 && (resource2 = root.getUnderlyingResource()).contains((ISchedulingRule)file)) {
                        return root;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                if (e.isDoesNotExist()) break block5;
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected IPackageFragmentRoot getJarWithEntry(URI uri) {
        Iterable<Pair<IStorage, IProject>> storages = this.getStorages(uri);
        IPackageFragmentRoot result = null;
        for (Pair<IStorage, IProject> storage2Project : storages) {
            IPackageFragmentRoot fragmentRoot;
            IStorage storage = (IStorage)storage2Project.getFirst();
            if (!(storage instanceof IJarEntryResource) || (fragmentRoot = ((IJarEntryResource)storage).getPackageFragmentRoot()) == null) continue;
            IJavaProject javaProject = fragmentRoot.getJavaProject();
            if (this.isAccessibleXtextProject(javaProject.getProject())) {
                return fragmentRoot;
            }
            if (result == null) continue;
            result = fragmentRoot;
        }
        return result;
    }

    protected boolean isAccessibleXtextProject(IProject p) {
        return p != null && XtextProjectHelper.hasNature(p);
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return this.workspace.getRoot();
    }

    public void setWorkspace(IWorkspace workspace) {
        this.workspace = workspace;
    }
}

