/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.findrefs.FindReferenceQueryDataFactory;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.Messages;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceQuery;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class FindReferencesHandler
extends AbstractHandler {
    @Inject
    protected EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    protected IGlobalServiceProvider globalServiceProvider;
    @Inject
    protected FindReferenceQueryDataFactory queryDataFactory;
    private static final Logger LOG = Logger.getLogger(FindReferencesHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            XtextEditor editor = EditorUtils.getActiveXtextEditor(event);
            if (editor != null) {
                QueryExecutor queryExecutor;
                final ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                IReferenceFinder.IQueryData context = (IReferenceFinder.IQueryData)editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<IReferenceFinder.IQueryData, XtextResource>(){

                    public IReferenceFinder.IQueryData exec(XtextResource localResource) throws Exception {
                        return FindReferencesHandler.this.createQueryData(localResource, selection);
                    }
                });
                if (context != null && (queryExecutor = (QueryExecutor)this.globalServiceProvider.findService(context.getLeadElementURI().trimFragment(), QueryExecutor.class)) != null) {
                    queryExecutor.execute(context);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)Messages.FindReferencesHandler_3, (Throwable)e);
        }
        return null;
    }

    protected IReferenceFinder.IQueryData createQueryData(XtextResource localResource, ITextSelection selection) {
        EObject element = this.eObjectAtOffsetHelper.resolveElementAt(localResource, selection.getOffset());
        if (element != null) {
            URI localResourceURI = localResource.getURI();
            IReferenceFinder.IQueryData queryData = this.queryDataFactory.createQueryData(element, localResourceURI);
            return queryData;
        }
        return null;
    }

    public static class QueryExecutor {
        @Inject
        private Provider<ReferenceQuery> queryProvider;

        public void execute(IReferenceFinder.IQueryData queryData) {
            if (!queryData.getTargetURIs().isEmpty()) {
                ReferenceQuery referenceQuery = (ReferenceQuery)this.queryProvider.get();
                referenceQuery.init(queryData);
                NewSearchUI.activateSearchResultView();
                NewSearchUI.runQueryInBackground((ISearchQuery)referenceQuery);
            }
        }
    }
}

