/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.impl;

import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NameConcatHelper {
    NameConcatHelper() {
    }

    static void appendConstraintsName(StringBuilder result, List<JvmTypeConstraint> constraints, char innerClassDelimiter, NameType nameType) {
        if (constraints == null || constraints.isEmpty()) {
            return;
        }
        int wasLength = result.length();
        boolean hasLowerBound = false;
        if (nameType != NameType.ID) {
            for (JvmTypeConstraint constraint : constraints) {
                if (!(constraint instanceof JvmLowerBound)) continue;
                hasLowerBound = true;
                break;
            }
        }
        for (JvmTypeConstraint constraint : constraints) {
            if (result.length() != wasLength) {
                result.append(" & ");
            }
            if (hasLowerBound && !(constraint instanceof JvmLowerBound) && nameType != NameType.ID) continue;
            switch (nameType) {
                case ID: {
                    result.append(constraint.getIdentifier());
                    break;
                }
                case QUALIFIED: {
                    result.append(constraint.getQualifiedName(innerClassDelimiter));
                    break;
                }
                case SIMPLE: {
                    result.append(constraint.getSimpleName());
                }
            }
        }
    }

    static String computeFor(JvmWildcardTypeReference typeReference, char innerClassDelimiter, NameType nameType) {
        if (typeReference.eIsSet((EStructuralFeature)TypesPackage.Literals.JVM_CONSTRAINT_OWNER__CONSTRAINTS)) {
            JvmTypeConstraint onlyConstraint;
            if (typeReference.getConstraints().size() == 1 && nameType != NameType.ID && (onlyConstraint = (JvmTypeConstraint)typeReference.getConstraints().get(0)) instanceof JvmUpperBound && Object.class.getCanonicalName().equals(onlyConstraint.getTypeReference().getIdentifier())) {
                return "?";
            }
            StringBuilder mutableResult = new StringBuilder(64);
            mutableResult.append("? ");
            NameConcatHelper.appendConstraintsName(mutableResult, (List<JvmTypeConstraint>)typeReference.getConstraints(), innerClassDelimiter, nameType);
            return mutableResult.toString();
        }
        return "?";
    }

    static String computeFor(JvmParameterizedTypeReference typeReference, char innerClassDelimiter, NameType nameType) {
        if (typeReference.eIsSet((EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE)) {
            StringBuilder mutableResult = new StringBuilder(64);
            JvmType type = typeReference.getType();
            switch (nameType) {
                case ID: {
                    mutableResult.append(type.getIdentifier());
                    break;
                }
                case QUALIFIED: {
                    mutableResult.append(type.getQualifiedName(innerClassDelimiter));
                    break;
                }
                case SIMPLE: {
                    mutableResult.append(type.getSimpleName());
                }
            }
            if (typeReference.eIsSet((EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__ARGUMENTS)) {
                mutableResult.append("<");
                NameConcatHelper.appendArguments(mutableResult, typeReference.getArguments(), innerClassDelimiter, nameType);
                mutableResult.append(">");
                return mutableResult.toString();
            }
            return mutableResult.toString();
        }
        return null;
    }

    static void appendArguments(StringBuilder result, List<JvmTypeReference> arguments, char innerClassDelimiter, NameType nameType) {
        if (arguments == null || arguments.isEmpty()) {
            return;
        }
        int wasLength = result.length();
        for (JvmTypeReference argument : arguments) {
            if (result.length() != wasLength) {
                result.append(",");
            }
            switch (nameType) {
                case ID: {
                    result.append(argument.getIdentifier());
                    break;
                }
                case QUALIFIED: {
                    result.append(argument.getQualifiedName(innerClassDelimiter));
                    break;
                }
                case SIMPLE: {
                    result.append(argument.getSimpleName());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NameType {
        ID,
        QUALIFIED,
        SIMPLE;

    }
}

