/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.autoedit;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategy;
import org.eclipse.xtext.ui.editor.autoedit.MultiLineTerminalsEditStrategy;

public class CompoundMultiLineTerminalsEditStrategy
extends AbstractEditStrategy {
    @Inject
    private MultiLineTerminalsEditStrategy.Factory multiLineTerminalsStrategyFactory;
    private List<MultiLineTerminalsEditStrategy> strategies = Lists.newArrayList();

    protected CompoundMultiLineTerminalsEditStrategy() {
    }

    public CompoundMultiLineTerminalsEditStrategy and(String leftTerminal, String indentationString, String rightTerminal) {
        this.strategies.add(this.multiLineTerminalsStrategyFactory.newInstance(leftTerminal, indentationString, rightTerminal));
        return this;
    }

    public CompoundMultiLineTerminalsEditStrategy and(String leftTerminal, String rightTerminal) {
        return this.and(leftTerminal, null, rightTerminal);
    }

    protected void internalCustomizeDocumentCommand(IDocument document, DocumentCommand command) throws BadLocationException {
        if (command.length != 0) {
            return;
        }
        String[] lineDelimiters = document.getLegalLineDelimiters();
        int delimiterIndex = TextUtilities.startsWith((String[])lineDelimiters, (String)command.text);
        if (delimiterIndex != -1) {
            MultiLineTerminalsEditStrategy bestStrategy = null;
            IRegion bestStart = null;
            for (MultiLineTerminalsEditStrategy strategy : this.strategies) {
                IRegion candidate = strategy.findStartTerminal(document, command.offset);
                if (candidate == null || bestStart != null && bestStart.getOffset() >= candidate.getOffset()) continue;
                bestStrategy = strategy;
                bestStart = candidate;
            }
            if (bestStrategy != null) {
                bestStrategy.internalCustomizeDocumentCommand(document, command);
            }
        }
    }

    public static class Factory {
        @Inject
        private MembersInjector<CompoundMultiLineTerminalsEditStrategy> injector;

        public CompoundMultiLineTerminalsEditStrategy newInstanceFor(String leftTerminal, String rightTerminal) {
            return this.newInstanceFor(leftTerminal, null, rightTerminal);
        }

        public CompoundMultiLineTerminalsEditStrategy newInstanceFor(String leftTerminal, String indentationString, String rightTerminal) {
            CompoundMultiLineTerminalsEditStrategy strategy = new CompoundMultiLineTerminalsEditStrategy();
            this.injector.injectMembers((Object)strategy);
            return strategy.and(leftTerminal, indentationString, rightTerminal);
        }
    }
}

