/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hover;

import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.xtext.ui.XtextUIMessages;
import org.eclipse.xtext.ui.editor.hover.AbstractProblemHover;
import org.eclipse.xtext.ui.editor.quickfix.QuickAssistInvocationContext;
import org.eclipse.xtext.ui.editor.quickfix.XtextQuickAssistProcessor;

public class AnnotationWithQuickFixesHover
extends AbstractProblemHover {
    @Inject
    private XtextQuickAssistProcessor quickAssistProcessor;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;
    private volatile AnnotationInfo recentAnnotationInfo;

    protected Region getHoverRegionInternal(int lineNumber, int offset) {
        this.recentAnnotationInfo = null;
        List<Annotation> annotations = this.getAnnotations(lineNumber, offset);
        for (Annotation annotation : this.sortBySeverity(annotations)) {
            Position position = this.sourceViewer.getAnnotationModel().getPosition(annotation);
            if (position == null) continue;
            int start = position.getOffset();
            return new Region(start, position.getLength());
        }
        return null;
    }

    @Override
    protected Object getHoverInfoInternal(ITextViewer textViewer, int lineNumber, int offset) {
        AnnotationInfo result = this.recentAnnotationInfo;
        if (result != null) {
            return result;
        }
        List<Annotation> annotations = this.getAnnotations(lineNumber, offset);
        for (Annotation annotation : this.sortBySeverity(annotations)) {
            Position position = this.getAnnotationModel().getPosition(annotation);
            if (annotation.getText() == null || position == null) continue;
            QuickAssistInvocationContext invocationContext = new QuickAssistInvocationContext(this.sourceViewer, position.getOffset(), position.getLength(), true);
            CompletionProposalRunnable runnable = new CompletionProposalRunnable((IQuickAssistInvocationContext)invocationContext);
            Display.getDefault().syncExec((Runnable)runnable);
            if (invocationContext.isMarkedCancelled()) {
                return null;
            }
            this.recentAnnotationInfo = result = new AnnotationInfo(annotation, position, (ITextViewer)this.sourceViewer, runnable.proposals);
            return result;
        }
        return null;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.fHoverControlCreator;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    public static class AnnotationInfo {
        public final Annotation annotation;
        public final Position position;
        public final ITextViewer viewer;
        public final ICompletionProposal[] proposals;

        public AnnotationInfo(Annotation annotation, Position position, ITextViewer textViewer, ICompletionProposal[] proposals) {
            this.annotation = annotation;
            this.position = position;
            this.viewer = textViewer;
            Assert.isNotNull((Object)proposals);
            this.proposals = proposals;
        }

        public ICompletionProposal[] getCompletionProposals() {
            return this.proposals;
        }

        public void fillToolBar(ToolBarManager manager, IInformationControl infoControl) {
        }
    }

    private static class AnnotationInformationControl
    extends AbstractInformationControl
    implements IInformationControlExtension2 {
        private final DefaultMarkerAnnotationAccess fMarkerAnnotationAccess = new DefaultMarkerAnnotationAccess();
        private Control fFocusControl;
        private AnnotationInfo fInput;
        private Composite fParent;

        public AnnotationInformationControl(Shell parentShell, String statusFieldText) {
            super(parentShell, statusFieldText);
            this.create();
        }

        public AnnotationInformationControl(Shell parentShell, ToolBarManager toolBarManager) {
            super(parentShell, toolBarManager);
            this.create();
        }

        public AnnotationInformationControl(Shell parentShell, boolean resizeable) {
            super(parentShell, resizeable);
            this.create();
        }

        public void setInformation(String information) {
        }

        public void setInput(Object input) {
            Assert.isLegal((boolean)(input instanceof AnnotationInfo));
            this.fInput = (AnnotationInfo)input;
            this.disposeDeferredCreatedContent();
            this.deferredCreateContent();
        }

        public boolean hasContents() {
            return this.fInput != null;
        }

        private AnnotationInfo getAnnotationInfo() {
            return this.fInput;
        }

        public void setFocus() {
            super.setFocus();
            if (this.fFocusControl != null) {
                this.fFocusControl.setFocus();
            }
        }

        public final void setVisible(boolean visible) {
            if (!visible) {
                this.disposeDeferredCreatedContent();
            }
            super.setVisible(visible);
        }

        protected void disposeDeferredCreatedContent() {
            Control[] children = this.fParent.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
            ToolBarManager toolBarManager = this.getToolBarManager();
            if (toolBarManager != null) {
                toolBarManager.removeAll();
            }
        }

        protected void createContent(Composite parent) {
            this.fParent = parent;
            GridLayout layout = new GridLayout(1, false);
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.fParent.setLayout((Layout)layout);
        }

        public Point computeSizeHint() {
            Point preferedSize = this.getShell().computeSize(-1, -1, true);
            Point constrains = this.getSizeConstraints();
            if (constrains == null) {
                return preferedSize;
            }
            Point constrainedSize = this.getShell().computeSize(constrains.x, -1, true);
            int width = Math.min(preferedSize.x, constrainedSize.x);
            int height = Math.max(preferedSize.y, constrainedSize.y);
            return new Point(width, height);
        }

        protected void fillToolbar() {
            ToolBarManager toolBarManager = this.getToolBarManager();
            if (toolBarManager == null) {
                return;
            }
            this.fInput.fillToolBar(toolBarManager, (IInformationControl)this);
            toolBarManager.update(true);
        }

        protected void deferredCreateContent() {
            this.fillToolbar();
            this.createAnnotationInformation(this.fParent, this.getAnnotationInfo().annotation);
            this.setColorAndFont((Control)this.fParent, this.fParent.getForeground(), this.fParent.getBackground(), JFaceResources.getDialogFont());
            ICompletionProposal[] proposals = this.getAnnotationInfo().getCompletionProposals();
            if (proposals.length > 0) {
                this.createCompletionProposalsControl(this.fParent, proposals);
            }
            this.fParent.layout(true);
        }

        private void setColorAndFont(Control control, Color foreground, Color background, Font font) {
            control.setForeground(foreground);
            control.setBackground(background);
            control.setFont(font);
            if (control instanceof Composite) {
                Control[] children = ((Composite)control).getChildren();
                int i = 0;
                while (i < children.length) {
                    this.setColorAndFont(children[i], foreground, background, font);
                    ++i;
                }
            }
        }

        private void createAnnotationInformation(Composite parent, final Annotation annotation) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 2;
            layout.marginWidth = 2;
            layout.horizontalSpacing = 0;
            composite.setLayout((Layout)layout);
            final Canvas canvas = new Canvas(composite, 524288);
            GridData gridData = new GridData(1, 1, false, false);
            gridData.widthHint = 17;
            gridData.heightHint = 16;
            canvas.setLayoutData((Object)gridData);
            canvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.setFont(null);
                    fMarkerAnnotationAccess.paint(annotation, e.gc, canvas, new Rectangle(0, 0, 16, 16));
                }
            });
            StyledText text = new StyledText(composite, 74);
            GridData data = new GridData(4, 4, true, true);
            text.setLayoutData((Object)data);
            String annotationText = annotation.getText();
            if (annotationText != null) {
                text.setText(annotationText);
            }
        }

        private void createCompletionProposalsControl(Composite parent, ICompletionProposal[] proposals) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout2 = new GridLayout(1, false);
            layout2.marginHeight = 0;
            layout2.marginWidth = 0;
            layout2.verticalSpacing = 2;
            composite.setLayout((Layout)layout2);
            Label separator = new Label(composite, 258);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            separator.setLayoutData((Object)gridData);
            Label quickFixLabel = new Label(composite, 0);
            GridData layoutData = new GridData(1, 0x1000000, false, false);
            layoutData.horizontalIndent = 4;
            quickFixLabel.setLayoutData((Object)layoutData);
            String text = proposals.length == 1 ? XtextUIMessages.AnnotationWithQuickFixesHover_message_singleQuickFix : MessageFormat.format(XtextUIMessages.AnnotationWithQuickFixesHover_message_multipleQuickFix, String.valueOf(proposals.length));
            quickFixLabel.setText(text);
            this.setColorAndFont((Control)composite, parent.getForeground(), parent.getBackground(), JFaceResources.getDialogFont());
            this.createCompletionProposalsList(composite, proposals);
        }

        private void createCompletionProposalsList(Composite parent, ICompletionProposal[] proposals) {
            final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
            GridData gridData = new GridData(4, 4, true, true);
            scrolledComposite.setLayoutData((Object)gridData);
            scrolledComposite.setExpandVertical(false);
            scrolledComposite.setExpandHorizontal(false);
            Composite composite = new Composite((Composite)scrolledComposite, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout(2, false);
            layout.marginLeft = 5;
            layout.verticalSpacing = 2;
            composite.setLayout((Layout)layout);
            ArrayList<Link> list = new ArrayList<Link>();
            int i = 0;
            while (i < proposals.length) {
                list.add(this.createCompletionProposalLink(composite, proposals[i], 1));
                ++i;
            }
            final Link[] links = list.toArray(new Link[list.size()]);
            scrolledComposite.setContent((Control)composite);
            this.setColorAndFont((Control)scrolledComposite, parent.getForeground(), parent.getBackground(), JFaceResources.getDialogFont());
            Point contentSize = composite.computeSize(-1, -1);
            composite.setSize(contentSize);
            Point constraints = this.getSizeConstraints();
            if (constraints != null && contentSize.x < constraints.x) {
                int scrollBarHeight;
                ScrollBar horizontalBar = scrolledComposite.getHorizontalBar();
                if (horizontalBar == null) {
                    Point scrollSize = scrolledComposite.computeSize(-1, -1);
                    scrollBarHeight = scrollSize.y - contentSize.y;
                } else {
                    scrollBarHeight = horizontalBar.getSize().y;
                }
                gridData.heightHint = contentSize.y - scrollBarHeight;
            }
            this.fFocusControl = links[0];
            int i2 = 0;
            while (i2 < links.length) {
                final int index = i2++;
                final Link link = links[index];
                link.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                        switch (e.keyCode) {
                            case 0x1000002: {
                                if (index + 1 >= links.length) break;
                                links[index + 1].setFocus();
                                break;
                            }
                            case 0x1000001: {
                                if (index <= 0) break;
                                links[index - 1].setFocus();
                                break;
                            }
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                    }
                });
                link.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        int currentPosition = scrolledComposite.getOrigin().y;
                        int hight = scrolledComposite.getSize().y;
                        int linkPosition = link.getLocation().y;
                        if (linkPosition < currentPosition) {
                            if (linkPosition < 10) {
                                linkPosition = 0;
                            }
                            scrolledComposite.setOrigin(0, linkPosition);
                        } else if (linkPosition + 20 > currentPosition + hight) {
                            scrolledComposite.setOrigin(0, linkPosition - hight + link.getSize().y);
                        }
                    }

                    public void focusLost(FocusEvent e) {
                    }
                });
            }
        }

        private Link createCompletionProposalLink(Composite parent, final ICompletionProposal proposal, int count) {
            boolean isMultiFix;
            boolean bl = isMultiFix = count > 1;
            if (isMultiFix) {
                new Label(parent, 0);
                parent = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                parent.setLayout((Layout)layout);
            }
            Label proposalImage = new Label(parent, 0);
            proposalImage.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            Image image = proposal.getImage();
            if (image != null) {
                proposalImage.setImage(image);
                proposalImage.addMouseListener(new MouseListener(){

                    public void mouseDoubleClick(MouseEvent e) {
                    }

                    public void mouseDown(MouseEvent e) {
                    }

                    public void mouseUp(MouseEvent e) {
                        if (e.button == 1) {
                            this.apply(proposal, fInput.viewer, fInput.position.offset, isMultiFix);
                        }
                    }
                });
            }
            Link proposalLink = new Link(parent, 64);
            GridData layoutData = new GridData(1, 0x1000000, false, false);
            String linkText = isMultiFix ? MessageFormat.format(XtextUIMessages.AnnotationWithQuickFixesHover_message_multipleQuickFix, String.valueOf(count)) : proposal.getDisplayString();
            proposalLink.setText("<a>" + linkText + "</a>");
            proposalLink.setLayoutData((Object)layoutData);
            proposalLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.apply(proposal, fInput.viewer, fInput.position.offset, isMultiFix);
                }
            });
            return proposalLink;
        }

        private void apply(ICompletionProposal p, ITextViewer viewer, int offset, boolean isMultiFix) {
            this.dispose();
            IRewriteTarget target = null;
            try {
                ICompletionProposalExtension2 e;
                IDocument document = viewer.getDocument();
                if (viewer instanceof ITextViewerExtension) {
                    ITextViewerExtension extension = (ITextViewerExtension)viewer;
                    target = extension.getRewriteTarget();
                }
                if (target != null) {
                    target.beginCompoundChange();
                }
                if (p instanceof ICompletionProposalExtension2) {
                    e = (ICompletionProposalExtension2)p;
                    e.apply(viewer, '\u0000', isMultiFix ? 262144 : 0, offset);
                } else if (p instanceof ICompletionProposalExtension) {
                    e = (ICompletionProposalExtension)p;
                    e.apply(document, '\u0000', offset);
                } else {
                    p.apply(document);
                }
                Point selection = p.getSelection(document);
                if (selection != null) {
                    viewer.setSelectedRange(selection.x, selection.y);
                    viewer.revealRange(selection.x, selection.y);
                }
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
    }

    private final class CompletionProposalRunnable
    implements Runnable {
        private final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
        ICompletionProposal[] proposals = this.NO_PROPOSALS;
        IQuickAssistInvocationContext invocationContext;

        public CompletionProposalRunnable(IQuickAssistInvocationContext invocationContext) {
            this.invocationContext = invocationContext;
        }

        @Override
        public void run() {
            ICompletionProposal[] p = AnnotationWithQuickFixesHover.this.quickAssistProcessor.computeQuickAssistProposals(this.invocationContext);
            this.proposals = p != null ? p : this.NO_PROPOSALS;
        }
    }

    private static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fPresenterControlCreator;

        public HoverControlCreator(IInformationControlCreator presenterControlCreator) {
            this.fPresenterControlCreator = presenterControlCreator;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            return new AnnotationInformationControl(parent, EditorsUI.getTooltipAffordanceString()){

                public IInformationControlCreator getInformationPresenterControlCreator() {
                    return fPresenterControlCreator;
                }
            };
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                ((IInformationControlExtension4)control).setStatusText(EditorsUI.getTooltipAffordanceString());
            }
            return true;
        }
    }

    private static final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        private PresenterControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            return new AnnotationInformationControl(parent, true);
        }
    }
}

