/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.common.collect.FluentIterable;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.resource.persistence.ResourceStorageWritable;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.jvmmodel.JvmIdentifiableMetaData;
import org.eclipse.xtext.xbase.jvmmodel.JvmModelAssociator;
import org.eclipse.xtext.xbase.resource.BatchLinkableResource;
import org.eclipse.xtext.xtype.XComputedTypeReference;

public class BatchLinkableResourceStorageWritable
extends ResourceStorageWritable {
    private static final Logger LOG = Logger.getLogger(BatchLinkableResourceStorageWritable.class);
    public static final String MISSING_FRAGMENT = "none";

    public BatchLinkableResourceStorageWritable(OutputStream out, boolean storeNodeModel) {
        super(out, storeNodeModel);
    }

    protected void writeEntries(StorageAwareResource resource, ZipOutputStream zipOut) throws IOException {
        super.writeEntries(resource, zipOut);
        if (resource instanceof BatchLinkableResource) {
            zipOut.putNextEntry(new ZipEntry("associations"));
            BufferedOutputStream buffOut = new BufferedOutputStream(zipOut);
            try {
                this.writeAssociationsAdapter((BatchLinkableResource)resource, buffOut);
            }
            finally {
                buffOut.flush();
                zipOut.closeEntry();
            }
        }
    }

    protected void beforeSaveEObject(InternalEObject object, BinaryResourceImpl.EObjectOutputStream writable) throws IOException {
        super.beforeSaveEObject(object, writable);
        if (object instanceof XComputedTypeReference) {
            ((XComputedTypeReference)object).getType();
        }
    }

    protected void handleSaveEObject(InternalEObject object, BinaryResourceImpl.EObjectOutputStream out) throws IOException {
        super.handleSaveEObject(object, out);
        DocumentationAdapter documentationAdapter = null;
        JvmIdentifiableMetaData metaDataAdapter = null;
        for (Adapter adapter : object.eAdapters()) {
            if (adapter instanceof DocumentationAdapter) {
                documentationAdapter = (DocumentationAdapter)adapter;
            }
            if (!(adapter instanceof JvmIdentifiableMetaData)) continue;
            metaDataAdapter = (JvmIdentifiableMetaData)adapter;
        }
        if (documentationAdapter != null) {
            out.writeBoolean(true);
            out.writeString(documentationAdapter.getDocumentation());
        } else {
            out.writeBoolean(false);
        }
        if (metaDataAdapter != null) {
            out.writeBoolean(true);
            out.writeBoolean(metaDataAdapter.isSynthetic());
        } else {
            out.writeBoolean(false);
        }
    }

    protected void writeAssociationsAdapter(BatchLinkableResource resource, OutputStream zipOut) throws IOException {
        JvmModelAssociator.Adapter adapter = (JvmModelAssociator.Adapter)EcoreUtil.getExistingAdapter((Notifier)resource, JvmModelAssociator.Adapter.class);
        if (adapter == null) {
            int i = 1;
            int max = resource.getContents().size();
            while (i < max) {
                if (resource.getContents().get(i) instanceof JvmType) {
                    throw new IOException("Missing JvmModelAssociator.Adapter but resource contains inferred types: " + resource.getURI());
                }
                ++i;
            }
            adapter = new JvmModelAssociator.Adapter();
        }
        Throwable throwable = null;
        Object var5_8 = null;
        try (ObjectOutputStream objOut = new ObjectOutputStream(zipOut){

            @Override
            public void close() throws IOException {
                this.flush();
            }
        };){
            LinkedHashMap logicalMap = new LinkedHashMap();
            adapter.logicalContainerMap.forEach((key, value) -> {
                this.logIfResourceMismatch(resource, (EObject)key);
                String keyFragment = this.getFragment((EObject)key);
                if (!MISSING_FRAGMENT.equals(keyFragment)) {
                    logicalMap.put(keyFragment, this.getFragment((EObject)value));
                }
            });
            objOut.writeObject(logicalMap);
            this.writeAssociationMap(adapter.sourceToTargetMap, resource, objOut);
            this.writeAssociationMap(adapter.targetToSourceMap, resource, objOut);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeAssociationMap(Map<EObject, Set<EObject>> serializeMe, BatchLinkableResource resource, ObjectOutputStream objOut) throws IOException {
        LinkedHashMap fragmentMap = new LinkedHashMap();
        serializeMe.forEach((keyObject, valueObjects) -> {
            this.logIfResourceMismatch(resource, (EObject)keyObject);
            String keyFragment = this.getFragment((EObject)keyObject);
            if (!MISSING_FRAGMENT.equals(keyFragment)) {
                fragmentMap.put(keyFragment, this.objectsToFragments((Set<EObject>)valueObjects));
            }
        });
        objOut.writeObject(fragmentMap);
    }

    private void logIfResourceMismatch(BatchLinkableResource resource, EObject object) {
        Resource keyResource = object.eResource();
        if (resource != keyResource) {
            LOG.info((Object)("object (" + object + ") not from resource " + resource.getURI() + " but from " + (keyResource == null ? null : keyResource.getURI())));
        }
    }

    private Set<String> objectsToFragments(Set<EObject> objects) {
        return (Set)FluentIterable.from(objects).transform(this::getFragment).copyInto(new LinkedHashSet());
    }

    protected String getFragment(EObject obj) {
        if (obj == null || obj.eIsProxy()) {
            return MISSING_FRAGMENT;
        }
        if (obj.eResource() == null) {
            LOG.error((Object)("Object (" + obj + ") is not contained in any resource"));
            return MISSING_FRAGMENT;
        }
        return obj.eResource().getURIFragment(obj);
    }
}

