/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xbase.compiler.JavaSource;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Deprecated(forRemoval=true)
public class InMemoryJavaCompiler {
    private final INameEnvironment nameEnv;
    private final ClassLoader parentClassLoader;
    private final CompilerOptions compilerOptions;

    public InMemoryJavaCompiler(ClassLoader parent, JavaVersion javaVersion) {
        this.nameEnv = new ClassLoaderBasedNameEnvironment(parent);
        this.parentClassLoader = parent;
        this.compilerOptions = new CompilerOptions();
        this.setSourceLevel(this.toClassFmt(javaVersion));
        this.setComplianceLevel(this.toClassFmt(javaVersion));
        this.compilerOptions.targetJDK = this.toClassFmt(javaVersion);
        this.compilerOptions.inlineJsrBytecode = true;
        this.compilerOptions.preserveAllLocalVariables = true;
    }

    public InMemoryJavaCompiler(ClassLoader parent, CompilerOptions compilerOptions) {
        this.nameEnv = new ClassLoaderBasedNameEnvironment(parent);
        this.parentClassLoader = parent;
        this.compilerOptions = new CompilerOptions(compilerOptions.getMap());
    }

    private long toClassFmt(JavaVersion version) {
        return version.toJdtClassFileConstant();
    }

    private void setSourceLevel(long jdkVersion) {
        this.compilerOptions.sourceLevel = jdkVersion;
        this.compilerOptions.originalSourceLevel = jdkVersion;
    }

    private void setComplianceLevel(long jdkVersion) {
        this.compilerOptions.complianceLevel = jdkVersion;
        this.compilerOptions.originalComplianceLevel = jdkVersion;
    }

    public Result compile(JavaSource ... sources) {
        final Result result = new Result(this.parentClassLoader);
        ICompilerRequestor requestor = it -> {
            ClassFile[] classFileArray = it.getClassFiles();
            int n = classFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassFile cf = classFileArray[n2];
                result.classMap.put(CharOperation.toString((char[][])cf.getCompoundName()), cf.getBytes());
                ++n2;
            }
        };
        Compiler compiler = new Compiler(this.nameEnv, DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.compilerOptions, requestor, (IProblemFactory)new DefaultProblemFactory(){

            public CategorizedProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, int elaborationId, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber, int columnNumber) {
                CategorizedProblem problem = super.createProblem(originatingFileName, problemId, problemArguments, elaborationId, messageArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
                result.compilationProblems.add(problem);
                return problem;
            }

            public CategorizedProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber, int columnNumber) {
                CategorizedProblem problem = super.createProblem(originatingFileName, problemId, problemArguments, messageArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
                result.compilationProblems.add(problem);
                return problem;
            }
        });
        ICompilationUnit[] units = (ICompilationUnit[])Conversions.unwrapArray((Object)ListExtensions.map(Arrays.asList(sources), it -> new CompilationUnit(it.getCode().toCharArray(), it.getFileName(), null)), ICompilationUnit.class);
        compiler.compile(units);
        return result;
    }

    static class ByteClassLoader
    extends ClassLoader {
        private Map<String, byte[]> classMap;

        public ByteClassLoader(Map<String, byte[]> classMap, ClassLoader parent) {
            super(parent);
            this.classMap = classMap;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] bytes = this.classMap.get(name);
            if (bytes == null) {
                return super.findClass(name);
            }
            return this.defineClass(name, bytes, 0, bytes.length);
        }

        @Override
        protected URL findResource(String path) {
            try {
                String className;
                byte[] bytes;
                if (path.endsWith(".class") && (bytes = this.classMap.get(className = path.substring(0, path.length() - 6).replace("/", "."))) != null) {
                    return new URL("in-memory", null, -1, path, new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL it) throws IOException {
                            return new URLConnection(it){

                                @Override
                                public void connect() {
                                }

                                @Override
                                public InputStream getInputStream() {
                                    return new ByteArrayInputStream(bytes);
                                }
                            };
                        }
                    });
                }
                return null;
            }
            catch (IOException e) {
                throw Exceptions.sneakyThrow((Throwable)e);
            }
        }
    }

    private static class ClassLoaderBasedNameEnvironment
    implements INameEnvironment {
        private final ClassLoader classLoader;
        private Map<String, NameEnvironmentAnswer> cache = new HashMap<String, NameEnvironmentAnswer>();

        public void cleanup() {
            this.cache.clear();
        }

        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            URL url;
            String fileName;
            block4: {
                fileName = new String(CharOperation.concatWith((char[][])compoundTypeName, (char)'/')) + ".class";
                if (this.cache.containsKey(fileName)) {
                    return this.cache.get(fileName);
                }
                url = this.classLoader.getResource(fileName);
                if (url != null) break block4;
                this.cache.put(fileName, null);
                return null;
            }
            try {
                ClassFileReader reader = ClassFileReader.read((InputStream)url.openStream(), (String)fileName);
                NameEnvironmentAnswer result = new NameEnvironmentAnswer((IBinaryType)reader, null);
                this.cache.put(fileName, result);
                return result;
            }
            catch (IOException | ClassFormatException e) {
                throw Exceptions.sneakyThrow((Throwable)e);
            }
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            URL url;
            String fileName;
            block4: {
                fileName = new String(CharOperation.concatWith((char[][])packageName, (char)'/')) + "/" + String.valueOf(typeName) + ".class";
                if (this.cache.containsKey(fileName)) {
                    return this.cache.get(fileName);
                }
                url = this.classLoader.getResource(fileName);
                if (url != null) break block4;
                this.cache.put(fileName, null);
                return null;
            }
            try {
                ClassFileReader reader = ClassFileReader.read((InputStream)url.openStream(), (String)fileName);
                NameEnvironmentAnswer result = new NameEnvironmentAnswer((IBinaryType)reader, null);
                this.cache.put(fileName, result);
                return result;
            }
            catch (IOException | ClassFormatException e) {
                throw Exceptions.sneakyThrow((Throwable)e);
            }
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            return Character.isLowerCase(packageName[0]);
        }

        public ClassLoaderBasedNameEnvironment(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }
    }

    public static class Result {
        private final Set<CategorizedProblem> compilationProblems = new LinkedHashSet<CategorizedProblem>();
        private final HashMap<String, byte[]> classMap = new HashMap();
        private final ClassLoader parentClassLoader;

        public ClassLoader getClassLoader() {
            return new ByteClassLoader(this.classMap, this.parentClassLoader);
        }

        public Result(ClassLoader parentClassLoader) {
            this.parentClassLoader = parentClassLoader;
        }

        public Set<CategorizedProblem> getCompilationProblems() {
            return this.compilationProblems;
        }
    }
}

