/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring2;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.MoveResourceChange;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.serializer.IEmfResourceChange;
import org.eclipse.xtext.ide.serializer.ITextDocumentChange;
import org.eclipse.xtext.ui.refactoring.impl.EditorDocumentChange;
import org.eclipse.xtext.ui.refactoring2.ReplaceFileContentChange;
import org.eclipse.xtext.ui.refactoring2.ResourceURIConverter;
import org.eclipse.xtext.ui.util.DisplayRunnableWithResult;
import org.eclipse.xtext.util.Exceptions;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.internal.Nullable;

public class ChangeConverter
implements IAcceptor<IEmfResourceChange> {
    private static final Logger LOG = Logger.getLogger(ChangeConverter.class);
    private final CompositeChange currentChange;
    private final RefactoringIssueAcceptor issues;
    private final Predicate<Change> changeFilter;
    private final ResourceURIConverter resourceUriConverter;
    private final IWorkbench workbench;

    protected ChangeConverter(String name, Predicate<Change> changeFilter, RefactoringIssueAcceptor issues, ResourceURIConverter uriConverter, IWorkbench workbench) {
        this.currentChange = new CompositeChange(name);
        this.issues = issues;
        this.changeFilter = changeFilter;
        this.resourceUriConverter = uriConverter;
        this.workbench = workbench;
    }

    public void accept(IEmfResourceChange emfResourceChange) {
        this.doConvert(emfResourceChange);
    }

    public Change getChange() {
        if (this.currentChange.getChildren().length == 0) {
            return null;
        }
        return this.currentChange;
    }

    protected void doConvert(IEmfResourceChange change) {
        this.handleReplacements(change);
        this.handleUriChange(change);
        if (this.affectsPersistedFiles()) {
            this.saveEditorsAfterApply();
        }
    }

    protected void handleReplacements(IEmfResourceChange change) {
        if (change instanceof ITextDocumentChange) {
            this._handleReplacements((ITextDocumentChange)change);
        } else if (change != null) {
            this._handleReplacements(change);
        } else {
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(change).toString());
        }
    }

    protected void _handleReplacements(IEmfResourceChange change) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                IFile file;
                ByteArrayOutputStream outputStream;
                block14: {
                    block15: {
                        outputStream = new ByteArrayOutputStream();
                        file = this.resourceUriConverter.toFile(change.getOldURI());
                        if (this.canWrite(file)) break block14;
                        this.issues.add(RefactoringIssueAcceptor.Severity.ERROR, "Affected file '" + String.valueOf(file.getFullPath()) + "' is read-only", new Object[0]);
                        if (outputStream == null) break block15;
                        outputStream.close();
                    }
                    return;
                }
                try {
                    try {
                        this.checkDerived(file);
                        change.getResource().save((OutputStream)outputStream, null);
                        byte[] newContent = outputStream.toByteArray();
                        String lastSegment = change.getOldURI().lastSegment();
                        ReplaceFileContentChange ltkChange = new ReplaceFileContentChange(lastSegment, file, newContent);
                        this.addChange((Change)ltkChange);
                    }
                    catch (IOException e) {
                        Exceptions.throwUncheckedException((Throwable)e);
                    }
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error closing stream", (Throwable)e);
        }
    }

    protected void _handleReplacements(ITextDocumentChange change) {
        if (!change.getReplacements().isEmpty()) {
            EditorDocumentChange ltkChange;
            IFile file = this.resourceUriConverter.toFile(change.getOldURI());
            if (!this.canWrite(file)) {
                this.issues.add(RefactoringIssueAcceptor.Severity.FATAL, "Affected file '" + String.valueOf(file.getFullPath()) + "' is read-only", new Object[0]);
            }
            this.checkDerived(file);
            List<TextEdit> textEdits = change.getReplacements().stream().map(replacement -> new ReplaceEdit(replacement.getOffset(), replacement.getLength(), replacement.getReplacementText())).collect(Collectors.toList());
            MultiTextEdit textEdit = new MultiTextEdit();
            textEdit.addChildren(textEdits.toArray(new TextEdit[textEdits.size()]));
            ITextEditor openEditor = this.findOpenEditor(file);
            if (openEditor == null) {
                TextFileChange textFileChange = new TextFileChange(change.getOldURI().lastSegment(), file);
                textFileChange.setSaveMode(2);
                ltkChange = textFileChange;
            } else {
                ltkChange = new EditorDocumentChange(this.currentChange.getName(), openEditor, false);
            }
            ltkChange.setEdit((TextEdit)textEdit);
            ltkChange.setTextType(change.getOldURI().fileExtension());
            this.addChange((Change)ltkChange);
        }
    }

    protected void handleUriChange(IEmfResourceChange change) {
        if (!Objects.equals(change.getNewURI(), change.getOldURI())) {
            if (Objects.equals(change.getNewURI().lastSegment(), change.getOldURI().lastSegment())) {
                IFile oldFile = this.resourceUriConverter.toFile(change.getOldURI());
                if (!this.canWrite(oldFile)) {
                    this.issues.add(RefactoringIssueAcceptor.Severity.FATAL, "Cannot move read-only file '" + String.valueOf(oldFile.getFullPath()) + "'", new Object[0]);
                }
                this.checkDerived(oldFile);
                IFile newFile = this.resourceUriConverter.toFile(change.getNewURI());
                IContainer newContainer = newFile.getParent();
                MoveResourceChange ltkChange = new MoveResourceChange((IResource)oldFile, newContainer);
                this.addChange((Change)ltkChange);
            } else if (Objects.equals(change.getNewURI().trimSegments(1), change.getOldURI().trimSegments(1))) {
                RenameResourceChange ltkChange = new RenameResourceChange(this.resourceUriConverter.toFile(change.getOldURI()).getFullPath(), change.getNewURI().lastSegment());
                this.addChange((Change)ltkChange);
            }
        }
    }

    protected void addChange(Change change) {
        if (this.changeFilter == null || this.changeFilter.apply((Object)change)) {
            this.currentChange.add(change);
        }
    }

    protected boolean canWrite(IFile file) {
        return file.getWorkspace().validateEdit(new IFile[]{file}, IWorkspace.VALIDATE_PROMPT).isOK();
    }

    protected void checkDerived(IFile file) {
        if (file.isDerived()) {
            this.issues.add(RefactoringIssueAcceptor.Severity.WARNING, "Affected file '" + String.valueOf(file.getFullPath()) + "' is derived", new Object[0]);
        }
    }

    protected ITextEditor findOpenEditor(final IFile file) {
        if (this.workbench == null) {
            return null;
        }
        return (ITextEditor)new DisplayRunnableWithResult<ITextEditor>(){

            @Override
            protected ITextEditor run() throws Exception {
                FileEditorInput editorInput = new FileEditorInput(file);
                IEditorPart editorPart = ChangeConverter.this.workbench.getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)editorInput);
                if (editorPart instanceof ITextEditor) {
                    return (ITextEditor)editorPart;
                }
                return null;
            }
        }.syncExec();
    }

    protected boolean affectsPersistedFiles() {
        return Arrays.asList(this.currentChange.getChildren()).stream().anyMatch(change -> !(change instanceof EditorDocumentChange));
    }

    protected void saveEditorsAfterApply() {
        Change[] changeArray = this.currentChange.getChildren();
        int n = changeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Change change = changeArray[n2];
            if (change instanceof EditorDocumentChange) {
                ((EditorDocumentChange)change).setDoSave(true);
            }
            ++n2;
        }
    }

    public static class Factory {
        @Inject
        private ResourceURIConverter resourceURIConverter;
        @Inject(optional=true)
        @Nullable
        private IWorkbench workbench;

        public ChangeConverter create(String name, Predicate<Change> changeFilter, RefactoringIssueAcceptor issues) {
            return new ChangeConverter(name, changeFilter, issues, this.resourceURIConverter, this.workbench);
        }
    }
}

