/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.internal.ArrayListTextSegmentSet;
import org.eclipse.xtext.formatting2.internal.ConflictingRegionsException;
import org.eclipse.xtext.formatting2.internal.RegionsOutsideFrameException;
import org.eclipse.xtext.formatting2.internal.TextReplacementList;
import org.eclipse.xtext.formatting2.internal.TextSegmentSet;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Tuples;

public class TextReplacerContext
implements ITextReplacerContext {
    private boolean autowrap = false;
    private Integer canAutowrap = null;
    private final IFormattableDocument document;
    private final int indentation;
    private boolean nextReplacerIsChild = false;
    private final ITextReplacerContext previous;
    private TextSegmentSet<ITextReplacement> replacements = null;
    private final ITextReplacer replacer;

    public TextReplacerContext(IFormattableDocument document) {
        this(document, null, 0, null);
    }

    protected TextReplacerContext(IFormattableDocument document, ITextReplacerContext previous, int indentation, ITextReplacer replacer) {
        this.document = document;
        this.indentation = indentation;
        this.previous = previous;
        this.replacer = replacer;
        this.replacements = this.createTextReplacementsSet();
    }

    @Override
    public Integer canAutowrap() {
        return this.canAutowrap;
    }

    protected TextSegmentSet<ITextReplacement> createTextReplacementsSet() {
        return new ArrayListTextSegmentSet<ITextReplacement>(Functions.identity(), new Function<ITextReplacement, String>(){

            public String apply(ITextReplacement input) {
                return input.getReplacementText();
            }
        }, this.getDocument().getRequest().isEnableDebugTracing());
    }

    @Override
    public IFormattableDocument getDocument() {
        return this.document;
    }

    @Override
    public AbstractFormatter2 getFormatter() {
        return this.document.getFormatter();
    }

    @Override
    public int getIndentation() {
        return this.indentation;
    }

    @Override
    public String getIndentationString() {
        return this.getIndentationString(this.getIndentation());
    }

    @Override
    public String getIndentationString(int indentationLevel) {
        AbstractFormatter2 formatter = this.document.getFormatter();
        return Strings.repeat((String)formatter.getPreference(FormatterPreferenceKeys.indentation), (int)indentationLevel);
    }

    @Override
    public int getLeadingCharsInLineCount() {
        ITextRegionAccess access = this.getDocument().getRequest().getTextRegionAccess();
        int lastOffset = this.replacer.getRegion().getOffset();
        ITextReplacerContext current = this;
        int count = 0;
        while (current != null) {
            for (ITextReplacement rep : current.getLocalReplacementsReverse()) {
                int endOffset = rep.getEndOffset();
                if (endOffset > lastOffset) continue;
                String between = access.textForOffset(endOffset, lastOffset - endOffset);
                int idx = between.lastIndexOf(10);
                if (idx >= 0) {
                    return count + this.logicalLength(between.substring(idx + 1));
                }
                count += this.logicalLength(between);
                String text = rep.getReplacementText();
                int idx2 = text.lastIndexOf(10);
                if (idx2 >= 0) {
                    return count + this.logicalLength(text.substring(idx2 + 1));
                }
                count += this.logicalLength(text);
                lastOffset = rep.getOffset();
            }
            current = current.getPreviousContext();
        }
        String rest = access.textForOffset(0, lastOffset);
        int idx = rest.lastIndexOf(10);
        if (idx >= 0) {
            return count + this.logicalLength(rest.substring(idx + 1));
        }
        return count += lastOffset;
    }

    @Override
    public Iterable<ITextReplacement> getLocalReplacements() {
        if (this.replacements != null) {
            return this.replacements;
        }
        return Collections.emptyList();
    }

    @Override
    public Iterable<ITextReplacement> getLocalReplacementsReverse() {
        if (this.replacements != null) {
            return this.replacements.reverseIterable();
        }
        return Collections.emptyList();
    }

    @Override
    public String getNewLinesString(int count) {
        return Strings.repeat((String)this.document.getFormatter().getPreference(FormatterPreferenceKeys.lineSeparator), (int)count);
    }

    @Override
    public ITextReplacerContext getPreviousContext() {
        return this.previous;
    }

    @Override
    public List<ITextReplacement> getReplacementsUntil(ITextReplacerContext first) {
        ITextReplacerContext current = this;
        ArrayList reversedReplacements = Lists.newArrayList();
        while (current != null) {
            Iterable<ITextReplacement> localReplacements = current.getLocalReplacements();
            if (!Iterables.isEmpty(localReplacements)) {
                reversedReplacements.add(localReplacements);
            }
            if (current == first) break;
            current = current.getPreviousContext();
        }
        Collections.reverse(reversedReplacements);
        TextReplacementList<ITextReplacement> flattenedReplacements = new TextReplacementList<ITextReplacement>();
        for (Iterable chunk : reversedReplacements) {
            Iterables.addAll(flattenedReplacements, (Iterable)chunk);
        }
        return flattenedReplacements;
    }

    @Override
    public ITextReplacer getReplacer() {
        return this.replacer;
    }

    @Override
    public boolean isAutowrap() {
        return this.autowrap;
    }

    protected boolean isInRequestedRange(ITextReplacement repl) {
        Collection<ITextRegion> regions = this.document.getRequest().getRegions();
        if (regions.isEmpty()) {
            return true;
        }
        for (ITextRegion region : regions) {
            if (region.getOffset() > repl.getOffset() || region.getOffset() + region.getLength() < repl.getEndOffset()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInsideFormattedRegion() {
        return true;
    }

    protected int logicalLength(String text) {
        ITypedPreferenceValues preferences = this.getDocument().getRequest().getPreferences();
        String indentation = preferences.getPreference(FormatterPreferenceKeys.indentation);
        if (!"\t".equals(indentation)) {
            return text.length();
        }
        int tabWidth = preferences.getPreference(FormatterPreferenceKeys.indentationLength);
        if (tabWidth < 0) {
            tabWidth = preferences.getPreference(FormatterPreferenceKeys.tabWidth);
        }
        int length = 0;
        int i = 0;
        while (i < text.length()) {
            length = text.charAt(i) == '\t' ? (length += tabWidth) : ++length;
            ++i;
        }
        return length;
    }

    @Override
    public void addReplacement(ITextReplacement replacement) {
        Preconditions.checkNotNull((Object)this.replacer);
        ITextSegment replacerRegion = this.replacer.getRegion();
        FormatterRequest request = this.document.getRequest();
        if (!replacerRegion.contains(replacement)) {
            String frameTitle = this.replacer.getClass().getSimpleName();
            ITextSegment frameRegion = this.replacer.getRegion();
            String replacerTitle = replacement.getReplacementText();
            RegionsOutsideFrameException exception = new RegionsOutsideFrameException(frameTitle, frameRegion, Tuples.create((Object)replacerTitle, (Object)replacement));
            request.getExceptionHandler().accept((Object)exception);
            return;
        }
        if (!this.isInRequestedRange(replacement)) {
            return;
        }
        if (!this.isInUndefinedRegion(replacement)) {
            if (request.isFormatUndefinedHiddenRegionsOnly()) {
                return;
            }
            if (!request.allowIdentityEdits() && this.isIdentityEdit(replacement)) {
                return;
            }
        }
        try {
            this.replacements.add(replacement);
        }
        catch (ConflictingRegionsException e) {
            request.getExceptionHandler().accept((Object)e);
        }
    }

    protected boolean isInUndefinedRegion(ITextReplacement repl) {
        ITextSegment replacerRegion = this.replacer.getRegion();
        IHiddenRegion hidden = null;
        if (replacerRegion instanceof IHiddenRegionPart) {
            hidden = ((IHiddenRegionPart)replacerRegion).getHiddenRegion();
        } else if (replacerRegion instanceof IHiddenRegion) {
            hidden = (IHiddenRegion)replacerRegion;
        }
        return hidden == null || hidden.isUndefined();
    }

    protected boolean isIdentityEdit(ITextReplacement replacement) {
        return replacement.getText().equals(replacement.getReplacementText());
    }

    @Override
    public void setAutowrap(boolean value) {
        this.autowrap = value;
        this.replacements = this.createTextReplacementsSet();
    }

    @Override
    public void setCanAutowrap(Integer value) {
        this.canAutowrap = value;
    }

    @Override
    public void setNextReplacerIsChild() {
        this.nextReplacerIsChild = true;
    }

    public String toString() {
        TextReplacerContext current = this;
        ArrayList lines = Lists.newArrayList();
        int i = 0;
        while (current != null) {
            if (i > 15) {
                lines.add("(...)");
                break;
            }
            lines.add(current.toStringLocal());
            current = (TextReplacerContext)current.getPreviousContext();
            ++i;
        }
        return Joiner.on((char)'\n').join((Iterable)Lists.reverse((List)lines));
    }

    protected String toStringLocal() {
        ArrayList items = Lists.newArrayList();
        if (this.autowrap) {
            items.add("autowrap");
        }
        if (this.canAutowrap != null && this.canAutowrap >= 0) {
            items.add("canAutowrap");
        }
        if (this.replacer != null) {
            ITextSegment region = this.replacer.getRegion();
            items.add(String.format("replacer=[%d-%d-%s|%s]", region.getOffset(), region.getLength(), this.replacer.getClass().getSimpleName(), this.replacer.toString()));
        }
        if (this.replacements != null) {
            for (ITextReplacement r : this.replacements) {
                String fmt = "replacement=[%d-%d|%s]";
                items.add(String.format(fmt, r.getOffset(), r.getLength(), r.getReplacementText()));
            }
        }
        return Joiner.on((String)"; ").join((Iterable)items);
    }

    @Override
    public ITextReplacerContext withDocument(IFormattableDocument document) {
        TextReplacerContext context = new TextReplacerContext(document, this, this.indentation, null);
        if (this.nextReplacerIsChild) {
            context.setNextReplacerIsChild();
        }
        return context;
    }

    @Override
    public ITextReplacerContext withIndentation(int indentation) {
        return new TextReplacerContext(this.document, this, indentation, null);
    }

    @Override
    public ITextReplacerContext withReplacer(ITextReplacer replacer) {
        ITextReplacerContext current = this;
        while (current != null) {
            ITextReplacer lastReplacer = current.getReplacer();
            if (lastReplacer != null) {
                if (this.nextReplacerIsChild) {
                    Preconditions.checkArgument((boolean)lastReplacer.getRegion().contains(replacer.getRegion()));
                    break;
                }
                Preconditions.checkArgument((lastReplacer.getRegion().getEndOffset() <= replacer.getRegion().getOffset() ? 1 : 0) != 0);
                break;
            }
            current = current.getPreviousContext();
        }
        return new TextReplacerContext(this.document, this, this.indentation, replacer);
    }

    protected ITextSegment getRegion(int index) {
        ITextReplacerContext current = this;
        while (current != null) {
            ITextReplacer replacer2 = current.getReplacer();
            if (replacer2 != null) {
                if (index == 0) {
                    return replacer2.getRegion();
                }
                --index;
            }
            current = current.getPreviousContext();
        }
        return null;
    }

    @Override
    public boolean isWrapInRegion() {
        ITextRegionAccess access = this.getDocument().getRequest().getTextRegionAccess();
        ITextSegment region = this.getReplacer().getRegion();
        int lastOffset = region.getOffset();
        for (ITextReplacement rep : this.getLocalReplacements()) {
            int endOffset = rep.getOffset();
            String between = access.textForOffset(lastOffset, endOffset - lastOffset);
            if (between.contains("\n") || rep.getReplacementText().contains("\n")) {
                return true;
            }
            lastOffset = rep.getEndOffset();
        }
        String rest = access.textForOffset(lastOffset, region.getEndOffset() - lastOffset);
        return rest.contains("\n");
    }

    @Override
    public boolean isWrapSincePrevious() {
        int offset;
        String between;
        ITextRegionAccess access = this.getDocument().getRequest().getTextRegionAccess();
        ITextSegment region = this.getRegion(0);
        ITextSegment previousRegion = this.getRegion(1);
        return previousRegion != null && (between = access.textForOffset(offset = previousRegion.getEndOffset(), region.getOffset() - offset)).contains("\n");
    }
}

