/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.testing;

import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.junit.rules.ExternalResource;

@Singleton
public class TemporaryFolder
extends ExternalResource {
    private File folder;
    private boolean initialized = false;

    protected void before() throws Throwable {
        this.initialized = true;
    }

    protected void after() {
        if (this.folder != null) {
            this.delete();
            this.folder = null;
            this.initialized = false;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void create() throws IOException {
        this.folder = Files.createTempDirectory("junit", new FileAttribute[0]).toFile();
    }

    public File newFile(String fileName) throws IOException {
        File file = new File(this.getRoot(), fileName);
        file.createNewFile();
        return file;
    }

    public File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, this.getRoot());
    }

    public File newFile() throws IOException {
        return File.createTempFile("junit", null, this.getRoot());
    }

    public File newFolder(String ... folderNames) {
        File file = this.getRoot();
        String[] stringArray = folderNames;
        int n = folderNames.length;
        int n2 = 0;
        while (n2 < n) {
            String folderName = stringArray[n2];
            file = new File(file, folderName);
            file.mkdir();
            ++n2;
        }
        return file;
    }

    public File newFolder() throws IOException {
        try {
            File tempDir = this.createTempDir(this.getRoot());
            this.addSourceInfo(tempDir);
            return tempDir;
        }
        catch (IllegalStateException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected void addSourceInfo(File tempDir) throws IOException {
        try (PrintStream printStream = new PrintStream(new File(tempDir, ".createdBy"));){
            printStream.append("This temp dir has been created from the stack below. If you want to make sure the temp folders are cleaned up after a test executed, you should add the following to your test class: \n\n");
            printStream.append("     @Rule @Inject public TemporaryFolder temporaryFolder \n\n");
            new Exception().printStackTrace(printStream);
        }
    }

    private File createTempDir(File baseDir) {
        String baseName = System.currentTimeMillis() + "-";
        int counter = 0;
        while (counter < 10000) {
            File tempDir = new File(baseDir, baseName + counter);
            if (tempDir.mkdir()) {
                return tempDir;
            }
            ++counter;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + "9999)");
    }

    public File getRoot() {
        if (this.folder == null) {
            try {
                this.create();
            }
            catch (IOException e) {
                throw new IllegalStateException("the temporary folder could not be created", e);
            }
        }
        return this.folder;
    }

    public void delete() {
        this.recursiveDelete(this.folder);
    }

    private void recursiveDelete(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File each = fileArray[n2];
                this.recursiveDelete(each);
                ++n2;
            }
        }
        file.delete();
    }
}

