/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.generator;

import com.google.inject.Singleton;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IShouldGenerate;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ProjectConfigAdapter;

@Singleton
public class EclipseBasedShouldGenerate
implements IShouldGenerate {
    private static final Logger LOG = Logger.getLogger(EclipseBasedShouldGenerate.class);

    public boolean shouldGenerate(Resource resource, CancelIndicator cancelIndicator) {
        IProjectConfig projectConfig;
        ProjectConfigAdapter projectConfigAdapter;
        URI uri = resource.getURI();
        if (uri == null || !uri.isPlatformResource()) {
            return false;
        }
        IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(uri.toPlatformString(true)));
        if (member != null && member.getType() == 1 && (projectConfigAdapter = ProjectConfigAdapter.findInEmfObject((Notifier)resource.getResourceSet())) != null && (projectConfig = projectConfigAdapter.getProjectConfig()) != null && Objects.equals(member.getProject().getName(), projectConfig.getName())) {
            try {
                return member.findMaxProblemSeverity(null, true, 2) != 2;
            }
            catch (CoreException e) {
                LOG.error((Object)("The resource " + member.getName() + " does not exist"), (Throwable)e);
                return false;
            }
        }
        return false;
    }
}

