/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.util.XtextSwitch;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xtext.UsedRulesFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarWithoutLeftRecursionInspector
extends XtextSwitch<Boolean>
implements ValidationMessageAcceptor {
    private final ValidationMessageAcceptor validationMessageAcceptor;
    private final Set<AbstractRule> validatedRules;
    private final Set<AbstractRule> usedRules;
    private final List<RuleCall> callStack;
    private final Set<AbstractRule> ruleStack;
    private Grammar inspectedGrammar;
    private final Set<EObject> erroneousElements;

    public GrammarWithoutLeftRecursionInspector(ValidationMessageAcceptor validationMessageAcceptor) {
        this.validationMessageAcceptor = validationMessageAcceptor;
        this.validatedRules = Sets.newHashSet();
        this.callStack = Lists.newArrayList();
        this.ruleStack = Sets.newHashSet();
        this.usedRules = Sets.newHashSet();
        this.erroneousElements = Sets.newHashSet();
    }

    public void inspect(Grammar grammar) {
        this.doSwitch(grammar);
    }

    @Override
    public Boolean caseGrammar(Grammar grammar) {
        UsedRulesFinder usedRulesFinder = new UsedRulesFinder(this.usedRules);
        usedRulesFinder.compute(grammar);
        this.inspectedGrammar = grammar;
        for (AbstractRule rule : grammar.getRules()) {
            if (this.validatedRules.contains(rule) || !this.usedRules.contains(rule)) continue;
            this.doSwitch(rule);
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean caseAbstractRule(AbstractRule object) {
        if (!this.validatedRules.add(object)) {
            return Boolean.FALSE;
        }
        this.ruleStack.add(object);
        Boolean result = object.getAlternatives() == null ? Boolean.FALSE : (Boolean)this.doSwitch(object.getAlternatives());
        this.ruleStack.remove(object);
        return result;
    }

    @Override
    public Boolean caseEnumLiteralDeclaration(EnumLiteralDeclaration object) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean caseRuleCall(RuleCall object) {
        if (object.getRule() == null) {
            return Boolean.FALSE;
        }
        if (this.ruleStack.contains(object.getRule())) {
            this.createErrorMessages(object);
            return GrammarUtil.isOptionalCardinality(object);
        }
        this.callStack.add(object);
        Boolean result = (Boolean)this.doSwitch(object.getRule());
        this.callStack.remove(this.callStack.size() - 1);
        if (!result.booleanValue()) {
            return GrammarUtil.isOptionalCardinality(object);
        }
        return result;
    }

    @Override
    public Boolean caseAbstractElement(AbstractElement object) {
        return GrammarUtil.isOptionalCardinality(object);
    }

    @Override
    public Boolean caseAction(Action object) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean caseGroup(Group object) {
        for (AbstractElement element : object.getElements()) {
            if (((Boolean)this.doSwitch(element)).booleanValue()) continue;
            return GrammarUtil.isOptionalCardinality(object);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean caseAlternatives(Alternatives object) {
        Boolean result = Boolean.FALSE;
        for (AbstractElement element : object.getElements()) {
            if (!((Boolean)this.doSwitch(element)).booleanValue()) continue;
            result = Boolean.TRUE;
        }
        if (!result.booleanValue() && !GrammarUtil.isOptionalCardinality(object)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean caseUnorderedGroup(UnorderedGroup object) {
        Boolean result = Boolean.TRUE;
        for (AbstractElement element : object.getElements()) {
            if (((Boolean)this.doSwitch(element)).booleanValue()) continue;
            result = Boolean.FALSE;
        }
        if (!result.booleanValue() && !GrammarUtil.isOptionalCardinality(object)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean caseAssignment(Assignment object) {
        Boolean result = (Boolean)this.doSwitch(object.getTerminal());
        if (!result.booleanValue() && !GrammarUtil.isOptionalCardinality(object)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean caseCrossReference(CrossReference object) {
        Boolean result = (Boolean)this.doSwitch(object.getTerminal());
        if (!result.booleanValue() && !GrammarUtil.isOptionalCardinality(object)) {
            return false;
        }
        return true;
    }

    public void createErrorMessages(RuleCall object) {
        this.acceptError("The rule '" + object.getRule().getName() + "' is left recursive.", (EObject)object.getRule(), (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME, null, new String[0]);
        this.acceptError("This rule call is part of a left recursive call graph.", (EObject)object, (EStructuralFeature)XtextPackage.Literals.RULE_CALL__RULE, null, new String[0]);
        int i = this.callStack.size() - 1;
        while (i >= 0) {
            RuleCall call = this.callStack.get(i);
            if (call.getRule() == object.getRule()) {
                return;
            }
            this.acceptError("This rule call is part of a left recursive call graph.", (EObject)call, (EStructuralFeature)XtextPackage.Literals.RULE_CALL__RULE, null, new String[0]);
            --i;
        }
    }

    public void acceptError(String message, EObject object, EStructuralFeature feature, String code, String ... issueData) {
        if (this.erroneousElements.add(object) && EcoreUtil.isAncestor((EObject)this.inspectedGrammar, (EObject)object)) {
            this.validationMessageAcceptor.acceptError(message, object, feature, -1, code, issueData);
        }
    }

    public void acceptWarning(String message, EObject object, EStructuralFeature feature, String code, String ... issueData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptError(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptError(String message, EObject object, int offset, int length, String code, String ... issueData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptWarning(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptWarning(String message, EObject object, int offset, int length, String code, String ... issueData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptInfo(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptInfo(String message, EObject object, int offset, int length, String code, String ... issueData) {
        throw new UnsupportedOperationException();
    }
}

