/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.folding;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldingRegionAcceptor;
import org.eclipse.xtext.ui.editor.folding.FoldedPosition;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionAcceptor;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.model.ITokenTypeToPartitionTypeMapperExtension;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.TerminalsTokenTypeToPartitionMapper;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFoldingRegionProvider
implements IFoldingRegionProvider {
    private static final Logger log = Logger.getLogger(DefaultFoldingRegionProvider.class);
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private ITokenTypeToPartitionTypeMapperExtension tokenTypeToPartitionTypeMapperExtension;
    protected static final Pattern TEXT_PATTERN_IN_COMMENT = Pattern.compile("\\w");

    @Deprecated
    public DefaultFoldingRegionProvider(ILocationInFileProvider locationInFileProvider) {
        this.locationInFileProvider = locationInFileProvider;
        this.tokenTypeToPartitionTypeMapperExtension = new TerminalsTokenTypeToPartitionMapper();
    }

    @Inject
    public DefaultFoldingRegionProvider() {
    }

    @Override
    public Collection<FoldedPosition> getFoldingRegions(final IXtextDocument xtextDocument) {
        return (Collection)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<Collection<FoldedPosition>, XtextResource>(){

            public Collection<FoldedPosition> exec(XtextResource xtextResource) throws Exception {
                if (xtextResource == null) {
                    return Collections.emptyList();
                }
                return DefaultFoldingRegionProvider.this.doGetFoldingRegions(xtextDocument, xtextResource);
            }
        });
    }

    protected Collection<FoldedPosition> doGetFoldingRegions(IXtextDocument xtextDocument, XtextResource xtextResource) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor = this.createAcceptor(xtextDocument, result);
        this.computeObjectFolding(xtextResource, foldingRegionAcceptor);
        this.computeCommentFolding(xtextDocument, foldingRegionAcceptor);
        return result;
    }

    protected IFoldingRegionAcceptor<ITextRegion> createAcceptor(IXtextDocument xtextDocument, Collection<FoldedPosition> foldedPositions) {
        return new DefaultFoldingRegionAcceptor(xtextDocument, foldedPositions);
    }

    protected void computeObjectFolding(XtextResource xtextResource, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor) {
        EObject rootASTElement;
        IParseResult parseResult = xtextResource.getParseResult();
        if (parseResult != null && (rootASTElement = parseResult.getRootASTElement()) != null) {
            TreeIterator allContents = rootASTElement.eAllContents();
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (this.isHandled(eObject)) {
                    this.computeObjectFolding(eObject, foldingRegionAcceptor);
                }
                if (this.shouldProcessContent(eObject)) continue;
                allContents.prune();
            }
        }
    }

    protected ILocationInFileProvider getLocationInFileProvider() {
        return this.locationInFileProvider;
    }

    protected void computeObjectFolding(EObject eObject, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor) {
        ITextRegion region = this.locationInFileProvider.getFullTextRegion(eObject);
        if (region != null) {
            ITextRegion significant = this.locationInFileProvider.getSignificantTextRegion(eObject);
            if (significant == null) {
                throw new NullPointerException("significant region may not be null");
            }
            int offset = region.getOffset();
            foldingRegionAcceptor.accept(offset, region.getLength(), significant);
        }
    }

    protected void computeCommentFolding(IXtextDocument xtextDocument, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor) {
        try {
            ITypedRegion[] typedRegions;
            ITypedRegion[] iTypedRegionArray = typedRegions = xtextDocument.computePartitioning("__dftl_partitioning", 0, xtextDocument.getLength(), false);
            int n = typedRegions.length;
            int n2 = 0;
            while (n2 < n) {
                ITypedRegion typedRegion = iTypedRegionArray[n2];
                if (this.tokenTypeToPartitionTypeMapperExtension.isMultiLineComment(typedRegion.getType())) {
                    int offset = typedRegion.getOffset();
                    int length = typedRegion.getLength();
                    Matcher matcher = this.getTextPatternInComment().matcher(xtextDocument.get(offset, length));
                    if (matcher.find()) {
                        TextRegion significant = new TextRegion(offset + matcher.start(), 0);
                        foldingRegionAcceptor.accept(offset, length, (ITextRegion)significant);
                    } else {
                        foldingRegionAcceptor.accept(offset, length);
                    }
                }
                ++n2;
            }
        }
        catch (BadLocationException e) {
            log.error((Object)e, (Throwable)e);
        }
        catch (BadPartitioningException e) {
            log.error((Object)e, (Throwable)e);
        }
        catch (AssertionFailedException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    protected Pattern getTextPatternInComment() {
        return TEXT_PATTERN_IN_COMMENT;
    }

    protected boolean isHandled(EObject eObject) {
        return eObject.eContainer() != null;
    }

    protected boolean shouldProcessContent(EObject object) {
        return true;
    }
}

