/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.xtext.builder.trace.ITraceForTypeRootProvider;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.JavaClassPathResourceForIEditorInputFactory;

public class XbaseResourceForEditorInputFactory
extends JavaClassPathResourceForIEditorInputFactory {
    @Inject
    private ITraceForTypeRootProvider typeForTypeRootProvider;

    protected URI getClassFileSourceURI(IClassFile classFile) {
        ITrace traceToSource = this.typeForTypeRootProvider.getTraceToSource((ITypeRoot)classFile);
        Iterator iterator = traceToSource.getAllAssociatedLocations().iterator();
        if (iterator.hasNext()) {
            ILocationInResource loc = (ILocationInResource)iterator.next();
            return loc.getAbsoluteResourceURI();
        }
        return null;
    }

    public Resource createResource(IEditorInput editorInput) {
        Resource resource;
        if (editorInput instanceof IClassFileEditorInput && (resource = this.createResource(((IClassFileEditorInput)editorInput).getClassFile())) != null) {
            return resource;
        }
        return super.createResource(editorInput);
    }

    protected boolean isValidationDisabled(IStorage storage) {
        IFile file;
        IJavaProject javaProject;
        if (!(!(storage instanceof IFile) || (javaProject = JavaCore.create((IProject)(file = (IFile)storage).getProject())) != null && javaProject.exists() && javaProject.isOpen())) {
            return true;
        }
        return super.isValidationDisabled(storage);
    }

    protected Resource createResource(IClassFile classFile) {
        URI uri = this.getClassFileSourceURI(classFile);
        IProject project = classFile.getJavaProject().getProject();
        ResourceSet resourceSet = this.getResourceSetProvider().get(project);
        XtextResource resource = (XtextResource)this.getResourceFactory().createResource(uri);
        resourceSet.getResources().add((Object)resource);
        resource.setValidationDisabled(true);
        return resource;
    }
}

