/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.quickfix;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.ui.imports.OrganizeImportsHandler;
import org.eclipse.xtext.xbase.ui.quickfix.CreateJavaTypeQuickfixes;
import org.eclipse.xtext.xbase.ui.quickfix.JavaTypeQuickfixes;

public class XbaseQuickfixProvider
extends DefaultQuickfixProvider {
    @Inject
    private OrganizeImportsHandler organizeImportsHandler;
    @Inject
    protected JavaTypeQuickfixes javaTypeQuickfixes;
    @Inject
    private CreateJavaTypeQuickfixes createJavaTypeQuickfixes;

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.import_duplicate")
    public void fixDuplicateImport(Issue issue, IssueResolutionAcceptor acceptor) {
        this.organizeImports(issue, acceptor);
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.import_unsued")
    public void fixUnusedImport(Issue issue, IssueResolutionAcceptor acceptor) {
        this.organizeImports(issue, acceptor);
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.import_wildcard_deprecated")
    public void fixDuplicateWildcardUse(Issue issue, IssueResolutionAcceptor acceptor) {
        this.organizeImports(issue, acceptor);
    }

    protected void organizeImports(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Organize imports", "Organizes the whole import section. Removes wildcard imports as well as duplicates and unused ones.", this.getOrganizeImportsImage(), new IModification(){

            public void apply(IModificationContext context) throws Exception {
                XbaseQuickfixProvider.this.organizeImportsHandler.doOrganizeImports(context.getXtextDocument());
            }
        });
    }

    protected String getOrganizeImportsImage() {
        return "impc_obj.gif";
    }

    public void createLinkingIssueResolutions(final Issue issue, final IssueResolutionAcceptor issueResolutionAcceptor) {
        IModificationContext modificationContext = this.getModificationContextFactory().createModificationContext(issue);
        final IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        if (xtextDocument != null) {
            xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource state) throws Exception {
                    EObject target = state.getEObject(issue.getUriToProblem().fragment());
                    EReference reference = XbaseQuickfixProvider.this.getUnresolvedEReference(issue, target);
                    if (reference != null && reference.getEReferenceType() != null) {
                        XbaseQuickfixProvider.this.createLinkingIssueQuickfixes(issue, issueResolutionAcceptor, xtextDocument, state, target, reference);
                    }
                }
            });
        }
    }

    protected void createLinkingIssueQuickfixes(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, IXtextDocument xtextDocument, XtextResource state, EObject target, EReference reference) throws Exception {
        this.javaTypeQuickfixes.addQuickfixes(issue, issueResolutionAcceptor, xtextDocument, state, target, reference);
        this.createJavaTypeQuickfixes.addQuickfixes(issue, issueResolutionAcceptor, xtextDocument, state, target, reference);
    }

    protected EReference getUnresolvedEReference(Issue issue, EObject target) {
        EReference unresolvedEReference = super.getUnresolvedEReference(issue, target);
        if (unresolvedEReference == null && target instanceof XConstructorCall) {
            return XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR;
        }
        return unresolvedEReference;
    }
}

