/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.jvmmodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.ImplementedBy;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.JvmModelInferrerDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ImplementedBy(value=SingletonDelegatingRegistry.class)
public class JvmModelInferrerRegistry {
    public static final JvmModelInferrerRegistry INSTANCE = new JvmModelInferrerRegistry();
    private static final Logger log = Logger.getLogger(JvmModelInferrerRegistry.class);
    private volatile Map<String, List<IJvmModelInferrer>> map = null;
    private boolean isUseRegistry = EMFPlugin.IS_ECLIPSE_RUNNING;

    private synchronized Map<String, List<IJvmModelInferrer>> getMap() {
        if (this.map == null) {
            this.map = this.initialize();
        }
        return this.map;
    }

    public void setUseRegistry(boolean isUseRegistry) {
        this.isUseRegistry = isUseRegistry;
    }

    public boolean isUseRegistry() {
        return this.isUseRegistry;
    }

    private Map<String, List<IJvmModelInferrer>> initialize() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (this.isUseRegistry) {
            this.initializeFromRegistry(result);
        }
        return result;
    }

    public List<? extends IJvmModelInferrer> getModelInferrer(String extension) {
        if (!this.getMap().containsKey(extension)) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)this.getMap().get(extension));
    }

    public void register(String extension, IJvmModelInferrer inferrer) {
        this.register(extension, inferrer, this.getMap());
    }

    protected void register(String extension, IJvmModelInferrer inferrer, Map<String, List<IJvmModelInferrer>> map) {
        List<IJvmModelInferrer> list;
        int index;
        if (!map.containsKey(extension)) {
            map.put(extension, new ArrayList());
        }
        if ((index = (list = map.get(extension)).indexOf(inferrer)) == -1) {
            list.add(inferrer);
        } else {
            list.set(index, inferrer);
            log.error((Object)("Java translator " + inferrer + " for extension '" + extension + "' was already registered. Replaced it."));
        }
    }

    public void deregister(String extension, IJvmModelInferrer inferrer) {
        List<IJvmModelInferrer> list = this.getMap().get(extension);
        if (list != null) {
            list.remove(inferrer);
        }
    }

    private void initializeFromRegistry(final Map<String, List<IJvmModelInferrer>> map) {
        IExtensionRegistry eReg = Platform.getExtensionRegistry();
        new RegistryReader(eReg, "org.eclipse.xtext.xbase", "java_translation_participant"){

            protected boolean readElement(IConfigurationElement element, boolean add) {
                if (element.getName().equals("javaTranslator")) {
                    String fileExtension = element.getAttribute("fileExtension");
                    if (fileExtension == null) {
                        this.logMissingAttribute(element, "fileExtension");
                    } else if (element.getAttribute("class") == null) {
                        this.logMissingAttribute(element, "class");
                    } else {
                        if (add) {
                            JvmModelInferrerRegistry.this.register(fileExtension, new JvmModelInferrerDescriptor(element), map);
                            return true;
                        }
                        return true;
                    }
                }
                return false;
            }
        }.readRegistry();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    public static class SingletonDelegatingRegistry
    extends JvmModelInferrerRegistry {
        @Override
        public void register(String extension, IJvmModelInferrer inferrer) {
            INSTANCE.register(extension, inferrer);
        }

        @Override
        public List<? extends IJvmModelInferrer> getModelInferrer(String extension) {
            return INSTANCE.getModelInferrer(extension);
        }

        @Override
        public void deregister(String extension, IJvmModelInferrer inferrer) {
            INSTANCE.deregister(extension, inferrer);
        }
    }
}

