/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.reconciler;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.reconciler.ReconcilerReplaceRegion;
import org.eclipse.xtext.ui.util.DisplayRunnable;
import org.eclipse.xtext.util.DiffUtil;
import org.eclipse.xtext.util.EmfStructureComparator;

public class XtextReconcilerDebugger {
    private static final Logger LOG = Logger.getLogger(XtextReconcilerDebugger.class);
    @Inject
    private IParser parser;
    @Inject
    private EmfStructureComparator emfStructureComparator;

    public void assertModelInSyncWithDocument(IDocument document, XtextResource resource, final ReconcilerReplaceRegion region) {
        if (document instanceof IDocumentExtension4 && resource != null) {
            IParseResult parseResult;
            long beforeGet = ((IDocumentExtension4)document).getModificationStamp();
            final String documentContent = document.get();
            long afterGet = ((IDocumentExtension4)document).getModificationStamp();
            if (beforeGet == afterGet && beforeGet == resource.getModificationStamp() && (parseResult = resource.getParseResult()) != null) {
                ICompositeNode rootNode = parseResult.getRootNode();
                final String resourceContent = rootNode.getText();
                if (!resourceContent.equals(documentContent)) {
                    new DisplayRunnable(){

                        protected void run() throws Exception {
                            LOG.error((Object)("XtextDocument and XtextResource have run out of sync:\n" + DiffUtil.diff((String)documentContent, (String)resourceContent)));
                            LOG.error((Object)("Events: \n\t" + Joiner.on((String)"\n\t").join(region.getDocumentEvents())));
                            LOG.error((Object)("ReplaceRegion: \n\t'" + (Object)((Object)region) + "'"));
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"XtextReconcilerDebugger", (String)"XtextDocument and XtextResource have run out of sync.\n\nSee log for details.");
                        }
                    }.syncExec();
                } else {
                    System.out.println("Model and document are in sync");
                }
            }
        }
    }

    public void assertResouceParsedCorrectly(XtextResource resource, final ReconcilerReplaceRegion region) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            ICompositeNode rootNode = parseResult.getRootNode();
            String resourceContent = rootNode.getText();
            IParseResult reparseResult = this.parser.parse((Reader)new StringReader(resourceContent));
            if (!this.emfStructureComparator.isSameStructure(parseResult.getRootASTElement(), reparseResult.getRootASTElement())) {
                new DisplayRunnable(){

                    protected void run() throws Exception {
                        LOG.error((Object)"PartialParsing produced wrong model");
                        LOG.error((Object)("Events: \n\t" + Joiner.on((String)"\n\t").join(region.getDocumentEvents())));
                        LOG.error((Object)("ReplaceRegion: \n\t'" + (Object)((Object)region) + "'"));
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"XtextReconcilerDebugger", (String)"PartialParsing produced wrong model.\n\nSee log for details.");
                    }
                };
            }
        }
    }
}

