/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.parser.antlr;

import com.google.common.base.Function;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.xtext.generator.grammarAccess.GrammarAccessExtensions;
import org.eclipse.xtext.xtext.generator.parser.antlr.IgnoreCaseString;

public class KeywordHelper
implements Adapter {
    private BiMap<CharSequence, String> keywordValueToToken;
    private boolean ignoreCase;
    private GrammarAccessExtensions grammarUtil;
    public static final Comparator<String> keywordComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            int result = s2.length() - s1.length();
            return result != 0 ? result : s1.compareTo(s2);
        }
    };

    public KeywordHelper(Grammar grammar, boolean ignoreCase, GrammarAccessExtensions grammarUtil) {
        this.ignoreCase = ignoreCase;
        this.grammarUtil = grammarUtil;
        this.keywordValueToToken = this.createKeywordMap(grammar);
        grammar.eResource().getResourceSet().eAdapters().add((Object)this);
    }

    public void discardHelper(Grammar grammar) {
        grammar.eResource().getResourceSet().eAdapters().remove((Object)this);
    }

    public static KeywordHelper getHelper(EObject context) {
        for (Adapter candidate : context.eResource().getResourceSet().eAdapters()) {
            if (!(candidate instanceof KeywordHelper)) continue;
            return (KeywordHelper)candidate;
        }
        return null;
    }

    public String getRuleName(String keywordValue) {
        return (String)this.keywordValueToToken.get((Object)this.createKey(keywordValue));
    }

    public String getKeywordValue(String ruleName) {
        return ((CharSequence)this.keywordValueToToken.inverse().get((Object)ruleName)).toString();
    }

    public boolean isKeywordRule(String ruleName) {
        return this.keywordValueToToken.containsValue((Object)ruleName);
    }

    public Set<String> getAllKeywords() {
        TreeSet<String> result = new TreeSet<String>(keywordComparator);
        for (CharSequence cs : this.keywordValueToToken.keySet()) {
            result.add(cs.toString());
        }
        return Collections.unmodifiableSet(result);
    }

    private BiMap<CharSequence, String> createKeywordMap(Grammar grammar) {
        List parserRules = GrammarUtil.allParserRules((Grammar)grammar);
        List enumRules = GrammarUtil.allEnumRules((Grammar)grammar);
        Iterator iter = Iterators.concat((Iterator)EcoreUtil.getAllContents((Collection)parserRules), (Iterator)EcoreUtil.getAllContents((Collection)enumRules));
        UnmodifiableIterator filtered = Iterators.filter((Iterator)iter, Keyword.class);
        Iterator transformed = Iterators.transform((Iterator)filtered, (Function)new Function<Keyword, String>(){

            public String apply(Keyword from) {
                return from.getValue();
            }
        });
        TreeSet treeSet = Sets.newTreeSet((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() == o2.length()) {
                    return o1.compareTo(o2);
                }
                return Integer.valueOf(o1.length()).compareTo(o2.length());
            }
        });
        Iterators.addAll((Collection)treeSet, (Iterator)transformed);
        HashBiMap result = HashBiMap.create();
        for (String s : treeSet) {
            CharSequence key = this.createKey(s);
            Object readableName = this.toAntlrTokenIdentifier(s);
            if (result.containsValue(readableName)) {
                int i = 1;
                String next = (String)readableName + "_" + i;
                while (result.containsValue((Object)next)) {
                    next = (String)readableName + "_" + ++i;
                }
                readableName = next;
            }
            result.put((Object)key, readableName);
        }
        return result;
    }

    private String toAntlrTokenIdentifier(String s) {
        Object result = this.grammarUtil.toJavaIdentifier(s, (boolean)Boolean.TRUE);
        if (((String)(result = ((String)result).replace("\u00e4", "ae").replace("\u00f6", "Oe").replace("\u00fc", "Ue").replace("\u00c4", "Ae").replace("\u00d6", "Oe").replace("\u00dc", "Ue"))).charAt(0) == '_' || "System".equals(result) || ((String)result).startsWith("DFA") || ((String)result).startsWith("EOF") || ((String)result).startsWith("FOLLOW") || ((String)result).startsWith("Internal") && ((String)result).endsWith("Parser")) {
            result = "KW_" + (String)result;
        }
        return result;
    }

    private CharSequence createKey(String s) {
        if (this.ignoreCase) {
            return new IgnoreCaseString(s);
        }
        return s;
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void notifyChanged(Notification notification) {
    }

    public void setTarget(Notifier newTarget) {
    }
}

