/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.ui.resource.DefaultResourceUIServiceProvider;

public class XtendResourceUiServiceProvider
extends DefaultResourceUIServiceProvider {
    @Inject(optional=true)
    private IResourceStorageFacade resourceStorageFacade;

    @Inject
    public XtendResourceUiServiceProvider(IResourceServiceProvider delegate) {
        super(delegate);
    }

    public boolean canHandle(URI uri) {
        return super.canHandle(uri);
    }

    public boolean canBuild(URI uri, IStorage storage) {
        if (storage instanceof IFile) {
            IFile file = (IFile)storage;
            IProject project = file.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            return this.isInSourceFolder(javaProject, file);
        }
        return this.resourceStorageFacade != null && this.resourceStorageFacade.hasStorageFor(uri);
    }

    public boolean isInSourceFolder(IJavaProject javaProject, IFile resource) {
        IClasspathEntry[] classpath;
        IPath path = resource.getFullPath();
        try {
            classpath = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException e) {
            return false;
        }
        int i = 0;
        while (i < classpath.length) {
            IPath entryPath;
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() == 3 && (entryPath = entry.getPath()).isPrefixOf(path) && !this.isExcluded(entry, path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isExcluded(IClasspathEntry entry, IPath path) {
        char[][] inclusionPatterns = this.getInclusionPatterns(entry);
        char[][] exclusionPatterns = this.getExclusionPatterns(entry);
        return Util.isExcluded((IPath)path, (char[][])inclusionPatterns, (char[][])exclusionPatterns, (boolean)false);
    }

    private char[][] getInclusionPatterns(IClasspathEntry entry) {
        return null;
    }

    private char[][] getExclusionPatterns(IClasspathEntry entry) {
        if (entry instanceof ClasspathEntry) {
            ClasspathEntry classpathEntry = (ClasspathEntry)entry;
            return classpathEntry.fullExclusionPatternChars();
        }
        return this.toFullPatternChars(entry, entry.getExclusionPatterns());
    }

    private char[][] toFullPatternChars(IClasspathEntry entry, IPath[] patterns) {
        if (patterns == null) {
            return null;
        }
        int length = patterns.length;
        char[][] fullPatternChars = new char[length][];
        IPath prefixPath = entry.getPath().removeTrailingSeparator();
        int i = 0;
        while (i < length) {
            fullPatternChars[i] = prefixPath.append(patterns[i]).toString().toCharArray();
            ++i;
        }
        return fullPatternChars;
    }
}

