/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.builder;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.builder.ParallelBuilderParticipant;
import org.eclipse.xtext.generator.FileSystemAccessQueue;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.compiler.ElementIssueProvider;
import org.eclipse.xtext.xbase.lib.Procedures;

public class XtendParallelBuilderParticipant
extends ParallelBuilderParticipant {
    private static Logger LOGGER = Logger.getLogger(XtendParallelBuilderParticipant.class);
    @Inject
    private IStorage2UriMapper mapper;
    @Inject
    private ElementIssueProvider.Factory elementIssueProviderFactory;

    protected void handleChangedContents(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, IFileSystemAccess access) throws CoreException {
        if (!this.getResourceServiceProvider().canHandle(delta.getUri())) {
            return;
        }
        Resource resource = context.getResourceSet().getResource(delta.getUri(), true);
        this.saveResourceStorage(resource, access);
        IFile file = this.getFile(resource, context);
        if (file != null) {
            this.getGenerator().doGenerate(resource, access);
        }
    }

    protected Runnable createRunnable(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, Map<String, OutputConfiguration> outputConfigurations, Map<OutputConfiguration, Iterable<IMarker>> generatorMarkers, FileSystemAccessQueue fileSystemAccessQueue, IFileSystemAccess delegate, IProgressMonitor progressMonitor) {
        IFile file = null;
        Resource resource = null;
        if (delta.getNew() != null) {
            resource = context.getResourceSet().getResource(delta.getUri(), true);
            file = this.getFile(resource, context);
        }
        return this.createRunnable(delta, file, resource, context, outputConfigurations, generatorMarkers, fileSystemAccessQueue, delegate, progressMonitor);
    }

    protected Runnable createRunnable(final IResourceDescription.Delta delta, final IFile file, final Resource resource, final IXtextBuilderParticipant.IBuildContext context, final Map<String, OutputConfiguration> outputConfigurations, final Map<OutputConfiguration, Iterable<IMarker>> generatorMarkers, final FileSystemAccessQueue fileSystemAccessQueue, final IFileSystemAccess delegate, final IProgressMonitor progressMonitor) {
        if (file != null) {
            this.elementIssueProviderFactory.attachData(resource);
        }
        return new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        Set derivedResources = XtendParallelBuilderParticipant.this.getDerivedResources(delta, outputConfigurations, generatorMarkers);
                        IFileSystemAccess fsa = XtendParallelBuilderParticipant.this.getParalleFileSystemAccess(delta, context, derivedResources, fileSystemAccessQueue, delegate);
                        boolean generated = XtendParallelBuilderParticipant.this.doGenerate(delta, context, fsa);
                        fileSystemAccessQueue.sendAsync(delta.getUri(), XtendParallelBuilderParticipant.this.getFlushAndCleanDerivedResourcesCallback(delta, derivedResources, context, generated, delegate, progressMonitor));
                    }
                    catch (Throwable throwable) {
                        if (file != null) {
                            fileSystemAccessQueue.sendAsync(delta.getUri(), new Procedures.Procedure0(resource){
                                private final /* synthetic */ Resource val$resource;
                                {
                                    this.val$resource = resource;
                                }

                                public void apply() {
                                    XtendParallelBuilderParticipant.this.elementIssueProviderFactory.detachData(this.val$resource);
                                }
                            });
                        }
                        throw throwable;
                    }
                    if (file != null) {
                        fileSystemAccessQueue.sendAsync(delta.getUri(), new /* invalid duplicate definition of identical inner class */);
                    }
                }
                catch (OperationCanceledException derivedResources) {
                }
                catch (Throwable e) {
                    XtendParallelBuilderParticipant.this.addMarkerAndLogError(delta.getUri(), e);
                }
            }
        };
    }

    protected IFile getFile(Resource resource, IXtextBuilderParticipant.IBuildContext context) {
        Iterable storages = this.mapper.getStorages(resource.getURI());
        for (Pair pair : storages) {
            if (!(pair.getFirst() instanceof IFile) || !((IProject)pair.getSecond()).equals((Object)context.getBuiltProject())) continue;
            return (IFile)pair.getFirst();
        }
        return null;
    }

    protected List<IPath> getSourceFolderPathes(IProject project) {
        ArrayList sourceFolder = Lists.newArrayList();
        try {
            if (project.isOpen() && JavaProject.hasJavaNature((IProject)project)) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                List<IPackageFragmentRoot> packageFragmentRoots = Arrays.asList(javaProject.getPackageFragmentRoots());
                for (IPackageFragmentRoot packageFragmentRoot : packageFragmentRoots) {
                    if (packageFragmentRoot.getKind() != 1) continue;
                    IPath path = packageFragmentRoot.getPath();
                    sourceFolder.add(path);
                }
            }
        }
        catch (JavaModelException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return sourceFolder;
    }

    protected Map<OutputConfiguration, Iterable<IMarker>> getGeneratorMarkers(IProject builtProject, Collection<OutputConfiguration> outputConfigurations) throws CoreException {
        HashMap generatorMarkers = Maps.newHashMap();
        List<IPath> sourcePath = this.getSourceFolderPathes(builtProject);
        for (OutputConfiguration config : outputConfigurations) {
            if (!config.isCleanUpDerivedResources()) continue;
            ArrayList containerToSearchIn = Lists.newArrayList();
            for (IPath sourceFolder : sourcePath) {
                if (sourceFolder.segmentCount() == 1) {
                    containerToSearchIn.add(builtProject);
                    continue;
                }
                IFolder sourcePathBasedContainer = builtProject.getWorkspace().getRoot().getFolder(sourceFolder);
                containerToSearchIn.add(sourcePathBasedContainer);
            }
            ArrayList markers = Lists.newArrayList();
            for (IContainer container : containerToSearchIn) {
                Iterables.addAll((Collection)markers, (Iterable)this.getDerivedResourceMarkers().findDerivedResourceMarkers((IResource)container, this.getGeneratorIdProvider().getGeneratorIdentifier()));
            }
            generatorMarkers.put(config, markers);
        }
        return generatorMarkers;
    }
}

