/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.typesystem.computation.AbstractClosureTypeHelper;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeAssigner;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.ConstraintVisitingInfo;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.DeferredTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByUnboundSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

public class ClosureWithExpectationHelper
extends AbstractClosureTypeHelper {
    private final JvmOperation operation;
    private List<JvmFormalParameter> implicitParameters;
    private FunctionTypeReference expectedClosureType;
    private FunctionTypeReference resultClosureType;
    private boolean validParameterTypes = true;
    private boolean preferredSugar = false;

    protected ClosureWithExpectationHelper(XClosure closure, JvmOperation operation, ITypeExpectation expectation, ITypeComputationState state) {
        super(closure, expectation, state);
        this.operation = operation;
        if (operation == null || expectation.getExpectedType() == null) {
            throw new IllegalStateException("Cannot locate appropriate operation for " + this.getClosure());
        }
        this.prepareComputation();
    }

    @Override
    public JvmOperation getOperation() {
        return this.operation;
    }

    @Override
    public FunctionTypeReference getExpectedClosureType() {
        return this.expectedClosureType;
    }

    @Override
    protected void computeTypes() {
        this.prepareResultType();
        if (this.resultClosureType == null) {
            throw new IllegalStateException("Cannot locate appropriate operation for " + this.getClosure());
        }
        LightweightTypeReference expectedReturnType = this.expectedClosureType.getReturnType();
        if (expectedReturnType == null) {
            throw new IllegalStateException("expected return type may not be null");
        }
        ITypeAssigner typeAssigner = this.getState().withRootExpectation(expectedReturnType).assignTypes();
        ITypeComputationState closureBodyTypeComputationState = this.getClosureBodyTypeComputationState(typeAssigner);
        ITypeComputationResult expressionResult = closureBodyTypeComputationState.computeTypes(this.getClosure().getExpression());
        int flags = this.processExpressionType(expressionResult);
        if (this.resultClosureType.getReturnType() == null) {
            throw new IllegalStateException("Closure has no return type assigned");
        }
        if (!this.validParameterTypes || flags == 262144) {
            if (flags == 0) {
                this.markIncompatibleParameterList();
            } else if (this.validParameterTypes) {
                this.markCompatibleParameterList();
            } else {
                this.markIncompatible();
            }
        } else if (flags == 0x800000) {
            this.markRawCompatible();
        } else if (flags == Integer.MIN_VALUE) {
            this.markVoidCompatible();
        } else {
            this.markUncheckedValid();
        }
    }

    private void acceptActualType(int flags) {
        this.getExpectation().acceptActualType((LightweightTypeReference)this.resultClosureType, flags | 2);
    }

    protected void markUncheckedValid() {
        if (this.preferredSugar) {
            this.acceptActualType(0x40400000);
        } else {
            this.acceptActualType(0x400000);
        }
    }

    protected void markIncompatibleParameterList() {
        if (this.preferredSugar) {
            this.acceptActualType(0x40340000);
        } else {
            this.acceptActualType(0x340000);
        }
    }

    protected void markCompatibleParameterList() {
        if (this.preferredSugar) {
            this.acceptActualType(1093664768);
        } else {
            this.acceptActualType(0x1300000);
        }
    }

    protected void markIncompatible() {
        if (this.preferredSugar) {
            this.acceptActualType(1345585152);
        } else {
            this.acceptActualType(271843328);
        }
    }

    protected void markRawCompatible() {
        if (this.preferredSugar) {
            this.acceptActualType(0x50B00000);
        } else {
            this.acceptActualType(0x10B00000);
        }
    }

    protected void markVoidCompatible() {
        if (this.preferredSugar) {
            this.acceptActualType(-802160128);
        } else {
            this.acceptActualType(-1875901952);
        }
    }

    protected void prepareComputation() {
        LightweightTypeReference expectedType = this.getExpectation().getExpectedType();
        if (expectedType == null) {
            throw new IllegalStateException();
        }
        JvmType type = expectedType.getType();
        if (type == null) {
            throw new IllegalStateException();
        }
        if (type instanceof JvmTypeParameter) {
            type = this.operation.getDeclaringType();
        }
        this.expectedClosureType = this.initKnownClosureType(type, this.operation);
        this.deferredBindTypeArgument(expectedType, this.expectedClosureType, BoundTypeArgumentSource.INFERRED_CONSTRAINT);
    }

    protected void prepareResultType() {
        this.resultClosureType = this.expectedClosureType.getOwner().newFunctionTypeReference(this.expectedClosureType.getType());
        for (LightweightTypeReference argument : this.expectedClosureType.getTypeArguments()) {
            this.resultClosureType.addTypeArgument(argument);
        }
    }

    protected FunctionTypeReference initKnownClosureType(JvmType type, final JvmOperation operation) {
        ITypeReferenceOwner owner = this.getExpectation().getReferenceOwner();
        FunctionTypeReference result = owner.newFunctionTypeReference(type);
        TypeParameterByUnboundSubstitutor substitutor = new TypeParameterByUnboundSubstitutor(Collections.emptyMap(), owner){

            @Override
            protected LightweightTypeReference getUnmappedSubstitute(ParameterizedTypeReference reference, JvmTypeParameter type, ConstraintVisitingInfo visiting) {
                if (type.getDeclarator() == operation) {
                    return reference.copyInto(this.getOwner());
                }
                LightweightTypeReference result = this.createUnboundTypeReference(type);
                if (result == null) {
                    result = new TypeParameterByConstraintSubstitutor(this.getTypeParameterMapping(), this.getOwner()).substitute(type);
                }
                return result;
            }

            @Override
            protected UnboundTypeReference createUnboundTypeReference(JvmTypeParameter type) {
                UnboundTypeReference result = ClosureWithExpectationHelper.this.getExpectation().createUnboundTypeReference(ClosureWithExpectationHelper.this.getClosure(), type);
                return result;
            }
        };
        if (type instanceof JvmTypeParameterDeclarator) {
            EList typeParameters = ((JvmTypeParameterDeclarator)type).getTypeParameters();
            for (JvmTypeParameter typeParameter : typeParameters) {
                ParameterizedTypeReference typeParameterReference = owner.newParameterizedTypeReference((JvmType)typeParameter);
                LightweightTypeReference substituted = substitutor.substitute(typeParameterReference);
                result.addTypeArgument(substituted);
            }
            Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> definedMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(result);
            substitutor.enhanceMapping(definedMapping);
        }
        LightweightTypeReference declaredReturnType = owner.toLightweightTypeReference(operation.getReturnType());
        for (JvmFormalParameter parameter : operation.getParameters()) {
            LightweightTypeReference lightweight = owner.toLightweightTypeReference(parameter.getParameterType());
            LightweightTypeReference lowerBound = lightweight.getLowerBoundSubstitute();
            LightweightTypeReference substituted = substitutor.substitute(lowerBound);
            result.addParameterType(substituted);
        }
        LightweightTypeReference returnType = declaredReturnType;
        LightweightTypeReference substituted = substitutor.substitute(returnType);
        result.setReturnType(substituted);
        return result;
    }

    protected ITypeComputationState getClosureBodyTypeComputationState(ITypeAssigner typeAssigner) {
        EList exceptions;
        ITypeComputationState result = this.assignParameters(typeAssigner);
        LightweightTypeReference expectedType = this.getExpectation().getExpectedType();
        if (expectedType == null) {
            throw new IllegalStateException();
        }
        JvmType knownType = expectedType.getType();
        if (knownType != null && knownType instanceof JvmGenericType) {
            result.assignType(IFeatureNames.SELF, knownType, expectedType);
        }
        if ((exceptions = this.operation.getExceptions()).isEmpty()) {
            result.withinScope(this.getClosure());
            return result;
        }
        ArrayList expectedExceptions = Lists.newArrayListWithCapacity((int)exceptions.size());
        for (JvmTypeReference exception : exceptions) {
            expectedExceptions.add(typeAssigner.toLightweightTypeReference(exception));
        }
        result.withinScope(this.getClosure());
        return result.withExpectedExceptions(expectedExceptions);
    }

    @Override
    public List<JvmFormalParameter> getParameters() {
        XClosure closure = this.getClosure();
        if (closure.isExplicitSyntax()) {
            return closure.getDeclaredFormalParameters();
        }
        if (this.implicitParameters != null) {
            return this.implicitParameters;
        }
        return closure.getImplicitFormalParameters();
    }

    protected ITypeComputationState assignParameters(ITypeAssigner typeAssigner) {
        JvmFormalParameter closureParameter;
        Object closureParameters;
        List<LightweightTypeReference> operationParameterTypes = this.expectedClosureType.getParameterTypes();
        XClosure closure = this.getClosure();
        boolean explicit = closure.isExplicitSyntax();
        if (explicit) {
            closureParameters = closure.getDeclaredFormalParameters();
        } else if (closure.getImplicitFormalParameters().isEmpty()) {
            this.implicitParameters = Lists.newArrayListWithCapacity((int)operationParameterTypes.size());
            int i = 0;
            while (i < operationParameterTypes.size()) {
                JvmFormalParameter parameter = TypesFactory.eINSTANCE.createJvmFormalParameter();
                if (operationParameterTypes.size() == 1) {
                    parameter.setName(IFeatureNames.IT.getFirstSegment());
                    this.preferredSugar = true;
                } else {
                    parameter.setName("$" + i);
                }
                this.implicitParameters.add(parameter);
                ++i;
            }
            closureParameters = this.implicitParameters;
        } else {
            closureParameters = closure.getImplicitFormalParameters();
            if (closureParameters.size() == 1) {
                this.preferredSugar = true;
            }
        }
        Object skippedHandle = null;
        LightweightTypeReference returnType = this.expectedClosureType.getReturnType();
        if (returnType.getKind() == 6) {
            skippedHandle = ((UnboundTypeReference)returnType).getHandle();
        }
        this.validParameterTypes = closureParameters.size() == operationParameterTypes.size();
        int paramCount = Math.min(closureParameters.size(), operationParameterTypes.size());
        boolean returnTypeIsArg = false;
        int i = 0;
        while (i < paramCount) {
            closureParameter = (JvmFormalParameter)closureParameters.get(i);
            LightweightTypeReference operationParameterType = operationParameterTypes.get(i);
            if (operationParameterType.getKind() == 6) {
                UnboundTypeReference casted = (UnboundTypeReference)operationParameterType;
                boolean isSkippedHandle = casted.getHandle().equals(skippedHandle);
                if (!isSkippedHandle && !casted.internalIsResolved() && casted.hasSignificantHints()) {
                    casted.acceptHint(VarianceInfo.IN);
                }
                if (isSkippedHandle) {
                    returnTypeIsArg = true;
                }
            }
            if (explicit && closureParameter.getParameterType() != null) {
                LightweightTypeReference closureParameterType = typeAssigner.toLightweightTypeReference(closureParameter.getParameterType());
                new DeferredTypeParameterHintCollector(this.getExpectation().getReferenceOwner()){

                    @Override
                    protected void addHint(UnboundTypeReference typeParameter, LightweightTypeReference reference) {
                        LightweightTypeReference wrapped = reference.getWrapperTypeIfPrimitive();
                        typeParameter.acceptHint(wrapped, BoundTypeArgumentSource.RESOLVED, this.getOrigin(), this.getExpectedVariance(), this.getActualVariance());
                        ParameterizedTypeReference typeParameterReference = reference.getOwner().newParameterizedTypeReference((JvmType)typeParameter.getTypeParameter());
                        if (ClosureWithExpectationHelper.this.validParameterTypes && !((LightweightTypeReference)typeParameterReference).getRawTypeReference().isAssignableFrom(reference)) {
                            ClosureWithExpectationHelper.this.validParameterTypes = false;
                        }
                    }
                }.processPairedReferences(operationParameterType, closureParameterType);
                typeAssigner.assignType((JvmIdentifiableElement)closureParameter, closureParameterType);
                this.resultClosureType.addParameterType(closureParameterType);
                if (this.validParameterTypes && !closureParameterType.isAssignableFrom(operationParameterType)) {
                    this.validParameterTypes = false;
                }
            } else {
                LightweightTypeReference partiallyResolved = new TypeParameterSubstitutor<Object>(Collections.emptyMap(), typeAssigner.getReferenceOwner()){

                    @Override
                    protected Object createVisiting() {
                        return new Object();
                    }

                    @Override
                    protected LightweightTypeReference doVisitUnboundTypeReference(UnboundTypeReference reference, Object param) {
                        if (reference.internalIsResolved()) {
                            return (LightweightTypeReference)super.doVisitUnboundTypeReference(reference, param);
                        }
                        List<LightweightBoundTypeArgument> hints = reference.getAllHints();
                        for (LightweightBoundTypeArgument hint : hints) {
                            BoundTypeArgumentSource source = hint.getSource();
                            if (source != BoundTypeArgumentSource.INFERRED && source != BoundTypeArgumentSource.INFERRED_CONSTRAINT) continue;
                            reference.tryResolve();
                            if (!reference.internalIsResolved()) continue;
                            return reference.accept(this, param);
                        }
                        return reference;
                    }

                    @Override
                    public LightweightTypeReference substitute(LightweightTypeReference original) {
                        return original.accept(this, this.createVisiting());
                    }
                }.substitute(operationParameterType);
                typeAssigner.assignType((JvmIdentifiableElement)closureParameter, partiallyResolved);
                this.resultClosureType.addParameterType(partiallyResolved);
            }
            ++i;
        }
        if (skippedHandle != null && !returnTypeIsArg) {
            ((UnboundTypeReference)returnType).acceptHint(VarianceInfo.OUT);
        }
        i = paramCount;
        while (i < closureParameters.size()) {
            closureParameter = (JvmFormalParameter)closureParameters.get(i);
            JvmTypeReference parameterType = closureParameter.getParameterType();
            if (parameterType != null) {
                LightweightTypeReference lightweight = typeAssigner.toLightweightTypeReference(parameterType);
                typeAssigner.assignType((JvmIdentifiableElement)closureParameter, lightweight);
                this.resultClosureType.addParameterType(lightweight);
            } else {
                LightweightTypeReference objectType = typeAssigner.toLightweightTypeReference(this.getServices().getTypeReferences().getTypeForName(Object.class, (Notifier)closureParameter, new JvmTypeReference[0]));
                typeAssigner.assignType((JvmIdentifiableElement)closureParameter, objectType);
                this.resultClosureType.addParameterType(objectType);
            }
            ++i;
        }
        ITypeComputationState result = typeAssigner.getForkedState();
        return result;
    }

    protected int processExpressionType(ITypeComputationResult expressionResult) {
        LightweightTypeReference expressionResultType = expressionResult.getReturnType();
        if (expressionResultType == null || expressionResultType instanceof AnyTypeReference) {
            LightweightTypeReference returnType = this.expectedClosureType.getReturnType();
            if (returnType == null) {
                throw new IllegalStateException("return type shall not be null");
            }
            this.resultClosureType.setReturnType(returnType);
            if (this.validParameterTypes && returnType.isPrimitiveVoid()) {
                return 262144;
            }
        } else {
            LightweightTypeReference expectedReturnType = this.expectedClosureType.getReturnType();
            if (expectedReturnType == null) {
                throw new IllegalStateException("expected return type may not be null");
            }
            if (!expressionResultType.isPrimitiveVoid()) {
                if (expectedReturnType.isPrimitiveVoid()) {
                    this.resultClosureType.setReturnType(expectedReturnType);
                    if (this.isImplicitReturn(expressionResult)) {
                        return 0;
                    }
                    return 262144;
                }
                this.deferredBindTypeArgument(expectedReturnType, expressionResultType, BoundTypeArgumentSource.INFERRED);
            } else if (expectedReturnType.isPrimitiveVoid()) {
                this.resultClosureType.setReturnType(expressionResultType);
                if (this.validParameterTypes && this.isImplicitReturn(expressionResult)) {
                    return Integer.MIN_VALUE;
                }
                return 0;
            }
            if (expectedReturnType.isAssignableFrom(expressionResultType)) {
                this.resultClosureType.setReturnType(expressionResultType);
            } else {
                if (expectedReturnType.isPrimitiveVoid()) {
                    this.resultClosureType.setReturnType(expectedReturnType);
                    return 262144;
                }
                this.resultClosureType.setReturnType(expectedReturnType);
                return 0x800000;
            }
        }
        return 0;
    }

    protected boolean isImplicitReturn(ITypeComputationResult expressionResult) {
        int flags = expressionResult.getConformanceFlags();
        if ((0x4000000 & flags) != 0) {
            return false;
        }
        XExpression expression = expressionResult.getExpression();
        if (expression == null) {
            return true;
        }
        if (expression.eClass() == XbasePackage.Literals.XRETURN_EXPRESSION) {
            return false;
        }
        TreeIterator contents = expression.eAllContents();
        while (contents.hasNext()) {
            EObject next = (EObject)contents.next();
            if (next.eClass() == XbasePackage.Literals.XRETURN_EXPRESSION) {
                return false;
            }
            if (next.eClass() != XbasePackage.Literals.XCLOSURE) continue;
            contents.prune();
        }
        return true;
    }
}

