/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json.adapters;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class EitherTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        if (!Either.class.isAssignableFrom(typeToken.getRawType())) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)typeToken.getType();
        Type left = parameterizedType.getActualTypeArguments()[0];
        Type right = parameterizedType.getActualTypeArguments()[1];
        return new Adapter(gson, left, right);
    }

    private static class Adapter
    extends TypeAdapter<Either<?, ?>> {
        private final com.google.common.reflect.TypeToken<?> left;
        private final com.google.common.reflect.TypeToken<?> right;
        private final Gson gson;
        private final Set<Class<?>> specialRawTypes = Sets.newHashSet((Object[])new Class[]{String.class, Integer.class, Boolean.class, List.class});

        private boolean isObject(com.google.common.reflect.TypeToken<?> t) {
            for (Class<?> class1 : this.specialRawTypes) {
                if (!class1.isAssignableFrom(t.getRawType())) continue;
                return false;
            }
            return true;
        }

        Adapter(Gson gson, Type left, Type right) {
            this.gson = gson;
            this.left = com.google.common.reflect.TypeToken.of((Type)left);
            this.right = com.google.common.reflect.TypeToken.of((Type)right);
            if (this.isObject(this.left) && this.isObject(this.right)) {
                throw new IllegalArgumentException("Only one of the Either types can be a json object or StringMap.");
            }
            if (this.left.getRawType() == this.right.getRawType()) {
                throw new IllegalArgumentException("The raw types of an Either must be distinct.");
            }
        }

        public void write(JsonWriter out, Either<?, ?> value) throws IOException {
            if (value.isLeft()) {
                this.gson.toJson(value.getLeft(), (Type)this.left.getRawType(), out);
            } else {
                this.gson.toJson(value.getRight(), (Type)this.right.getRawType(), out);
            }
        }

        public Either<?, ?> read(JsonReader in) throws IOException {
            com.google.common.reflect.TypeToken next;
            JsonToken peek = in.peek();
            switch (in.peek()) {
                case NULL: {
                    return null;
                }
                case BEGIN_ARRAY: {
                    next = com.google.common.reflect.TypeToken.of(List.class);
                    break;
                }
                case BOOLEAN: {
                    next = com.google.common.reflect.TypeToken.of(Boolean.class);
                    break;
                }
                case NUMBER: {
                    next = com.google.common.reflect.TypeToken.of(Number.class);
                    break;
                }
                case STRING: {
                    next = com.google.common.reflect.TypeToken.of(String.class);
                    break;
                }
                case BEGIN_OBJECT: {
                    next = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal token " + in.peek());
                }
            }
            if (next != null) {
                if (next.isAssignableFrom(this.left)) {
                    return Either.forLeft(this.gson.fromJson(in, this.left.getType()));
                }
                if (next.isAssignableFrom(this.right)) {
                    return Either.forRight(this.gson.fromJson(in, this.right.getType()));
                }
                throw new IOException("Unexpected token '" + peek + "', for type '" + this.left + " | " + this.right + "'.");
            }
            if (this.isObject(this.left)) {
                return Either.forLeft(this.gson.fromJson(in, this.left.getType()));
            }
            if (this.isObject(this.right)) {
                return Either.forRight(this.gson.fromJson(in, this.right.getType()));
            }
            throw new IOException("Unexpected token '" + peek + "', for type '" + this.left + " | " + this.right + "'.");
        }
    }
}

