/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import com.google.common.base.Throwables;
import java.util.Iterator;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.builder.trace.DebugTraceBasedRegion;
import org.eclipse.xtext.builder.trace.DebugTraceRegion;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceNotFoundException;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.generator.trace.StorageAwareTrace;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;

public class TraceEditor
extends EcoreEditor {
    private StyledText text;

    protected Composite createPageContainer(final Composite parent) {
        Composite tree = new Composite(parent, 0);
        final Sash sash = new Sash(parent, 256);
        this.text = new StyledText(parent, 776);
        this.text.setFont(JFaceResources.getTextFont());
        FormLayout form = new FormLayout();
        parent.setLayout((Layout)form);
        FormData treeData = new FormData();
        treeData.left = new FormAttachment(0, 0);
        treeData.right = new FormAttachment(100, 0);
        treeData.top = new FormAttachment(0, 0);
        treeData.bottom = new FormAttachment((Control)sash, 0);
        tree.setLayoutData((Object)treeData);
        final FormData sashData = new FormData();
        sashData.left = new FormAttachment(0, 0);
        sashData.top = new FormAttachment(50, 0);
        sashData.right = new FormAttachment(100, 0);
        sash.setLayoutData((Object)sashData);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Rectangle sashRect = sash.getBounds();
                Rectangle parentRect = parent.getClientArea();
                int bottom = parentRect.height - sashRect.height - 20;
                e.y = Math.max(Math.min(e.y, bottom), 20);
                if (e.y != sashRect.y) {
                    sashData.top = new FormAttachment(0, e.y);
                    parent.layout();
                }
            }
        });
        FormData textData = new FormData();
        textData.left = new FormAttachment(0, 0);
        textData.right = new FormAttachment(100, 0);
        textData.top = new FormAttachment((Control)sash, 0);
        textData.bottom = new FormAttachment(100, 0);
        this.text.setLayoutData((Object)textData);
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    try {
                        Object x = ((IStructuredSelection)selection).getFirstElement();
                        if (x instanceof EObject) {
                            TraceEditor.this.updateText((EObject)x);
                        }
                        if (x instanceof Resource) {
                            TraceEditor.this.updateText((EObject)((Resource)x).getContents().get(0));
                        }
                    }
                    catch (Exception e) {
                        TraceEditor.this.text.setText(Throwables.getStackTraceAsString((Throwable)e));
                    }
                }
            }
        });
        return tree;
    }

    protected IStorage getLocalStorage(IResourceServiceProvider serviceProvider, URI traceURI) {
        TraceFileNameProvider fileNameProvider = (TraceFileNameProvider)serviceProvider.get(TraceFileNameProvider.class);
        IStorage2UriMapper storage2UriMapper = (IStorage2UriMapper)serviceProvider.get(IStorage2UriMapper.class);
        String generatedName = fileNameProvider.getJavaFromTrace(traceURI.lastSegment());
        URI generatedURI = traceURI.trimSegments(1).appendSegment(generatedName);
        Iterator iterator = storage2UriMapper.getStorages(generatedURI).iterator();
        if (iterator.hasNext()) {
            Pair x = (Pair)iterator.next();
            return (IStorage)x.getFirst();
        }
        throw new IllegalStateException("Could not find IStorage for " + generatedURI);
    }

    protected void updateText(EObject obj) {
        DebugTraceRegion region = (DebugTraceRegion)EcoreUtil2.getContainerOfType((EObject)obj, DebugTraceRegion.class);
        if (region == null) {
            this.text.setText("No " + DebugTraceRegion.class.getSimpleName() + " found for " + obj.eClass().getName());
            return;
        }
        final DebugTraceBasedRegion trace = new DebugTraceBasedRegion(null, region);
        SourceRelativeURI sourceURI = trace.getAssociatedSrcRelativePath();
        if (sourceURI == null) {
            this.text.setText("Could not find associated URI");
            return;
        }
        IResourceServiceProvider.Registry registry = IResourceServiceProvider.Registry.INSTANCE;
        IResourceServiceProvider serviceProvider = registry.getResourceServiceProvider(sourceURI.getURI());
        URI traceURI = obj.eResource().getURI();
        IStorage localStorage = this.getLocalStorage(serviceProvider, traceURI);
        StorageAwareTrace traceProvider = (StorageAwareTrace)serviceProvider.get(StorageAwareTrace.class);
        traceProvider.setLocalStorage(localStorage);
        traceProvider.setTraceToSource(true);
        traceProvider.setTraceRegionProvider(new ITraceRegionProvider(){

            public AbstractTraceRegion getTraceRegion() throws TraceNotFoundException {
                return trace;
            }
        });
        String newText = traceProvider.toString();
        this.text.setText(newText);
    }
}

