/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.doubleClicking;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.xtext.ui.editor.doubleClicking.AbstractWordAwareDoubleClickStrategy;

public abstract class AbstractPartitionDoubleClickSelector
extends AbstractWordAwareDoubleClickStrategy {
    private String fPartitioning;

    protected AbstractPartitionDoubleClickSelector(String partitioning) {
        this.fPartitioning = partitioning;
    }

    protected IRegion findExtendedDoubleClickSelection(IDocument document, int offset) {
        IRegion match = super.findExtendedDoubleClickSelection(document, offset);
        if (match != null) {
            return match;
        }
        try {
            ITypedRegion region = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)offset, (boolean)true);
            if (offset == region.getOffset() + 1 || offset == region.getOffset() + region.getLength() - 1) {
                return this.getSelectedRegion(document, region);
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return null;
    }

    protected IRegion getSelectedRegion(IDocument document, ITypedRegion completePartition) throws BadLocationException {
        return completePartition;
    }
}

