/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.NoSuchElementException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;

public class ProjectUtil {
    @Inject
    private IWorkspace workspace;
    @Inject
    private IStorage2UriMapper mapper;

    public IProject getProject(URI uri) {
        IFile file = this.findFileStorage(uri, false);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    public IFile findFileStorage(URI uri, final boolean validateEdit) {
        Iterable<Pair<IStorage, IProject>> storages = this.mapper.getStorages(uri);
        try {
            Pair fileStorage = (Pair)Iterables.find(storages, (Predicate)new Predicate<Pair<IStorage, IProject>>(){

                public boolean apply(Pair<IStorage, IProject> input) {
                    IStorage storage = (IStorage)input.getFirst();
                    if (storage instanceof IFile) {
                        IFile file = (IFile)storage;
                        return file.isAccessible() && (!validateEdit || !file.isReadOnly() || ProjectUtil.this.workspace.validateEdit(new IFile[]{file}, null).isOK());
                    }
                    return false;
                }
            });
            return (IFile)fileStorage.getFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }
}

