/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.workspace;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.ui.workspace.EclipseProjectConfig;
import org.eclipse.xtext.ui.workspace.EclipseProjectConfigProvider;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class EclipseWorkspaceConfig
implements IWorkspaceConfig {
    private final IWorkspaceRoot workspaceRoot;
    private final EclipseProjectConfigProvider projectConfigProvider;

    public Set<? extends EclipseProjectConfig> getProjects() {
        Functions.Function1 _function = it -> it.getProject().isAccessible();
        Functions.Function1 _function_1 = it -> this.projectConfigProvider.createProjectConfig(it.getProject());
        return IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)this.workspaceRoot.getProjects())), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    public EclipseProjectConfig findProjectByName(String name) {
        try {
            IProject project = this.workspaceRoot.getProject(name);
            boolean _isAccessible = project.isAccessible();
            if (_isAccessible) {
                return this.projectConfigProvider.createProjectConfig(project);
            }
            return null;
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                IllegalArgumentException cfr_ignored_0 = (IllegalArgumentException)_t;
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public EclipseProjectConfig findProjectContaining(URI member) {
        boolean _isPlatformResource = member.isPlatformResource();
        if (_isPlatformResource) {
            return this.findProjectByName(URI.decode((String)member.segment(1)));
        }
        return null;
    }

    public EclipseWorkspaceConfig(IWorkspaceRoot workspaceRoot, EclipseProjectConfigProvider projectConfigProvider) {
        this.workspaceRoot = workspaceRoot;
        this.projectConfigProvider = projectConfigProvider;
    }

    @Pure
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.workspaceRoot == null ? 0 : this.workspaceRoot.hashCode());
        result = 31 * result + (this.projectConfigProvider == null ? 0 : this.projectConfigProvider.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EclipseWorkspaceConfig other = (EclipseWorkspaceConfig)obj;
        if (this.workspaceRoot == null ? other.workspaceRoot != null : !this.workspaceRoot.equals((Object)other.workspaceRoot)) {
            return false;
        }
        return !(this.projectConfigProvider == null ? other.projectConfigProvider != null : !this.projectConfigProvider.equals(other.projectConfigProvider));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("workspaceRoot", (Object)this.workspaceRoot);
        b.add("projectConfigProvider", (Object)this.projectConfigProvider);
        return b.toString();
    }

    @Pure
    public IWorkspaceRoot getWorkspaceRoot() {
        return this.workspaceRoot;
    }

    @Pure
    public EclipseProjectConfigProvider getProjectConfigProvider() {
        return this.projectConfigProvider;
    }
}

