/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.typesystem;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.xtend.core.jvmmodel.AnonymousClassUtil;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.util.HumanReadableTypeNames;

public class LocalClassAwareTypeNames
extends HumanReadableTypeNames {
    @Inject
    private AnonymousClassUtil anonymousClassUtil;

    protected void doVisitParameterizedTypeReference(ParameterizedTypeReference reference, StringBuilder param) {
        boolean local;
        JvmType type = reference.getType();
        if (type instanceof JvmDeclaredType && (local = ((JvmDeclaredType)type).isLocal())) {
            param.append("new ");
            ((LightweightTypeReference)Iterables.getLast((Iterable)reference.getSuperTypes())).accept((TypeReferenceVisitorWithParameter)this, (Object)param);
            param.append("(){}");
            return;
        }
        super.doVisitParameterizedTypeReference(reference, param);
    }

    public String getReadableName(XtendTypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof AnonymousClass) {
            JvmGenericType superType = this.anonymousClassUtil.getSuperType((AnonymousClass)typeDeclaration);
            return "new " + superType.getSimpleName() + "(){}";
        }
        if (typeDeclaration.getName() == null) {
            return "<unnamed>";
        }
        return typeDeclaration.getName();
    }
}

