/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl.javasupport;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.xtext.builder.impl.IQueuedBuildDataContribution;
import org.eclipse.xtext.builder.impl.javasupport.UnconfirmedStructuralChangesDelta;
import org.eclipse.xtext.common.types.ui.notification.JavaBuilderState;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class JdtQueuedBuildData
implements IQueuedBuildDataContribution {
    private Map<String, JavaBuilderState> javaBuildState;
    private Map<String, JavaBuilderState> javaBuildStateCopy;
    private Collection<UnconfirmedStructuralChangesDelta> unconfirmedDeltas;
    private Collection<UnconfirmedStructuralChangesDelta> unconfirmedDeltasCopy;

    @Override
    public void reset() {
        this.javaBuildState = CollectionLiterals.newHashMap();
        this.unconfirmedDeltas = CollectionLiterals.newArrayList();
    }

    @Override
    public void reset(IProject project) {
        this.javaBuildState.remove(project.getName());
    }

    public Collection<UnconfirmedStructuralChangesDelta> getUnconfirmedDeltas() {
        return Collections.unmodifiableCollection(this.unconfirmedDeltas);
    }

    @Override
    public boolean queueChange(IResourceDescription.Delta delta) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (delta instanceof UnconfirmedStructuralChangesDelta) {
            _matched = true;
            boolean _xblockexpression = false;
            IProject project = ((UnconfirmedStructuralChangesDelta)delta).getProject();
            JavaBuilderState state = this.javaBuildState.get(project.getName());
            if (state == null) {
                state = JavaBuilderState.getLastBuiltState((IProject)project);
                this.javaBuildState.put(project.getName(), state);
            }
            ((UnconfirmedStructuralChangesDelta)delta).setBuildNumber(state.getBuildNumber());
            this.unconfirmedDeltas.add((UnconfirmedStructuralChangesDelta)delta);
            _switchResult = _xblockexpression = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    @Override
    public boolean needsRebuild(IProject it, Collection<IResourceDescription.Delta> deltas) {
        Procedures.Procedure1 _function;
        boolean _xblockexpression = false;
        JavaBuilderState oldState = this.javaBuildState.get(it.getName());
        JavaBuilderState newState = JavaBuilderState.getLastBuiltState((IProject)it);
        Object _xifexpression = null;
        _xifexpression = oldState == null || !Objects.equal((Object)oldState.getLastStructuralBuildTime(), (Object)newState.getLastStructuralBuildTime()) ? (_function = it_1 -> {
            Set structurallyChangedTypes = newState.getStructurallyChangedTypes();
            if (this.namesIntersect(it_1.getNew(), structurallyChangedTypes) || this.namesIntersect(it_1.getOld(), structurallyChangedTypes)) {
                deltas.add((IResourceDescription.Delta)it_1);
            }
        }) : null;
        _xblockexpression = this.doNeedRebuild(newState, (Procedures.Procedure1<? super UnconfirmedStructuralChangesDelta>)_xifexpression);
        return _xblockexpression;
    }

    protected boolean doNeedRebuild(JavaBuilderState it, Procedures.Procedure1<? super UnconfirmedStructuralChangesDelta> processor) {
        boolean _xblockexpression = false;
        Iterator<UnconfirmedStructuralChangesDelta> i = this.unconfirmedDeltas.iterator();
        while (i.hasNext()) {
            UnconfirmedStructuralChangesDelta unconfirmed = i.next();
            if (unconfirmed.getBuildNumber() >= it.getBuildNumber() || !unconfirmed.getProject().equals((Object)it.getProject())) continue;
            i.remove();
            if (processor == null) continue;
            processor.apply((Object)unconfirmed);
        }
        int _size = this.unconfirmedDeltas.size();
        _xblockexpression = _size != 0;
        return _xblockexpression;
    }

    protected boolean namesIntersect(IResourceDescription resourceDescription, Set<QualifiedName> names) {
        boolean _xblockexpression = false;
        if (resourceDescription == null) {
            return false;
        }
        Iterable _exportedObjects = resourceDescription.getExportedObjects();
        for (IEObjectDescription objectDescription : _exportedObjects) {
            boolean _contains = names.contains(objectDescription.getQualifiedName());
            if (!_contains) continue;
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    @Override
    public void createCheckpoint() {
        HashMap<String, JavaBuilderState> _hashMap = new HashMap<String, JavaBuilderState>(this.javaBuildState);
        this.javaBuildStateCopy = _hashMap;
        ArrayList<UnconfirmedStructuralChangesDelta> _arrayList = new ArrayList<UnconfirmedStructuralChangesDelta>(this.unconfirmedDeltas);
        this.unconfirmedDeltasCopy = _arrayList;
    }

    @Override
    public void discardCheckpoint() {
        this.javaBuildStateCopy = null;
        this.unconfirmedDeltasCopy = null;
    }

    @Override
    public void rollback() {
        this.javaBuildState.clear();
        this.javaBuildState.putAll(this.javaBuildStateCopy);
        this.unconfirmedDeltas.clear();
        this.unconfirmedDeltas.addAll(this.unconfirmedDeltasCopy);
    }
}

