/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.javaconverter;

import com.google.inject.Inject;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.common.types.descriptions.ClasspathScanner;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class ASTParserFactory {
    protected final String minParserApiLevel = "1.6";
    @Inject
    private ClasspathScanner classpathScanner;

    protected final ASTParser createDefaultJavaParser(String javaVersion) {
        ASTParser parser = null;
        Hashtable options = JavaCore.getOptions();
        try {
            parser = ASTParser.newParser((int)ASTParserFactory.asJLS(javaVersion));
            JavaCore.setComplianceOptions((String)javaVersion, (Map)options);
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                parser = ASTParser.newParser((int)ASTParserFactory.asJLS("1.6"));
                JavaCore.setComplianceOptions((String)"1.6", (Map)options);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions((Map)options);
        parser.setStatementsRecovery(true);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        return parser;
    }

    public static int asJLS(String javaVersion) {
        int _switchResult;
        block21: {
            block19: {
                _switchResult = 0;
                if (javaVersion == null) break block19;
                switch (javaVersion) {
                    case "1.7": {
                        _switchResult = 4;
                        break;
                    }
                    case "1.8": {
                        _switchResult = 8;
                        break;
                    }
                    case "11": {
                        _switchResult = 11;
                        break;
                    }
                    case "12": {
                        _switchResult = 11;
                        break;
                    }
                    case "13": {
                        _switchResult = 11;
                        break;
                    }
                    default: {
                        _switchResult = 3;
                        break;
                    }
                }
                break block21;
            }
            _switchResult = 3;
        }
        return _switchResult;
    }

    public ASTParserWrapper createJavaParser(Object context) {
        String targetJavaVersion = System.getProperty("java.specification.version");
        if (targetJavaVersion == null) {
            targetJavaVersion = "1.6";
        }
        ASTParser parser = this.createDefaultJavaParser(targetJavaVersion);
        this.provideCustomEnvironment(parser);
        return new ASTParserWrapper(targetJavaVersion, parser);
    }

    protected void provideCustomEnvironment(ASTParser parser) {
        String[] cpEntries = this.classpathScanner.getSystemClasspath();
        parser.setEnvironment(cpEntries, null, null, true);
    }

    @Data
    public static class ASTParserWrapper {
        private final String targetLevel;
        private final ASTParser parser;

        public ASTNode createAST() {
            return this.parser.createAST(null);
        }

        public void setKind(int i) {
            this.parser.setKind(i);
        }

        public void setSource(char[] cs) {
            this.parser.setSource(cs);
        }

        public void setUnitName(String string) {
            this.parser.setUnitName(string);
        }

        public ASTParserWrapper(String targetLevel, ASTParser parser) {
            this.targetLevel = targetLevel;
            this.parser = parser;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.targetLevel == null ? 0 : this.targetLevel.hashCode());
            return 31 * result + (this.parser == null ? 0 : this.parser.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ASTParserWrapper other = (ASTParserWrapper)obj;
            if (this.targetLevel == null ? other.targetLevel != null : !this.targetLevel.equals(other.targetLevel)) {
                return false;
            }
            return !(this.parser == null ? other.parser != null : !this.parser.equals(other.parser));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("targetLevel", (Object)this.targetLevel);
            b.add("parser", (Object)this.parser);
            return b.toString();
        }

        @Pure
        public String getTargetLevel() {
            return this.targetLevel;
        }

        @Pure
        public ASTParser getParser() {
            return this.parser;
        }
    }
}

