/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.hyperlinking;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.typesystem.computation.IAmbiguousLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ISuspiciouslyOverloadedCandidate;
import org.eclipse.xtext.xbase.ui.navigation.JvmImplementationOpener;
import org.eclipse.xtext.xbase.ui.navigation.XbaseHyperLinkHelper;
import org.eclipse.xtext.xbase.ui.navigation.XbaseImplementatorsHyperlink;

public class XtendHyperlinkHelper
extends XbaseHyperLinkHelper {
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private IJavaElementFinder javaElementFinder;
    @Inject
    private JvmImplementationOpener implOpener;

    public void createHyperlinksTo(XtextResource from, Region region, EObject to, IHyperlinkAcceptor acceptor) {
        Set sourceElements = this.associations.getSourceElements(to);
        if (sourceElements.isEmpty()) {
            super.createHyperlinksTo(from, region, to, acceptor);
        } else {
            for (EObject sourceElement : sourceElements) {
                super.createHyperlinksTo(from, region, sourceElement, acceptor);
            }
        }
    }

    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        super.createHyperlinksByOffset(resource, offset, acceptor);
        if (this.canShowMany(acceptor)) {
            EObject jvmElement;
            ILeafNode node;
            XtendField member;
            EObject element = this.getEObjectAtOffsetHelper().resolveElementAt(resource, offset);
            if (element instanceof XtendField && this.isNameNode((EObject)(member = (XtendField)element), (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, node = NodeModelUtils.findLeafNodeAtOffset((INode)resource.getParseResult().getRootNode(), (int)offset)) && member.getType() == null && (jvmElement = this.associations.getPrimaryJvmElement((EObject)member)) instanceof JvmIdentifiableElement) {
                this.addOpenInferredTypeHyperlink(resource, (JvmIdentifiableElement)jvmElement, node, acceptor);
            }
            if (element instanceof XtendFunction && this.isNameNode((EObject)(member = (XtendFunction)element), (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, node = NodeModelUtils.findLeafNodeAtOffset((INode)resource.getParseResult().getRootNode(), (int)offset)) && (jvmElement = this.associations.getPrimaryJvmElement((EObject)member)) instanceof JvmIdentifiableElement) {
                JvmIdentifiableElement identifiableElement = (JvmIdentifiableElement)jvmElement;
                if (member.getReturnType() == null) {
                    this.addOpenInferredTypeHyperlink(resource, identifiableElement, node, acceptor);
                }
                IJavaElement javaElement = this.javaElementFinder.findExactElementFor(identifiableElement);
                if (this.sourceViewer != null && javaElement != null && javaElement.getElementType() == 9 && this.canBeOverridden((IMethod)javaElement)) {
                    Region region = new Region(node.getOffset(), node.getLength());
                    acceptor.accept((IHyperlink)new XbaseImplementatorsHyperlink(javaElement, (IRegion)region, (ITextViewer)this.sourceViewer, this.implOpener));
                }
            }
        }
    }

    protected void createHyperlinksForCrossRef(XtextResource resource, INode crossRefNode, IHyperlinkAcceptor acceptor) {
        EObject crossLinkedEObject = this.getEObjectAtOffsetHelper().getCrossReferencedElement(crossRefNode);
        if (crossLinkedEObject != null && !crossLinkedEObject.eIsProxy()) {
            IConstructorLinkingCandidate candidate;
            XConstructorCall casted;
            EObject containedElementAt = this.getEObjectAtOffsetHelper().resolveContainedElementAt(resource, crossRefNode.getOffset());
            if (containedElementAt instanceof XAbstractFeatureCall) {
                XAbstractFeatureCall casted2 = (XAbstractFeatureCall)containedElementAt;
                if (casted2.getFeature() == crossLinkedEObject) {
                    IFeatureLinkingCandidate candidate2 = this.getBatchTypeResolver().resolveTypes((EObject)casted2).getLinkingCandidate(casted2);
                    if (candidate2 instanceof IAmbiguousLinkingCandidate) {
                        this.createMultipleLinks(resource, crossRefNode, ((IAmbiguousLinkingCandidate)candidate2).getAlternatives(), acceptor);
                    } else if (candidate2 instanceof ISuspiciouslyOverloadedCandidate) {
                        ISuspiciouslyOverloadedCandidate castedCandidate = (ISuspiciouslyOverloadedCandidate)candidate2;
                        this.createMultipleLinks(resource, crossRefNode, Lists.newArrayList((Object[])new ILinkingCandidate[]{castedCandidate.getChosenCandidate(), castedCandidate.getRejectedCandidate()}), acceptor);
                    }
                }
            } else if (containedElementAt instanceof XConstructorCall && (casted = (XConstructorCall)containedElementAt).getConstructor() == crossLinkedEObject && (candidate = this.getBatchTypeResolver().resolveTypes((EObject)casted).getLinkingCandidate(casted)) instanceof IAmbiguousLinkingCandidate) {
                this.createMultipleLinks(resource, crossRefNode, ((IAmbiguousLinkingCandidate)candidate).getAlternatives(), acceptor);
            }
        }
        super.createHyperlinksForCrossRef(resource, crossRefNode, acceptor);
    }

    private void createMultipleLinks(XtextResource resource, INode crossRefNode, List<? extends ILinkingCandidate> alternatives, IHyperlinkAcceptor acceptor) {
        for (ILinkingCandidate iLinkingCandidate : alternatives) {
            this.createHyperlinksTo(resource, crossRefNode, (EObject)iLinkingCandidate.getFeature(), acceptor);
        }
    }
}

