/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.highlighting;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;

public class XbaseHighlightingConfiguration
extends DefaultHighlightingConfiguration {
    public static final String STATIC_METHOD_INVOCATION = "xbase.static.method.invocation";
    public static final String STATIC_FIELD = "xbase.static.field";
    public static final String FIELD = "xbase.field";
    public static final String METHOD = "xbase.method";
    public static final String ANNOTATION = "xbase.annotation";
    public static final String EXTENSION_METHOD_INVOCATION = "xbase.extension.method.invacation";
    public static final String DEPRECATED_MEMBERS = "xbase.deprecated.members";

    public void configure(IHighlightingConfigurationAcceptor acceptor) {
        acceptor.acceptDefaultHighlighting(STATIC_METHOD_INVOCATION, "Static method invocations", this.staticMethodInvocation());
        acceptor.acceptDefaultHighlighting(STATIC_FIELD, "Static fields", this.staticField());
        acceptor.acceptDefaultHighlighting(FIELD, "Fields", this.field());
        acceptor.acceptDefaultHighlighting(ANNOTATION, "Annotations", this.annotation());
        acceptor.acceptDefaultHighlighting(EXTENSION_METHOD_INVOCATION, "Extension method invocations", this.extensionMethodInvocation());
        acceptor.acceptDefaultHighlighting(DEPRECATED_MEMBERS, "Deprecated members", this.deprecatedMembers());
        acceptor.acceptDefaultHighlighting("xbase.interface", "Interfaces", this.interfaces());
        acceptor.acceptDefaultHighlighting("xbase.enum", "Enums", this.enums());
        acceptor.acceptDefaultHighlighting("xbase.class", "Classes", this.classes());
        acceptor.acceptDefaultHighlighting("xbase.abstract.class", "Abstract classes", this.abstractClasses());
        acceptor.acceptDefaultHighlighting("xbase.static.final.field", "Static final fields", this.staticFinalField());
        acceptor.acceptDefaultHighlighting(METHOD, "Methods", this.method());
        acceptor.acceptDefaultHighlighting("xbase.abstract.method.invocation", "Abstract method invocations", this.abstractMethodInvocation());
        acceptor.acceptDefaultHighlighting("xbase.local.variable", "Local variables", this.localVariable());
        acceptor.acceptDefaultHighlighting("xbase.local.variable.declaration", "Local variable declarations", this.localVariableDecl());
        acceptor.acceptDefaultHighlighting("xbase.local.final.variable", "Local final variables", this.localFinalVariable());
        acceptor.acceptDefaultHighlighting("xbase.local.final.variable.declaration", "Local final variable declarations", this.localFinalVariableDecl());
        acceptor.acceptDefaultHighlighting("xbase.parameter.variable", "Parameter variables", this.parameterVariable());
        acceptor.acceptDefaultHighlighting("xbase.type.variable", "Type variables", this.typeVariable());
        acceptor.acceptDefaultHighlighting("xbase.type.argument", "Type arguments", this.typeArgument());
        super.configure(acceptor);
    }

    public TextStyle staticMethodInvocation() {
        TextStyle textStyle = this.method().copy();
        textStyle.setStyle(2);
        return textStyle;
    }

    public TextStyle staticField() {
        TextStyle textStyle = this.field().copy();
        textStyle.setStyle(2);
        textStyle.setColor(new RGB(0, 0, 192));
        return textStyle;
    }

    public TextStyle field() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(0, 26, 171));
        return textStyle;
    }

    public TextStyle annotation() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(100, 100, 100));
        return textStyle;
    }

    public TextStyle extensionMethodInvocation() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(171, 48, 0));
        return textStyle;
    }

    public TextStyle deprecatedMembers() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setStyle(0x20000000);
        return textStyle;
    }

    public TextStyle interfaces() {
        return this.defaultTextStyle().copy();
    }

    public TextStyle enums() {
        return this.defaultTextStyle().copy();
    }

    public TextStyle classes() {
        return this.defaultTextStyle().copy();
    }

    public TextStyle abstractClasses() {
        return this.classes().copy();
    }

    public TextStyle staticFinalField() {
        return this.staticField().copy();
    }

    public TextStyle inheritedField() {
        return this.field().copy();
    }

    public TextStyle method() {
        return this.defaultTextStyle().copy();
    }

    public TextStyle abstractMethodInvocation() {
        return this.method().copy();
    }

    public TextStyle inheritedMethodInvocation() {
        return this.method().copy();
    }

    public TextStyle localVariable() {
        return this.defaultTextStyle().copy();
    }

    public TextStyle localVariableDecl() {
        return this.localVariable().copy();
    }

    public TextStyle localFinalVariable() {
        return this.localVariable().copy();
    }

    public TextStyle localFinalVariableDecl() {
        return this.localFinalVariable().copy();
    }

    public TextStyle parameterVariable() {
        return this.localVariable().copy();
    }

    public TextStyle typeVariable() {
        return this.typeArgument().copy();
    }

    public TextStyle typeArgument() {
        return this.defaultTextStyle().copy();
    }
}

