/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.buildpath;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtend.ide.buildpath.Messages;
import org.osgi.framework.Bundle;

public final class XtendClasspathContainer
implements IClasspathContainer {
    private static final String XTEXT_XBASE_LIB_BUNDLE_ID = "org.eclipse.xtext.xbase.lib";
    private static final String XTEND_LIB_MACRO_BUNDLE_ID = "org.eclipse.xtend.lib.macro";
    private static final String XTEND_LIB_BUNDLE_ID = "org.eclipse.xtend.lib";
    public static final String[] BUNDLE_IDS_TO_INCLUDE = new String[]{"com.google.guava", "org.eclipse.xtext.xbase.lib", "org.eclipse.xtend.lib", "org.eclipse.xtend.lib.macro"};
    private static final String SOURCE_SUFIX = ".source";
    private static final Logger LOG = Logger.getLogger(XtendClasspathContainer.class);
    private final IPath containerPath;
    private IClasspathEntry[] classPathEnries;

    XtendClasspathContainer(IPath containerPath) {
        this.containerPath = containerPath;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.classPathEnries == null) {
            ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
            String[] stringArray = BUNDLE_IDS_TO_INCLUDE;
            int n = BUNDLE_IDS_TO_INCLUDE.length;
            int n2 = 0;
            while (n2 < n) {
                String bundleId = stringArray[n2];
                this.addEntry(cpEntries, bundleId);
                ++n2;
            }
            this.classPathEnries = cpEntries.toArray(new IClasspathEntry[0]);
        }
        return this.classPathEnries;
    }

    private void addEntry(List<IClasspathEntry> cpEntries, String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle != null) {
            IPath bundlePath = this.bundlePath(bundle);
            IPath sourceBundlePath = this.calculateSourceBundlePath(bundle, bundlePath);
            cpEntries.add(JavaCore.newLibraryEntry((IPath)bundlePath, (IPath)sourceBundlePath, null));
        }
    }

    private IPath bundlePath(Bundle bundle) {
        IPath path = this.binFolderPath(bundle);
        if (path == null) {
            try {
                File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
                path = new Path(bundleFile.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.error((Object)("Can't resolve path '" + bundle.getSymbolicName() + "'"), (Throwable)e);
            }
        }
        return path;
    }

    private IPath binFolderPath(Bundle bundle) {
        URL binFolderURL = FileLocator.find((Bundle)bundle, (IPath)new Path("bin/main"), null);
        if (binFolderURL != null) {
            try {
                URL binFolderFileURL = FileLocator.toFileURL((URL)binFolderURL);
                return new Path(binFolderFileURL.getPath()).makeAbsolute();
            }
            catch (IOException e) {
                LOG.error((Object)("Can't resolve path '" + bundle.getSymbolicName() + "'"), (Throwable)e);
            }
        }
        if ((binFolderURL = FileLocator.find((Bundle)bundle, (IPath)new Path("bin"), null)) != null) {
            try {
                URL binFolderFileURL = FileLocator.toFileURL((URL)binFolderURL);
                return new Path(binFolderFileURL.getPath()).makeAbsolute();
            }
            catch (IOException e) {
                LOG.error((Object)("Can't resolve path '" + bundle.getSymbolicName() + "'"), (Throwable)e);
            }
        }
        return null;
    }

    private IPath calculateSourceBundlePath(Bundle bundle, IPath bundleLocation) {
        IPath sourcesPath = null;
        try {
            IPath binFolderPath = this.binFolderPath(bundle);
            if (binFolderPath == null) {
                String symbolicName;
                String binaryJarName;
                String sourceJarName;
                IPath bundlesParentFolder = bundleLocation.removeLastSegments(1);
                IPath potentialSourceJar = bundlesParentFolder.append(sourceJarName = (binaryJarName = bundleLocation.lastSegment()).replace(symbolicName = bundle.getSymbolicName(), symbolicName.concat(SOURCE_SUFIX)));
                if (potentialSourceJar.toFile().exists()) {
                    sourcesPath = potentialSourceJar;
                }
            } else {
                sourcesPath = binFolderPath.toString().endsWith("bin/main/") ? binFolderPath.removeLastSegments(2) : binFolderPath.removeLastSegments(1);
            }
        }
        catch (Throwable t) {
            LOG.debug((Object)"Exception during source bundle inverstigation.", t);
        }
        return sourcesPath;
    }

    public String getDescription() {
        return Messages.XtendClasspathContainer_Description;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.containerPath;
    }
}

