/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class UniqueClassNameValidator
extends AbstractDeclarativeValidator {
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IJvmModelAssociations associations;

    public void register(EValidatorRegistrar registrar) {
    }

    @Inject
    protected void register(EValidatorRegistrar registrar, IGrammarAccess grammarAccess) {
        AbstractRule entryRule = (AbstractRule)Iterables.getFirst((Iterable)grammarAccess.getGrammar().getRules(), null);
        if (entryRule instanceof ParserRule) {
            registrar.register(((ParserRule)entryRule).getType().getClassifier().getEPackage(), (EValidator)this);
        }
    }

    @Check
    public void checkUniqueName(EObject root) {
        Resource resource;
        if (root.eContainer() == null && Objects.equals(Iterables.getFirst((Iterable)(resource = root.eResource()).getContents(), null), root)) {
            for (EObject o : resource.getContents()) {
                if (!(o instanceof JvmDeclaredType)) continue;
                this.doCheckUniqueName((JvmDeclaredType)o);
            }
        }
    }

    protected void doCheckUniqueName(JvmDeclaredType type) {
        QualifiedName name;
        if (type.eContainer() == null && (name = this.qualifiedNameProvider.getFullyQualifiedName((EObject)type)) != null) {
            this.doCheckUniqueName(name, type);
        }
    }

    protected boolean doCheckUniqueName(QualifiedName name, JvmDeclaredType type) {
        IResourceDescriptions index = this.resourceDescriptionsProvider.getResourceDescriptions(type.eResource());
        Iterable others = index.getExportedObjects(TypesPackage.Literals.JVM_DECLARED_TYPE, name, false);
        return this.checkUniqueInIndex(type, others);
    }

    protected boolean checkUniqueInIndex(JvmDeclaredType type, Iterable<IEObjectDescription> descriptions) {
        HashSet<URI> resourceURIs = new HashSet<URI>();
        for (IEObjectDescription d : descriptions) {
            resourceURIs.add(d.getEObjectURI().trimFragment());
        }
        if (resourceURIs.size() > 1) {
            for (URI uri : resourceURIs) {
                if (Objects.equals(uri, type.eResource().getURI())) continue;
                this.addIssue(type, uri.lastSegment());
                break;
            }
            return false;
        }
        if (IterableExtensions.size(descriptions) > 1) {
            this.addIssue(type);
            return false;
        }
        return true;
    }

    protected void addIssue(JvmDeclaredType type) {
        this.addIssue(type, null);
    }

    protected void addIssue(JvmDeclaredType type, String fileName) {
        StringConcatenation builder = new StringConcatenation();
        builder.append("The type ");
        builder.append(type.getSimpleName());
        builder.append(" is already defined");
        if (fileName != null) {
            builder.append(" in ");
            builder.append(fileName);
        }
        builder.append(".");
        String message = builder.toString();
        EObject sourceElement = this.associations.getPrimarySourceElement((EObject)type);
        if (sourceElement == null) {
            this.addIssue(message, (EObject)type, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_type");
        } else {
            this.addIssue(message, sourceElement, sourceElement.eClass().getEStructuralFeature("name"), "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_type", new String[0]);
        }
    }
}

