/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.smap;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class SDEInstaller {
    private static final String nameSDE = "SourceDebugExtension";
    private byte[] orig;
    private byte[] sdeAttr;
    private byte[] gen;
    private int origPos = 0;
    private int genPos = 0;
    private int sdeIndex;
    private boolean verbose = false;

    public SDEInstaller(byte[] original, byte[] sdeAttr) throws IOException {
        this.sdeAttr = sdeAttr;
        this.orig = original;
        this.gen = new byte[this.orig.length + sdeAttr.length + 100];
        this.addSDE();
    }

    public byte[] getUpdatedByteCode() {
        byte[] result = new byte[this.genPos];
        System.arraycopy(this.gen, 0, result, 0, this.genPos);
        return result;
    }

    protected void addSDE() throws UnsupportedEncodingException, IOException {
        this.copy(8);
        int constantPoolCountPos = this.genPos;
        int constantPoolCount = this.readU2();
        if (this.verbose) {
            System.out.println("constant pool count: " + constantPoolCount);
        }
        this.writeU2(constantPoolCount);
        this.sdeIndex = this.copyConstantPool(constantPoolCount);
        if (this.sdeIndex < 0) {
            this.writeUtf8ForSDE();
            this.sdeIndex = constantPoolCount++;
            this.randomAccessWriteU2(constantPoolCountPos, constantPoolCount);
            if (this.verbose) {
                System.out.println("SourceDebugExtension not found, installed at: " + this.sdeIndex);
            }
        } else if (this.verbose) {
            System.out.println("SourceDebugExtension found at: " + this.sdeIndex);
        }
        this.copy(6);
        int interfaceCount = this.readU2();
        this.writeU2(interfaceCount);
        if (this.verbose) {
            System.out.println("interfaceCount: " + interfaceCount);
        }
        this.copy(interfaceCount * 2);
        this.copyMembers();
        this.copyMembers();
        int attrCountPos = this.genPos;
        int attrCount = this.readU2();
        this.writeU2(attrCount);
        if (this.verbose) {
            System.out.println("class attrCount: " + attrCount);
        }
        if (!this.copyAttrs(attrCount)) {
            this.randomAccessWriteU2(attrCountPos, ++attrCount);
            if (this.verbose) {
                System.out.println("class attrCount incremented");
            }
        }
        this.writeAttrForSDE(this.sdeIndex);
    }

    protected void copyMembers() {
        int count = this.readU2();
        this.writeU2(count);
        if (this.verbose) {
            System.out.println("members count: " + count);
        }
        int i = 0;
        while (i < count) {
            this.copy(6);
            int attrCount = this.readU2();
            this.writeU2(attrCount);
            if (this.verbose) {
                System.out.println("member attr count: " + attrCount);
            }
            this.copyAttrs(attrCount);
            ++i;
        }
    }

    protected boolean copyAttrs(int attrCount) {
        boolean sdeFound = false;
        int i = 0;
        while (i < attrCount) {
            int nameIndex = this.readU2();
            if (nameIndex == this.sdeIndex) {
                sdeFound = true;
                if (this.verbose) {
                    System.out.println("SDE attr found");
                }
            } else {
                this.writeU2(nameIndex);
                int len = this.readU4();
                this.writeU4(len);
                this.copy(len);
                if (this.verbose) {
                    System.out.println("attr len: " + len);
                }
            }
            ++i;
        }
        return sdeFound;
    }

    protected void writeAttrForSDE(int index) {
        this.writeU2(index);
        this.writeU4(this.sdeAttr.length);
        int i = 0;
        while (i < this.sdeAttr.length) {
            this.writeU1(this.sdeAttr[i]);
            ++i;
        }
    }

    protected void randomAccessWriteU2(int pos, int val) {
        int savePos = this.genPos;
        this.genPos = pos;
        this.writeU2(val);
        this.genPos = savePos;
    }

    protected int readU1() {
        return this.orig[this.origPos++] & 0xFF;
    }

    protected int readU2() {
        int res = this.readU1();
        return (res << 8) + this.readU1();
    }

    protected int readU4() {
        int res = this.readU2();
        return (res << 16) + this.readU2();
    }

    protected void writeU1(int val) {
        this.gen[this.genPos++] = (byte)val;
    }

    protected void writeU2(int val) {
        this.writeU1(val >> 8);
        this.writeU1(val & 0xFF);
    }

    protected void writeU4(int val) {
        this.writeU2(val >> 16);
        this.writeU2(val & 0xFFFF);
    }

    protected void copy(int count) {
        int i = 0;
        while (i < count) {
            this.gen[this.genPos++] = this.orig[this.origPos++];
            ++i;
        }
    }

    protected byte[] readBytes(int count) {
        byte[] bytes = new byte[count];
        int i = 0;
        while (i < count) {
            bytes[i] = this.orig[this.origPos++];
            ++i;
        }
        return bytes;
    }

    protected void writeBytes(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            this.gen[this.genPos++] = bytes[i];
            ++i;
        }
    }

    protected int copyConstantPool(int constantPoolCount) throws UnsupportedEncodingException, IOException {
        int sdeIndex = -1;
        int i = 1;
        while (i < constantPoolCount) {
            int tag = this.readU1();
            this.writeU1(tag);
            switch (tag) {
                case 7: 
                case 8: 
                case 16: {
                    if (this.verbose) {
                        System.out.println(i + " copying 2 bytes");
                    }
                    this.copy(2);
                    break;
                }
                case 15: {
                    if (this.verbose) {
                        System.out.println(i + " copying 3 bytes");
                    }
                    this.copy(3);
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    if (this.verbose) {
                        System.out.println(i + " copying 4 bytes");
                    }
                    this.copy(4);
                    break;
                }
                case 5: 
                case 6: {
                    if (this.verbose) {
                        System.out.println(i + " copying 8 bytes");
                    }
                    this.copy(8);
                    ++i;
                    break;
                }
                case 1: {
                    int len = this.readU2();
                    this.writeU2(len);
                    byte[] utf8 = this.readBytes(len);
                    String str = new String(utf8, "UTF-8");
                    if (this.verbose) {
                        System.out.println(i + " read class attr -- '" + str + "'");
                    }
                    if (str.equals(nameSDE)) {
                        sdeIndex = i;
                    }
                    this.writeBytes(utf8);
                    break;
                }
                default: {
                    throw new IOException("unexpected tag: " + tag);
                }
            }
            ++i;
        }
        return sdeIndex;
    }

    protected void writeUtf8ForSDE() {
        int len = nameSDE.length();
        this.writeU1(1);
        this.writeU2(len);
        int i = 0;
        while (i < len) {
            this.writeU1(nameSDE.charAt(i));
            ++i;
        }
    }
}

