/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.semantictokens;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.ide.editor.syntaxcoloring.LightweightPosition;
import org.eclipse.xtext.ide.editor.syntaxcoloring.MergingHighlightedPositionAcceptor;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.util.PositionReader;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;

@Beta
public class SemanticTokensService {
    @Inject
    private IResourceServiceProvider.Registry languagesRegistry;
    private final List<String> tokenTypes = new ArrayList<String>();
    private final List<String> tokenModifiers = new ArrayList<String>();

    protected SemanticTokensService() {
        this.addTokenTypes();
        this.addTokenModifiers();
    }

    protected void addTokenTypes() {
        this.tokenTypes.add("namespace");
        this.tokenTypes.add("type");
        this.tokenTypes.add("class");
        this.tokenTypes.add("enum");
        this.tokenTypes.add("interface");
        this.tokenTypes.add("struct");
        this.tokenTypes.add("typeParameter");
        this.tokenTypes.add("parameter");
        this.tokenTypes.add("variable");
        this.tokenTypes.add("property");
        this.tokenTypes.add("enumMember");
        this.tokenTypes.add("event");
        this.tokenTypes.add("function");
        this.tokenTypes.add("method");
        this.tokenTypes.add("macro");
        this.tokenTypes.add("keyword");
        this.tokenTypes.add("modifier");
        this.tokenTypes.add("comment");
        this.tokenTypes.add("string");
        this.tokenTypes.add("number");
        this.tokenTypes.add("regexp");
        this.tokenTypes.add("operator");
        this.tokenTypes.add("decorator");
    }

    protected void addTokenModifiers() {
        this.tokenModifiers.add("abstract");
        this.tokenModifiers.add("async");
        this.tokenModifiers.add("declaration");
        this.tokenModifiers.add("defaultLibrary");
        this.tokenModifiers.add("definition");
        this.tokenModifiers.add("deprecated");
        this.tokenModifiers.add("documentation");
        this.tokenModifiers.add("modification");
        this.tokenModifiers.add("readonly");
        this.tokenModifiers.add("static");
    }

    private List<LightweightPosition> getPositions(XtextResource resource, CancelIndicator cancelIndicator) {
        ISemanticHighlightingCalculator semanticHighlightingCalculator = this.getService(resource.getURI(), ISemanticHighlightingCalculator.class);
        if (semanticHighlightingCalculator != null) {
            MergingHighlightedPositionAcceptor acceptor = new MergingHighlightedPositionAcceptor(semanticHighlightingCalculator);
            semanticHighlightingCalculator.provideHighlightingFor(resource, acceptor, cancelIndicator);
            acceptor.mergePositions();
            return acceptor.getPositions();
        }
        return Collections.emptyList();
    }

    public SemanticTokens semanticTokensFull(Document document, XtextResource resource, SemanticTokensParams params, CancelIndicator cancelIndicator) {
        if (document == null || resource == null) {
            return new SemanticTokens(Collections.emptyList());
        }
        ArrayList<Integer> data = new ArrayList<Integer>();
        int lastOffset = 0;
        int lastLine = 0;
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (PositionReader reader = new PositionReader(document.getContents());){
                List<LightweightPosition> positions = this.getPositions(resource, cancelIndicator);
                positions.sort(Comparator.comparing(LightweightPosition::getOffset));
                for (LightweightPosition lightweightPosition : positions) {
                    Integer positionTokenType = this.getTokenType(lightweightPosition.getIds());
                    Integer positionTokenModifiers = this.getTokenModifiers(lightweightPosition.getIds());
                    if (positionTokenType == -1) continue;
                    int deltaOffset = lightweightPosition.getOffset() - lastOffset;
                    reader.skip(deltaOffset);
                    Position position = reader.getPosition();
                    int deltaLine = position.getLine() - lastLine;
                    lastLine = position.getLine();
                    lastOffset = lightweightPosition.getOffset();
                    data.add(deltaLine);
                    data.add(deltaLine == 0 ? deltaOffset : position.getCharacter());
                    data.add(lightweightPosition.getLength());
                    data.add(positionTokenType);
                    data.add(positionTokenModifiers);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
        return new SemanticTokens(data);
    }

    public List<String> getTokenTypes() {
        return this.tokenTypes;
    }

    public List<String> getTokenModifiers() {
        return this.tokenModifiers;
    }

    private int getTokenType(String[] ids) {
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            Integer index = this.tokenTypes.indexOf(id);
            if (index != -1) {
                return index;
            }
            ++n2;
        }
        return -1;
    }

    private Integer getTokenModifiers(String[] ids) {
        int bitmask = 0;
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            Integer index = this.tokenModifiers.indexOf(id);
            if (index != -1) {
                bitmask |= 1 << index;
            }
            ++n2;
        }
        return bitmask;
    }

    private <Service> Service getService(URI uri, Class<Service> type) {
        IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
        if (resourceServiceProvider != null) {
            return (Service)resourceServiceProvider.get(type);
        }
        return null;
    }
}

