/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.ConstraintAwareTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;

public class ElementOrComponentTypeComputer
extends TypeReferenceVisitorWithResult<LightweightTypeReference> {
    private final ITypeReferenceOwner owner;

    public static LightweightTypeReference compute(LightweightTypeReference iterableOrArray, ITypeReferenceOwner owner) {
        LightweightTypeReference result = iterableOrArray.accept(new ElementOrComponentTypeComputer(owner));
        return result;
    }

    protected ElementOrComponentTypeComputer(ITypeReferenceOwner owner) {
        this.owner = owner;
    }

    @Override
    public LightweightTypeReference doVisitParameterizedTypeReference(ParameterizedTypeReference reference) {
        ConstraintAwareTypeArgumentCollector typeArgumentCollector = new ConstraintAwareTypeArgumentCollector(this.owner);
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping = typeArgumentCollector.getTypeParameterMapping(reference);
        UnboundTypeParameterPreservingSubstitutor substitutor = new UnboundTypeParameterPreservingSubstitutor(typeParameterMapping, this.owner);
        JvmGenericType iterable = (JvmGenericType)this.owner.getServices().getTypeReferences().findDeclaredType(Iterable.class, (Notifier)this.owner.getContextResourceSet());
        if (iterable == null) {
            return this.owner.newUnknownTypeReference();
        }
        ParameterizedTypeReference substituteMe = this.owner.newParameterizedTypeReference((JvmType)iterable.getTypeParameters().get(0));
        LightweightTypeReference substitutedArgument = substitutor.substitute(substituteMe).getUpperBoundSubstitute();
        if (substitutedArgument.getType() instanceof JvmTypeParameter && !this.owner.getDeclaredTypeParameters().contains(substitutedArgument.getType())) {
            return substitutedArgument.getRawTypeReference();
        }
        return substitutedArgument;
    }

    @Override
    protected LightweightTypeReference doVisitAnyTypeReference(AnyTypeReference reference) {
        return reference;
    }

    @Override
    protected LightweightTypeReference doVisitUnknownTypeReference(UnknownTypeReference reference) {
        return reference;
    }

    @Override
    public LightweightTypeReference doVisitArrayTypeReference(ArrayTypeReference reference) {
        return reference.getComponentType();
    }

    @Override
    protected LightweightTypeReference doVisitUnboundTypeReference(UnboundTypeReference reference) {
        return null;
    }

    protected ITypeReferenceOwner getOwner() {
        return this.owner;
    }
}

