/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.builder.trace.TraceForStorageProvider;
import org.eclipse.xtext.builder.trace.TraceMarkers;
import org.eclipse.xtext.generator.AbstractFileSystemAccess2;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.ui.resource.ProjectByResourceProvider;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.util.StringInputStream;

public class EclipseResourceFileSystemAccess2
extends AbstractFileSystemAccess2 {
    private static final Logger log = Logger.getLogger(EclipseResourceFileSystemAccess2.class);
    private IProject project;
    private IProgressMonitor monitor;
    private IFileCallback callBack;
    @Inject
    private TraceRegionSerializer traceSerializer;
    @Inject
    private TraceMarkers traceMarkers;
    @Inject
    private TraceForStorageProvider fileBasedTraceInformation;
    @Inject
    private IWorkspace workspace;
    @Inject
    private ProjectByResourceProvider projectProvider;
    private Multimap<URI, IPath> sourceTraces;

    protected Multimap<URI, IPath> getSourceTraces() {
        return this.sourceTraces;
    }

    protected void resetSourceTraces() {
        this.sourceTraces = null;
    }

    protected TraceMarkers getTraceMarkers() {
        return this.traceMarkers;
    }

    protected IFileCallback getCallBack() {
        return this.callBack;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setContext(Object context) {
        if (context instanceof IProject) {
            this.setProject((IProject)context);
        } else if (context instanceof Resource) {
            Resource resource = (Resource)context;
            IProject project = this.getProjectContext(resource);
            if (project != null) {
                this.setProject(project);
            }
        } else {
            throw new IllegalArgumentException("Couldn't handle context " + context);
        }
    }

    protected IProject getProjectContext(Resource resource) {
        return this.projectProvider.getProjectContext(resource);
    }

    protected IProject getProject() {
        return this.project;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void setPostProcessor(IFileCallback callBack) {
        this.callBack = callBack;
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor;
    }

    protected boolean ensureOutputConfigurationDirectoryExists(OutputConfiguration outputConfig) {
        IContainer container = this.getContainer(outputConfig);
        if (!container.exists()) {
            if (outputConfig.isCreateOutputDirectory()) {
                try {
                    this.createContainer(container);
                    return true;
                }
                catch (CoreException e) {
                    throw new RuntimeIOException((Throwable)e);
                }
            }
            return false;
        }
        return true;
    }

    public void generateFile(String fileName, String outputName, CharSequence contents) {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        OutputConfiguration outputConfig = this.getOutputConfig(outputName);
        if (!this.ensureOutputConfigurationDirectoryExists(outputConfig)) {
            return;
        }
        IFile file = this.getFile(fileName, outputName);
        IFile traceFile = this.getTraceFile(file);
        try {
            String encoding = this.getEncoding(file);
            CharSequence postProcessedContent = this.postProcess(fileName, outputName, contents, encoding);
            String contentsAsString = postProcessedContent.toString();
            if (file.exists()) {
                if (outputConfig.isOverrideExistingResources()) {
                    StringInputStream newContent = this.getInputStream(contentsAsString, encoding);
                    if (this.hasContentsChanged(file, newContent)) {
                        newContent.reset();
                        file.setContents((InputStream)newContent, true, outputConfig.isKeepLocalHistory().booleanValue(), this.monitor);
                    } else {
                        file.touch(this.getMonitor());
                    }
                    if (file.isDerived() != outputConfig.isSetDerivedProperty()) {
                        this.setDerived(file, outputConfig.isSetDerivedProperty());
                    }
                    if (traceFile != null) {
                        this.updateTraceInformation(traceFile, postProcessedContent, outputConfig.isSetDerivedProperty());
                    }
                    if (this.callBack != null) {
                        this.callBack.afterFileUpdate(file);
                    }
                }
            } else {
                this.ensureParentExists(file);
                file.create((InputStream)this.getInputStream(contentsAsString, encoding), true, this.monitor);
                if (outputConfig.isSetDerivedProperty()) {
                    this.setDerived(file, true);
                }
                if (traceFile != null) {
                    this.updateTraceInformation(traceFile, postProcessedContent, outputConfig.isSetDerivedProperty());
                }
                if (this.callBack != null) {
                    this.callBack.afterFileCreation(file);
                }
            }
        }
        catch (CoreException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public void generateFile(String fileName, String outputName, InputStream content) {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        OutputConfiguration outputConfig = this.getOutputConfig(outputName);
        if (!this.ensureOutputConfigurationDirectoryExists(outputConfig)) {
            return;
        }
        try {
            IFile file = this.getFile(fileName, outputName);
            if (file.exists()) {
                if (outputConfig.isOverrideExistingResources()) {
                    if (this.hasContentsChanged(file, content)) {
                        content.reset();
                        file.setContents(content, true, outputConfig.isKeepLocalHistory().booleanValue(), this.monitor);
                    } else {
                        file.touch(this.getMonitor());
                    }
                    if (file.isDerived() != outputConfig.isSetDerivedProperty()) {
                        this.setDerived(file, outputConfig.isSetDerivedProperty());
                    }
                    if (this.callBack != null) {
                        this.callBack.afterFileUpdate(file);
                    }
                }
            } else {
                this.ensureParentExists(file);
                file.create(content, true, this.monitor);
                if (outputConfig.isSetDerivedProperty()) {
                    this.setDerived(file, true);
                }
                if (this.callBack != null) {
                    this.callBack.afterFileCreation(file);
                }
            }
        }
        catch (CoreException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    protected String getEncoding(IFile file) throws CoreException {
        return file.getCharset(true);
    }

    protected void setDerived(IFile file, boolean derived) throws CoreException {
        file.setDerived(derived);
    }

    @Deprecated
    protected void createFolder(IFolder folder) throws CoreException {
        this.ensureExists((IContainer)folder);
    }

    protected void createContainer(IContainer container) throws CoreException {
        if (container instanceof IFolder) {
            this.createFolder((IFolder)container);
        } else {
            this.ensureExists(container);
        }
    }

    protected void ensureParentExists(IFile file) throws CoreException {
        if (!file.exists()) {
            this.ensureExists(file.getParent());
        }
    }

    protected void ensureExists(IContainer container) throws CoreException {
        if (container.exists()) {
            return;
        }
        if (container instanceof IFolder) {
            this.ensureExists(container.getParent());
            ((IFolder)container).create(true, true, this.monitor);
        }
    }

    protected StringInputStream getInputStream(String contentsAsString, String encoding) {
        try {
            return new StringInputStream(contentsAsString, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    @Deprecated
    protected IFolder getFolder(OutputConfiguration outputConfig) {
        return (IFolder)this.getContainer(outputConfig);
    }

    protected IContainer getContainer(OutputConfiguration outputConfig) {
        String path = this.getCurrentSource() == null ? outputConfig.getOutputDirectory() : outputConfig.getOutputDirectory(this.getCurrentSource());
        if (".".equals(path) || "./".equals(path) || "".equals(path)) {
            return this.project;
        }
        return this.project.getFolder((IPath)new Path(path));
    }

    protected boolean hasContentsChanged(IFile file, StringInputStream newContent) {
        return this.hasContentsChanged(file, (InputStream)newContent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean hasContentsChanged(IFile file, InputStream newContent) {
        boolean contentChanged = false;
        BufferedInputStream oldContent = null;
        try {
            try {
                oldContent = new BufferedInputStream(file.getContents());
                int newByte = newContent.read();
                int oldByte = oldContent.read();
                while (newByte != -1 && oldByte != -1 && newByte == oldByte) {
                    newByte = newContent.read();
                    oldByte = oldContent.read();
                }
                contentChanged = newByte != oldByte;
                return contentChanged;
            }
            catch (CoreException e) {
                contentChanged = true;
                if (oldContent == null) return contentChanged;
                try {
                    oldContent.close();
                    return contentChanged;
                }
                catch (IOException iOException) {}
                return contentChanged;
            }
            catch (IOException e) {
                contentChanged = true;
                if (oldContent == null) return contentChanged;
                try {
                    oldContent.close();
                    return contentChanged;
                }
                catch (IOException iOException) {}
                return contentChanged;
            }
        }
        finally {
            if (oldContent != null) {
                try {
                    oldContent.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void updateTraceInformation(IFile traceFile, CharSequence contents, boolean derived) throws CoreException, IOException {
        if (contents instanceof ITraceRegionProvider) {
            AbstractTraceRegion traceRegion = ((ITraceRegionProvider)contents).getTraceRegion();
            if (this.sourceTraces == null) {
                this.sourceTraces = HashMultimap.create();
            }
            IPath tracePath = traceFile.getFullPath();
            TreeIterator iterator = traceRegion.treeIterator();
            while (iterator.hasNext()) {
                AbstractTraceRegion region = (AbstractTraceRegion)iterator.next();
                for (ILocationData location : region.getAssociatedLocations()) {
                    URI path = location.getPath();
                    if (path == null) continue;
                    this.sourceTraces.put((Object)path, (Object)tracePath);
                }
            }
            class AccessibleOutputStream
            extends ByteArrayOutputStream {
                AccessibleOutputStream() {
                }

                byte[] internalBuffer() {
                    return this.buf;
                }

                int internalLength() {
                    return this.count;
                }
            }
            AccessibleOutputStream data = new AccessibleOutputStream();
            this.traceSerializer.writeTraceRegionTo(traceRegion, (OutputStream)data);
            ByteArrayInputStream input = new ByteArrayInputStream(data.internalBuffer(), 0, data.internalLength());
            if (traceFile.exists()) {
                traceFile.setContents((InputStream)input, false, false, this.monitor);
            } else {
                traceFile.create((InputStream)input, true, this.monitor);
            }
            this.setDerived(traceFile, derived);
            return;
        }
        if (traceFile.exists()) {
            traceFile.delete(0, this.monitor);
        }
    }

    @Deprecated
    protected IFile getSmapFile(IFile javaSourceFile) {
        log.warn((Object)"Smap files are no longer generated on disk.");
        return null;
    }

    public void flushSourceTraces() throws CoreException {
        this.flushSourceTraces("default");
    }

    public void flushSourceTraces(String generatorName) throws CoreException {
        if (this.sourceTraces != null) {
            Set keys = this.sourceTraces.keySet();
            for (URI uri : keys) {
                if (!uri.isPlatformResource()) continue;
                Collection paths = this.sourceTraces.get((Object)uri);
                IFile sourceFile = this.workspace.getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
                if (!sourceFile.exists()) continue;
                IPath[] tracePathArray = paths.toArray(new IPath[paths.size()]);
                this.traceMarkers.installMarker(sourceFile, generatorName, tracePathArray);
            }
        }
        this.sourceTraces = null;
    }

    protected boolean isTraceFile(IFile file) {
        return this.fileBasedTraceInformation.isTraceFile((IStorage)file);
    }

    protected IFile getTraceFile(IFile file) {
        IStorage traceFile = this.fileBasedTraceInformation.getTraceFile((IStorage)file);
        if (traceFile instanceof IFile) {
            IFile result = (IFile)traceFile;
            this.syncIfNecessary(result);
            return result;
        }
        return null;
    }

    private void syncIfNecessary(IFile result) {
        this.syncIfNecessary(result, this.monitor);
    }

    private void syncIfNecessary(IFile result, IProgressMonitor progressMonitor) {
        try {
            result.refreshLocal(0, progressMonitor);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void deleteFile(String fileName, String outputName) {
        try {
            IFile file = this.getFile(fileName, outputName);
            this.deleteFile(file, outputName, this.monitor);
        }
        catch (CoreException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public void deleteFile(IFile file, IProgressMonitor monitor) throws CoreException {
        this.deleteFile(file, "DEFAULT_OUTPUT", monitor);
    }

    public void deleteFile(IFile file, String outputName, IProgressMonitor monitor) throws CoreException {
        OutputConfiguration outputConfig = this.getOutputConfig(outputName);
        IFileCallback callBack = this.getCallBack();
        if ((callBack == null || callBack.beforeFileDeletion(file)) && file.exists() && !this.isTraceFile(file)) {
            IFile traceFile = this.getTraceFile(file);
            file.delete(outputConfig.isKeepLocalHistory() != false ? 2 : 0, monitor);
            if (traceFile != null && traceFile.exists()) {
                traceFile.delete(0, monitor);
            }
        }
    }

    protected IFile getFile(String fileName, String outputName) {
        return this.getFile(fileName, outputName, this.monitor);
    }

    protected IFile getFile(String fileName, String outputName, IProgressMonitor progressMonitor) {
        OutputConfiguration configuration = this.getOutputConfig(outputName);
        IContainer container = this.getContainer(configuration);
        IFile result = container.getFile((IPath)new Path(fileName));
        this.syncIfNecessary(result, progressMonitor);
        return result;
    }

    public URI getURI(String path, IProgressMonitor progressMonitor) {
        return this.getURI(path, "DEFAULT_OUTPUT", progressMonitor);
    }

    public URI getURI(String path, String outputConfiguration) {
        return this.getURI(path, outputConfiguration, this.monitor);
    }

    public URI getURI(String path, String outputName, IProgressMonitor progressMonitor) {
        OutputConfiguration configuration = this.getOutputConfig(outputName);
        IContainer container = this.getContainer(configuration);
        IPath childPath = container.getFullPath().append(path).makeAbsolute();
        return URI.createPlatformResourceURI((String)childPath.toString(), (boolean)true);
    }

    public InputStream readBinaryFile(String fileName, IProgressMonitor progressMonitor) {
        return this.readBinaryFile(fileName, "DEFAULT_OUTPUT", progressMonitor);
    }

    public InputStream readBinaryFile(String fileName, String outputCfgName) throws RuntimeIOException {
        return this.readBinaryFile(fileName, outputCfgName, this.monitor);
    }

    public InputStream readBinaryFile(String fileName, String outputCfgName, IProgressMonitor progressMonitor) throws RuntimeIOException {
        try {
            IFile file = this.getFile(fileName, outputCfgName, progressMonitor);
            return new BufferedInputStream(file.getContents());
        }
        catch (CoreException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public CharSequence readTextFile(String fileName, IProgressMonitor progressMonitor) {
        return this.readTextFile(fileName, "DEFAULT_OUTPUT", progressMonitor);
    }

    public CharSequence readTextFile(String fileName, String outputCfgName) throws RuntimeIOException {
        return this.readTextFile(fileName, outputCfgName, this.monitor);
    }

    public CharSequence readTextFile(String fileName, String outputCfgName, IProgressMonitor progressMonitor) throws RuntimeIOException {
        String string;
        IFile file = this.getFile(fileName, outputCfgName, progressMonitor);
        String encoding = this.getEncoding(file);
        BufferedInputStream inputStream = new BufferedInputStream(file.getContents());
        try {
            byte[] bytes = ByteStreams.toByteArray((InputStream)inputStream);
            string = new String(bytes, encoding);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)inputStream).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
            catch (CoreException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }
        ((InputStream)inputStream).close();
        return string;
    }

    public static interface IFileCallback {
        public void afterFileUpdate(IFile var1);

        public void afterFileCreation(IFile var1);

        public boolean beforeFileDeletion(IFile var1);
    }
}

