/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.codetemplates.ui.partialEditing;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.syntaxcoloring.AttributedPosition;
import org.eclipse.xtext.ui.editor.syntaxcoloring.HighlightingPresenter;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ITextAttributeProvider;
import org.eclipse.xtext.ui.editor.syntaxcoloring.MergingHighlightedPositionAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlightingReconciler
implements ITextInputListener,
IXtextModelListener,
IHighlightedPositionAcceptor {
    @Inject(optional=true)
    private ISemanticHighlightingCalculator calculator;
    @Inject
    private ITextAttributeProvider attributeProvider;
    private XtextSourceViewer sourceViewer;
    private HighlightingPresenter presenter;
    private final List<AttributedPosition> addedPositions = new ArrayList<AttributedPosition>();
    private List<AttributedPosition> removedPositions = new ArrayList<AttributedPosition>();
    private int removedPositionCount;
    private final Object fReconcileLock = new Object();
    private boolean reconciling = false;

    private void startReconcilingPositions() {
        this.presenter.addAllPositions(this.removedPositions);
        this.removedPositionCount = this.removedPositions.size();
    }

    private void reconcilePositions(XtextResource resource) {
        MergingHighlightedPositionAcceptor acceptor = new MergingHighlightedPositionAcceptor(this.calculator);
        acceptor.provideHighlightingFor(resource, (IHighlightedPositionAcceptor)this);
        List<AttributedPosition> oldPositions = this.removedPositions;
        ArrayList<AttributedPosition> newPositions = new ArrayList<AttributedPosition>(this.removedPositionCount);
        int i = 0;
        int n = oldPositions.size();
        while (i < n) {
            AttributedPosition current = oldPositions.get(i);
            if (current != null) {
                newPositions.add(current);
            }
            ++i;
        }
        this.removedPositions = newPositions;
    }

    public void addPosition(int offset, int length, String ... ids) {
        TextAttribute highlighting = ids.length == 1 ? this.attributeProvider.getAttribute(ids[0]) : this.attributeProvider.getMergedAttributes(ids);
        boolean isExisting = false;
        int i = 0;
        int n = this.removedPositions.size();
        while (i < n) {
            AttributedPosition position = this.removedPositions.get(i);
            if (position != null && position.isEqual(offset, length, highlighting)) {
                isExisting = true;
                this.removedPositions.set(i, null);
                --this.removedPositionCount;
                break;
            }
            ++i;
        }
        if (!isExisting) {
            AttributedPosition position = this.presenter.createHighlightedPosition(offset, length, highlighting);
            this.addedPositions.add(position);
        }
    }

    private void updatePresentation(TextPresentation textPresentation, List<AttributedPosition> addedPositions, List<AttributedPosition> removedPositions) {
        Runnable runnable = this.presenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        Display display = this.getDisplay();
        display.asyncExec(runnable);
    }

    private Display getDisplay() {
        return this.sourceViewer.getControl().getDisplay();
    }

    private void stopReconcilingPositions() {
        this.removedPositions.clear();
        this.removedPositionCount = 0;
        this.addedPositions.clear();
    }

    public void install(XtextSourceViewer sourceViewer, HighlightingPresenter presenter) {
        this.presenter = presenter;
        this.sourceViewer = sourceViewer;
        if (this.calculator != null) {
            ((IXtextDocument)sourceViewer.getDocument()).addModelListener((IXtextModelListener)this);
            sourceViewer.addTextInputListener((ITextInputListener)this);
        }
        this.refresh();
    }

    public void uninstall() {
        if (this.presenter != null) {
            this.presenter.setCanceled(true);
        }
        if (this.sourceViewer.getDocument() != null && this.calculator != null) {
            XtextDocument document = (XtextDocument)this.sourceViewer.getDocument();
            document.removeModelListener((IXtextModelListener)this);
            this.sourceViewer.removeTextInputListener((ITextInputListener)this);
        }
        this.sourceViewer = null;
        this.presenter = null;
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (oldInput != null) {
            ((IXtextDocument)oldInput).removeModelListener((IXtextModelListener)this);
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput != null) {
            this.refresh();
            ((IXtextDocument)newInput).addModelListener((IXtextModelListener)this);
        }
    }

    public void refresh() {
        if (this.calculator != null) {
            ((XtextDocument)this.sourceViewer.getDocument()).readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource state) throws Exception {
                    HighlightingReconciler.this.modelChanged(state);
                }
            });
        } else {
            Display display = this.getDisplay();
            display.asyncExec(this.presenter.createSimpleUpdateRunnable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modelChanged(XtextResource resource) {
        Object object = this.fReconcileLock;
        synchronized (object) {
            if (this.reconciling) {
                return;
            }
            this.reconciling = true;
        }
        HighlightingPresenter highlightingPresenter = this.presenter;
        try {
            block23: {
                block22: {
                    if (highlightingPresenter == null) break block22;
                    highlightingPresenter.setCanceled(false);
                    if (!highlightingPresenter.isCanceled()) break block23;
                }
                Object object2 = this.fReconcileLock;
                synchronized (object2) {
                    this.reconciling = false;
                    return;
                }
            }
            this.startReconcilingPositions();
            if (!highlightingPresenter.isCanceled()) {
                this.reconcilePositions(resource);
            }
            TextPresentation[] textPresentation = new TextPresentation[1];
            if (!highlightingPresenter.isCanceled()) {
                textPresentation[0] = highlightingPresenter.createPresentation(this.addedPositions, this.removedPositions);
            }
            if (!highlightingPresenter.isCanceled()) {
                this.updatePresentation(textPresentation[0], this.addedPositions, this.removedPositions);
            }
            this.stopReconcilingPositions();
        }
        catch (Throwable throwable) {
            Object object3 = this.fReconcileLock;
            synchronized (object3) {
                this.reconciling = false;
                throw throwable;
            }
        }
        Object object4 = this.fReconcileLock;
        synchronized (object4) {
            this.reconciling = false;
            return;
        }
    }

    public void setCalculator(ISemanticHighlightingCalculator calculator) {
        this.calculator = calculator;
    }

    public ISemanticHighlightingCalculator getCalculator() {
        return this.calculator;
    }
}

