/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.internal.Lists;
import com.google.inject.internal.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NfaUtil {
    protected <SRCSTATE, DSTSTATE> DSTSTATE create(Nfa<SRCSTATE> source, SRCSTATE src, NfaFactory<DSTSTATE, SRCSTATE> factory, Map<SRCSTATE, DSTSTATE> src2dst) {
        DSTSTATE dst = src2dst.get(src);
        if (dst != null) {
            return dst;
        }
        dst = factory.createState(src);
        src2dst.put(src, dst);
        ArrayList dstFollower = Lists.newArrayList();
        for (SRCSTATE srcFollower : source.getFollowers(src)) {
            dstFollower.add(this.create(source, srcFollower, factory, src2dst));
        }
        factory.setFollowers(dst, dstFollower);
        return dst;
    }

    public <SRCSTATE, DSTSTATE> Nfa<DSTSTATE> create(Nfa<SRCSTATE> source, NfaFactory<DSTSTATE, SRCSTATE> factory) {
        HashMap src2dst = Maps.newHashMap();
        DSTSTATE dstStop = factory.createEndState(source.getStop());
        src2dst.put(source.getStop(), dstStop);
        DSTSTATE dstStart = factory.createStartState(source.getStart());
        src2dst.put(source.getStart(), dstStart);
        ArrayList dstFollower = Lists.newArrayList();
        for (SRCSTATE srcFollower : source.getFollowers(source.getStart())) {
            dstFollower.add(this.create(source, srcFollower, factory, src2dst));
        }
        factory.setFollowers(dstStart, dstFollower);
        return factory.createNfa(dstStart, dstStop);
    }

    public <S> Nfa<S> inverse(Nfa<S> nfa) {
        HashMap inverseMap = Maps.newHashMap();
        this.collectedInverseMap(nfa, nfa.getStart(), inverseMap, Sets.newHashSet());
        return new NFAImpl<S>(nfa.getStop(), nfa.getStart(), inverseMap);
    }

    protected <S> void collectedInverseMap(Nfa<S> nfa, S state, Map<S, List<S>> inverseMap, Set<S> visited) {
        if (!visited.add(state)) {
            return;
        }
        for (S follower : nfa.getFollowers(state)) {
            ArrayList inverse = inverseMap.get(follower);
            if (inverse == null) {
                inverse = Lists.newArrayList();
                inverseMap.put(follower, inverse);
            }
            inverse.add(state);
            this.collectedInverseMap(nfa, follower, inverseMap, visited);
        }
    }

    public <S> Map<S, Integer> distanceToFinalStateMap(Nfa<S> nfa) {
        final S stop = nfa.getStop();
        return this.distanceToStateMap(nfa, new Predicate<S>(){

            public boolean apply(S input) {
                return stop == input;
            }
        });
    }

    public <S> Map<S, Integer> distanceToStateMap(Nfa<S> nfa, Predicate<S> matches) {
        return this.distanceFromStateMap(this.inverse(nfa), matches);
    }

    public <S> Map<S, Integer> distanceFromStateMap(Nfa<S> nfa, Predicate<S> matches) {
        HashMap distances = Maps.newHashMap();
        this.collectDistancesForm(nfa, nfa.getStart(), Integer.MAX_VALUE, distances, matches);
        return distances;
    }

    protected <S> void collectDistancesForm(Nfa<S> nfa, S from, int distance, Map<S, Integer> distances, Predicate<S> matches) {
        Integer dist = distances.get(from);
        if (dist != null && dist <= distance) {
            return;
        }
        if (matches.apply(from)) {
            distance = 0;
        }
        distances.put(from, distance);
        if (distance < Integer.MAX_VALUE) {
            ++distance;
        }
        for (S follower : nfa.getFollowers(from)) {
            this.collectDistancesForm(nfa, follower, distance, distances, matches);
        }
    }

    public <S, RESULT> List<RESULT> backtrack(Nfa<S> nfa, RESULT initial, BacktrackHandler<S, RESULT> handler) {
        Stack trace = new Stack();
        trace.push(new BacktrackingItem<RESULT, S>(initial, Collections.singleton(nfa.getStart())));
        S stopState = nfa.getStop();
        block0: while (!trace.isEmpty()) {
            BacktrackingItem item = (BacktrackingItem)trace.peek();
            while (item.followers.hasNext()) {
                Object nextState = item.followers.next();
                RESULT nextResult = handler.handle(nextState, item.result);
                if (nextResult == null) continue;
                Iterable followers = nfa.getFollowers(nextState);
                followers = handler.sortFollowers(nextResult, followers);
                trace.push(new BacktrackingItem(nextResult, followers));
                if (stopState != nextState || !handler.isSolution(nextResult)) continue block0;
                ArrayList result = Lists.newArrayList();
                for (BacktrackingItem backtrackingItem : trace) {
                    result.add(backtrackingItem.result);
                }
                return result;
            }
            trace.pop();
        }
        return null;
    }

    public <S extends Comparable<S>> Nfa<S> sort(Nfa<S> nfa) {
        HashMap followerMap = Maps.newHashMap();
        for (Comparable state : new NfaUtil().collect(nfa)) {
            ArrayList followers = Lists.newArrayList(nfa.getFollowers(state));
            Collections.sort(followers);
            followerMap.put(state, followers);
        }
        return new NFAImpl<Comparable>((Comparable)nfa.getStart(), (Comparable)nfa.getStop(), followerMap);
    }

    public <S, COMP extends Comparable<COMP>> Nfa<S> sort(Nfa<S> nfa, Map<S, COMP> comparator) {
        return this.sort(nfa, new MappedComparator(comparator));
    }

    public <S> Nfa<S> sort(Nfa<S> nfa, Comparator<S> comparator) {
        HashMap followerMap = Maps.newHashMap();
        for (S state : new NfaUtil().collect(nfa)) {
            ArrayList followers = Lists.newArrayList(nfa.getFollowers(state));
            Collections.sort(followers, comparator);
            followerMap.put(state, followers);
        }
        return new NFAImpl<S>(nfa.getStart(), nfa.getStop(), followerMap);
    }

    public <S> Set<S> collect(Nfa<S> nfa) {
        HashSet result = Sets.newHashSet();
        this.collect(nfa, nfa.getStart(), result);
        return result;
    }

    protected <S> void collect(Nfa<S> nfa, S state, Set<S> visited) {
        if (!visited.add(state)) {
            return;
        }
        for (S s : nfa.getFollowers(state)) {
            this.collect(nfa, s, visited);
        }
    }

    protected <S> void collectFollowers(Nfa<S> nfa, S owner, Set<S> result, Set<S> visited, Predicate<S> filter) {
        if (!visited.add(owner)) {
            return;
        }
        if (filter.apply(owner)) {
            result.add(owner);
            return;
        }
        for (S follower : nfa.getFollowers(owner)) {
            this.collectFollowers(nfa, follower, result, visited, filter);
        }
    }

    public <S> Nfa<S> filter(final Nfa<S> nfa, final Predicate<S> filter) {
        return new Nfa<S>(){

            @Override
            public S getStop() {
                return nfa.getStop();
            }

            @Override
            public Set<S> getFollowers(S node) {
                final Object start = nfa.getStart();
                final Object stop = nfa.getStop();
                return NfaUtil.this.filterFollowers(nfa, nfa.getFollowers(node), new Predicate<S>(){

                    public boolean apply(S input) {
                        return input == start || input == stop || filter.apply(input);
                    }
                });
            }

            @Override
            public S getStart() {
                return nfa.getStart();
            }
        };
    }

    public <S> Set<S> filterFollowers(Nfa<S> nfa, Iterable<S> followers, Predicate<S> filter) {
        HashSet result = Sets.newHashSet();
        for (S follower : followers) {
            this.collectFollowers(nfa, follower, result, Sets.newHashSet(), filter);
        }
        return result;
    }

    public <S, ITERABLE extends Iterable<? extends S>> S find(Nfa<S> nfa, Iterable<S> starts, Predicate<S> matcher) {
        HashSet visited = Sets.newHashSet();
        for (S s : starts) {
            S r = this.find(nfa, s, matcher, visited);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public <S, ITERABLE extends Iterable<? extends S>> boolean canReach(Nfa<S> nfa, S state, Predicate<S> matcher) {
        return this.find(nfa, Collections.singleton(state), matcher) != null;
    }

    public <S, ITERABLE extends Iterable<? extends S>> boolean canReachFinalState(Nfa<S> nfa, S state) {
        return this.find(nfa, Collections.singleton(state), Predicates.equalTo(nfa.getStop())) != null;
    }

    public <S> Set<S> findFirst(Nfa<S> nfa, Iterable<S> starts, Predicate<S> match) {
        HashSet current = Sets.newHashSet(starts);
        HashSet visited = Sets.newHashSet();
        while (!current.isEmpty()) {
            HashSet result = Sets.newHashSet();
            for (Object s : current) {
                if (!match.apply(s)) continue;
                result.add(s);
            }
            if (!result.isEmpty()) {
                return result;
            }
            visited.addAll(current);
            HashSet newCurrent = Sets.newHashSet();
            for (Object s : current) {
                Iterables.addAll((Collection)newCurrent, nfa.getFollowers(s));
            }
            newCurrent.removeAll(visited);
            current = newCurrent;
        }
        return Collections.emptySet();
    }

    public <S> S find(Nfa<S> nfa, Predicate<S> matcher) {
        HashSet visited = Sets.newHashSet();
        return this.find(nfa, nfa.getStart(), matcher, visited);
    }

    protected <S, ITERABLE extends Iterable<? extends S>> S find(Nfa<S> nfa, S state, Predicate<S> matcher, Set<S> visited) {
        if (!visited.add(state)) {
            return null;
        }
        if (matcher.apply(state)) {
            return state;
        }
        for (S s : nfa.getFollowers(state)) {
            S r = this.find(nfa, s, matcher, visited);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BacktrackHandler<S, RESULT> {
        public RESULT handle(S var1, RESULT var2);

        public Iterable<S> sortFollowers(RESULT var1, Iterable<S> var2);

        public boolean isSolution(RESULT var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BacktrackingItem<RESULT, S> {
        protected Iterator<S> followers;
        protected RESULT result;

        public BacktrackingItem(RESULT result, Iterable<S> followers) {
            this.result = result;
            this.followers = followers.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MappedComparator<S, COMPARABLE extends Comparable<COMPARABLE>>
    implements Comparator<S> {
        private final Map<S, COMPARABLE> sortBy;

        private MappedComparator(Map<S, COMPARABLE> sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public int compare(S o1, S o2) {
            Comparable c1 = (Comparable)this.sortBy.get(o1);
            if (c1 == null) {
                return 1;
            }
            Comparable c2 = (Comparable)this.sortBy.get(o2);
            if (c2 == null) {
                return -1;
            }
            return c1.compareTo(c2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NFAImpl<S>
    implements Nfa<S> {
        protected final S start;
        protected final S stop;
        protected final Map<S, List<S>> followers;

        @Override
        public S getStop() {
            return this.stop;
        }

        public NFAImpl(S startStates, S finalStates, Map<S, List<S>> followers) {
            this.start = startStates;
            this.stop = finalStates;
            this.followers = followers;
        }

        @Override
        public List<S> getFollowers(S node) {
            List<S> result = this.followers.get(node);
            return result == null ? Collections.emptyList() : result;
        }

        @Override
        public S getStart() {
            return this.start;
        }
    }
}

