/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.xtext.ui.TypeAwareReferenceProposalCreator;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.RepeatedContentAssistProcessor;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.featurecalls.IValidatedEObjectDescription;
import org.eclipse.xtext.xbase.ui.contentassist.MultiNameDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseReferenceProposalCreator
extends TypeAwareReferenceProposalCreator
implements RepeatedContentAssistProcessor.ModeAware {
    private int mode;
    @Inject
    private IQualifiedNameConverter nameConverter;

    public void reset() {
        this.mode = 0;
    }

    public void nextMode() {
        switch (this.mode) {
            case 0: 
            case 7: {
                this.mode = 8;
                return;
            }
            case 1: {
                this.mode = 2;
                return;
            }
            case 2: {
                this.mode = 4;
                return;
            }
            case 4: {
                this.mode = 7;
                return;
            }
            case 8: {
                this.mode = 1;
                return;
            }
        }
        throw new IllegalStateException("mode:" + this.mode);
    }

    public String getNextCategory() {
        switch (this.mode) {
            case 0: 
            case 7: {
                return "smart proposals";
            }
            case 1: {
                return "java-like proposals";
            }
            case 2: {
                return "type proposals";
            }
            case 4: {
                return "all proposals";
            }
            case 8: {
                return "shortest proposals";
            }
        }
        throw new IllegalStateException("mode:" + this.mode);
    }

    public boolean isLastMode() {
        return this.isShowAllProposals();
    }

    protected boolean isShowTypeProposals() {
        return (this.mode & 4) != 0;
    }

    protected boolean isShowShortestSugar() {
        return (this.mode & 1) != 0;
    }

    protected boolean isShowJavaLikeProposals() {
        return (this.mode & 2) != 0;
    }

    protected boolean isShowAllProposals() {
        return this.mode == 7;
    }

    protected boolean isShowSmartProposals() {
        return this.mode == 8;
    }

    public void lookupCrossReference(IScope scope, EObject model, EReference reference, ICompletionProposalAcceptor acceptor, Predicate<IEObjectDescription> filter, Function<IEObjectDescription, ICompletionProposal> proposalFactory) {
        if (TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(this.getEReferenceType(model, reference)) && !this.isShowTypeProposals() && !this.isShowSmartProposals()) {
            return;
        }
        if (!(reference != XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE || this.isShowShortestSugar() || this.isShowJavaLikeProposals() || this.isShowSmartProposals())) {
            return;
        }
        super.lookupCrossReference(scope, model, reference, acceptor, filter, proposalFactory);
    }

    protected Function<IEObjectDescription, ICompletionProposal> getWrappedFactory(EObject model, EReference reference, final Function<IEObjectDescription, ICompletionProposal> proposalFactory) {
        if (!TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(this.getEReferenceType(model, reference))) {
            return new Function<IEObjectDescription, ICompletionProposal>(){

                public ICompletionProposal apply(IEObjectDescription from) {
                    ICompletionProposal result = (ICompletionProposal)proposalFactory.apply((Object)from);
                    if (EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_FEATURE, (EClass)from.getEClass()) && result instanceof ConfigurableCompletionProposal) {
                        EObject eObjectOrProxy = from.getEObjectOrProxy();
                        if (eObjectOrProxy.eIsProxy()) {
                            Image img = null;
                            if (EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_CONSTRUCTOR, (EClass)from.getEClass())) {
                                img = XbaseReferenceProposalCreator.this.computeConstructorImage(false, false, 1, 512);
                            } else if (EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_OPERATION, (EClass)from.getEClass())) {
                                img = XbaseReferenceProposalCreator.this.computeMethodImage(false, 1, 0);
                            } else if (EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_FIELD, (EClass)from.getEClass())) {
                                img = XbaseReferenceProposalCreator.this.computeFieldImage(false, 1, 0);
                            }
                            if (img != null) {
                                ((ConfigurableCompletionProposal)result).setImage(img);
                            }
                        } else {
                            ((ConfigurableCompletionProposal)result).setImage(XbaseReferenceProposalCreator.this.computeImage((JvmFeature)eObjectOrProxy));
                        }
                    }
                    return result;
                }
            };
        }
        return super.getWrappedFactory(model, reference, proposalFactory);
    }

    public Iterable<IEObjectDescription> queryScope(IScope scope, EObject model, EReference reference, Predicate<IEObjectDescription> filter) {
        if (reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE) {
            LinkedHashMap filteredDescriptions = Maps.newLinkedHashMap();
            ArrayList others = Lists.newArrayList();
            Iterable allDescriptions = super.queryScope(scope, model, reference, filter);
            for (IEObjectDescription description : allDescriptions) {
                if (!filter.apply((Object)description)) continue;
                if (description instanceof IValidatedEObjectDescription) {
                    IValidatedEObjectDescription featureDescription = (IValidatedEObjectDescription)description;
                    if (filteredDescriptions.containsKey(featureDescription.getEObjectOrProxy())) {
                        if (!this.isShowShortestSugar() && !this.isShowSmartProposals()) continue;
                        IEObjectDescription previousDescription = (IEObjectDescription)filteredDescriptions.get(featureDescription.getEObjectOrProxy());
                        IValidatedEObjectDescription previousFeatureDescription = null;
                        MultiNameDescription multiNameDescription = null;
                        if (previousDescription instanceof IValidatedEObjectDescription) {
                            previousFeatureDescription = (IValidatedEObjectDescription)previousDescription;
                        } else if (previousDescription instanceof MultiNameDescription) {
                            multiNameDescription = (MultiNameDescription)previousDescription;
                            previousFeatureDescription = (IValidatedEObjectDescription)multiNameDescription.getDelegate();
                        }
                        if (previousFeatureDescription == null) continue;
                        String previousName = this.nameConverter.toString(previousFeatureDescription.getName());
                        String candidateName = this.nameConverter.toString(featureDescription.getName());
                        if (previousName.length() > candidateName.length()) {
                            if (!this.isShowSmartProposals()) {
                                filteredDescriptions.put(featureDescription.getEObjectOrProxy(), featureDescription);
                                if (!this.isShowAllProposals() || !previousFeatureDescription.getKey().endsWith(")")) continue;
                                others.add(previousFeatureDescription);
                                continue;
                            }
                            if (multiNameDescription == null) {
                                multiNameDescription = new MultiNameDescription((IEObjectDescription)featureDescription);
                                multiNameDescription.addOtherName(previousFeatureDescription.getName());
                                filteredDescriptions.put(featureDescription.getEObjectOrProxy(), multiNameDescription);
                                continue;
                            }
                            multiNameDescription.addOtherName(previousFeatureDescription.getName());
                            multiNameDescription.setDelegate((IEObjectDescription)featureDescription);
                            continue;
                        }
                        if (previousName.length() == candidateName.length()) {
                            if (!previousFeatureDescription.getKey().endsWith(")") || this.isShowAllProposals()) continue;
                            if (!previousFeatureDescription.getEObjectOrProxy().eIsProxy() && previousFeatureDescription.getEObjectOrProxy() instanceof JvmExecutable) {
                                JvmExecutable exectuable = (JvmExecutable)previousFeatureDescription.getEObjectOrProxy();
                                if (exectuable.isVarArgs()) continue;
                                filteredDescriptions.put(featureDescription.getEObjectOrProxy(), featureDescription);
                                continue;
                            }
                            filteredDescriptions.put(featureDescription.getEObjectOrProxy(), featureDescription);
                            continue;
                        }
                        if (!this.isShowSmartProposals()) continue;
                        if (multiNameDescription == null) {
                            multiNameDescription = new MultiNameDescription((IEObjectDescription)previousFeatureDescription);
                            multiNameDescription.addOtherName(featureDescription.getName());
                            filteredDescriptions.put(featureDescription.getEObjectOrProxy(), multiNameDescription);
                            continue;
                        }
                        multiNameDescription.addOtherName(featureDescription.getName());
                        continue;
                    }
                    filteredDescriptions.put(featureDescription.getEObjectOrProxy(), featureDescription);
                    continue;
                }
                others.add(description);
            }
            if (!others.isEmpty()) {
                return Iterables.concat((Iterable)others, filteredDescriptions.values());
            }
            return Collections.unmodifiableCollection(filteredDescriptions.values());
        }
        return super.queryScope(scope, model, reference, filter);
    }

    protected Image computeImage(JvmFeature feature) {
        int flags = 0;
        int decorator = 0;
        switch (feature.getVisibility()) {
            case PUBLIC: {
                flags = 1;
                break;
            }
            case PROTECTED: {
                flags = 4;
                break;
            }
            case PRIVATE: {
                flags = 2;
                break;
            }
            case DEFAULT: {
                flags = 0;
            }
        }
        JvmDeclaredType declaringType = feature.getDeclaringType();
        boolean interfaceOrAnnotation = false;
        if (declaringType instanceof JvmGenericType) {
            interfaceOrAnnotation = ((JvmGenericType)declaringType).isInterface();
        } else if (declaringType instanceof JvmAnnotationType) {
            interfaceOrAnnotation = true;
        }
        if (feature instanceof JvmConstructor) {
            decorator = 512;
            if (declaringType.isAbstract()) {
                flags |= 0x400;
                decorator |= 1;
            }
            return this.computeConstructorImage(declaringType.getDeclaringType() != null, interfaceOrAnnotation, flags, decorator);
        }
        if (feature instanceof JvmOperation) {
            JvmOperation operation = (JvmOperation)feature;
            if (operation.isStatic()) {
                flags |= 8;
                decorator |= 8;
            }
            if (operation.isAbstract()) {
                flags |= 0x400;
                decorator |= 1;
            }
            if (operation.isFinal()) {
                flags |= 0x10;
                decorator |= 2;
            }
            return this.computeMethodImage(interfaceOrAnnotation, flags, decorator);
        }
        if (feature instanceof JvmField) {
            JvmField field = (JvmField)feature;
            if (field.isStatic()) {
                flags |= 8;
                decorator |= 8;
            }
            if (field.isFinal()) {
                flags |= 0x10;
                decorator |= 2;
            }
            if (declaringType instanceof JvmEnumerationType) {
                flags |= 0x4000;
            }
            return this.computeFieldImage(interfaceOrAnnotation, flags, decorator);
        }
        return null;
    }

    protected Image computeMethodImage(boolean interfaceOrAnnotation, int modifiers, int decorator) {
        ImageDescriptor baseImage = JavaElementImageProvider.getMethodImageDescriptor((boolean)interfaceOrAnnotation, (int)modifiers);
        return JavaElementImageProvider.getDecoratedImage((ImageDescriptor)baseImage, (int)decorator, (Point)JavaElementImageProvider.BIG_SIZE);
    }

    protected Image computeConstructorImage(boolean inner, boolean interfaceOrAnnotation, int modifiers, int decorator) {
        ImageDescriptor baseImage = JavaElementImageProvider.getTypeImageDescriptor((boolean)inner, (boolean)interfaceOrAnnotation, (int)modifiers, (boolean)false);
        return JavaElementImageProvider.getDecoratedImage((ImageDescriptor)baseImage, (int)decorator, (Point)JavaElementImageProvider.BIG_SIZE);
    }

    protected Image computeFieldImage(boolean interfaceOrAnnotation, int modifiers, int decorator) {
        ImageDescriptor baseImage = JavaElementImageProvider.getFieldImageDescriptor((boolean)interfaceOrAnnotation, (int)modifiers);
        return JavaElementImageProvider.getDecoratedImage((ImageDescriptor)baseImage, (int)decorator, (Point)JavaElementImageProvider.BIG_SIZE);
    }
}

